// license-header java merge-point
//
// Generated by: SessionTest.vsl in andromda-ejb3-cartridge.
//
package book.webstock.services.test;

import javax.naming.NamingException;

import book.webstock.test.EJB3Container;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.mock.SeamTest;
import org.jboss.seam.mock.SeamTest.FacesRequest;

import unnamed.Client;

/**
 * Service test class ClientsServiceTest for testing with TestNG
 * Check the testng.xml for initialisation of the EJB3Container before running any tests.
 */
public class ClientsServiceTest extends SeamTest
{
    private static final Log logger = LogFactory.getLog(ClientsServiceTest.class);
    
    @org.testng.annotations.Test
    public void testAjoutClient() 
    {
        try
        {
            book.webstock.services.ClientsServiceRemote clientsService = (book.webstock.services.ClientsServiceRemote)EJB3Container.getInitialContext().lookup("ClientsServiceBean/remote");
            Client c = new Client("comments", "telephone", "adresse", "prenom", "nom");
            clientsService.ajoutClient(c);
        }
        catch (Exception ex)
        {
            logger.warn("Failed test testAjoutClient()", ex);
        }
    }
    
    @org.testng.annotations.Test
    	public void ValidationTest()throws Exception{
       	 new FacesRequest() {

                @Override
                protected void processValidations() throws Exception
                {
                   validateValue("#{CLIENT.nom}", "NOM  valider");
                   assert !isValidationFailure();
                }
                
                @Override
                protected void updateModelValues() throws Exception
                {
                   setValue("#{CLIENT.nom}", "NOM 2");
                   setValue("#{CLIENT.prenom}", "PRENOM 2");
                   setValue("#{CLIENT.adresse}", "ADRESSE 2");
                   setValue("#{CLIENT.telephone}", "TELEPHONE 2");
                   setValue("#{CLIENT.comments}", "COMMENTS 2");              
                }
                
                @Override
                protected void invokeApplication()
                {
                   invokeMethod("#{ClientsServiceBean2.ajoutClient(CLIENT)}");
                   testListeDesClients();
                }

                @Override
                protected void renderResponse()
                {
                   assert getValue("#{CLIENT.nom}").equals("NOM 2");
                   assert getValue("#{CLIENT.prenom}").equals("PRENOM 2");
                }
                
             }.run();
    }
    
    
    @org.testng.annotations.Test
    public void testListeDesClients() 
    {
        try
        {
            book.webstock.services.ClientsServiceRemote clientsService = (book.webstock.services.ClientsServiceRemote)EJB3Container.getInitialContext().lookup("ClientsServiceBean/remote");
            clientsService.ListeDesClients();
            System.out.println(clientsService.ListeDesClients());
        }
        catch (Exception ex)
        {
            logger.warn("Failed test testListeDesClients()", ex);
        }
    }
    
}