CREATE TABLE WEBSTOCKACCESS(USERID VARCHAR(6) NOT NULL PRIMARY KEY,
NOMUSER VARCHAR(15),MOTDEPASSE VARCHAR(15),
CONSTRAINT SYS_STOCKACCESS UNIQUE(NOMUSER));

CREATE TABLE EMPLOYE (EMPLOYEID VARCHAR (5) NOT NULL PRIMARY KEY, USERID VARCHAR (5) NOT NULL, 
EMPLOYENOM VARCHAR (15) NOT NULL, EMPLOYEPRENOM VARCHAR (10) NOT NULL, ADRESSE VARCHAR (50), 
SALAIRE INTEGER NOT NULL, 
CONSTRAINT FK_EMPLOYE FOREIGN KEY (USERID) REFERENCES WEBSTOCKACCESS(USERID));


CREATE TABLE FOURNISSEUR (FOURNISSEURID VARCHAR (5) NOT NULL PRIMARY KEY, USERID VARCHAR (5) NOT NULL, 
FOURNISSEURNOM VARCHAR (15) NOT NULL, FOURNISSEURPRENOM VARCHAR (15) NOT NULL, ADRESSE VARCHAR (50),
LIMITECREDIT INTEGER NOT NULL, 
CONSTRAINT FK_FOURNISSEUR FOREIGN KEY(USERID) REFERENCES WEBSTOCKACCESS(USERID));


CREATE TABLE CATEGORIE (ARTICLECATEGORIEID VARCHAR (5) NOT NULL PRIMARY KEY, 
ARTICLECATEGORIE VARCHAR (20) NOT NULL);


CREATE TABLE ARTICLE (ARTICLEID VARCHAR (5) NOT NULL PRIMARY KEY, 
NOMARTICLE VARCHAR (30) NOT NULL,ARTICLECATEGORIEID VARCHAR (5), 
FOURNISSEURID VARCHAR (5), DESCRIPTION VARCHAR (50), 
POIDS INTEGER, IMAGE_URL VARCHAR (50),
CONSTRAINT  FK_ARTICLE FOREIGN KEY (FOURNISSEURID) REFERENCES FOURNISSEUR (FOURNISSEURID), 
CONSTRAINT FK_CATEGORIE FOREIGN KEY(ARTICLECATEGORIEID) REFERENCES CATEGORIE(ARTICLECATEGORIEID));


CREATE TABLE INVENTAIRE (NUMEROINVENTAIRE DOUBLE NOT NULL PRIMARY KEY,  ARTICLEID VARCHAR (5),
QUANTITE INT NOT NULL, PRIX INTEGER,
RAYON VARCHAR (3) NOT NULL, REGION VARCHAR (15) NOT NULL,
CONSTRAINT FK_INVENTAIRE FOREIGN KEY (ARTICLEID) REFERENCES ARTICLE(ARTICLEID));

CREATE TABLE CLIENT (CLIENTID VARCHAR(5) NOT NULL PRIMARY KEY, USERID VARCHAR (6), CLIENTNOM VARCHAR (15),
CLIENTPRENOM VARCHAR(10), ADRESSE VARCHAR (50), TEL VARCHAR(10), COMMENT VARCHAR (25),
CONSTRAINT FK_CLIENT FOREIGN KEY (USERID) REFERENCES WEBSTOCKACCESS (USERID));



