/* ConnectController */

#import <Cocoa/Cocoa.h>
#import "ImportController.h"

#import "TaskWrapper.h"

@interface ConnectController : NSObject <TaskWrapperController>
{
    IBOutlet NSButton *cancelButton;
    IBOutlet NSButton *connectButton;
    IBOutlet NSTextField *loginField;
    IBOutlet NSTextField *passField;
    IBOutlet NSPanel *passWindow;

    NSString *login;
    NSString *pass;
    ImportController *importCtrl;

    BOOL isConnected;
    TaskWrapper *connectTask;
}

    // Renvoie le login spcifi
- (NSString *) login;

    // constructeur du ConnectController 
- (ConnectController *) initWithImportCtrl:parentCtrl;

    // vrifier/obtenir le login et le password
- (void) setLoginAndPass;

    // charger le fichier d'interface.
- (void) loadNibFile;

    // afficher le dialogue de demande de mot de passe
- (void) askLoginAndPass;

    // envoyer une image sur le serveur
- (BOOL) sendImage:(id)anImage withId:(int)idImage;

    // constructeur de ConnectController
//- (ConnectController *) init;

    // destructeur de ConnectController
- (void) dealloc;

    // Ferme la fentre d'authentification
- (IBAction) closePassWindow:(id)sender;

@end
