#import "ConnectController.h"
#import "PNImageCell.h"

@implementation ConnectController

/*
 * initWithImportCtrl: :
 * on cre le ConnectController en spcifiant le ImportController
 * qui est li.
 * ==> renvoie le ConnectController cr
 */
- (ConnectController *) initWithImportCtrl:parentCtrl
{
    importCtrl = parentCtrl;
    isConnected = NO;
    connectTask = nil;
    return self;
}

/*
 * closePassWindow:
 * ferme la fentre d'authentification
 */
- (IBAction)closePassWindow:(id)sender
{
    // On repasse en mode non-modal
    [NSApp stopModal];
    if (sender == cancelButton)
        // si l'utilisateur a annul, on doit annuler tout
        // le traitement d'import dans la base.
	[importCtrl setCanceled];
    else {
        // si l'utilisateur a dit OK, on rcupre le login
        // et le password. On fait des retain pour s'assurer
        // qu'ils ne seront pas librs trop tt.
        if (login != nil)
            [login release];
	login = [loginField stringValue];
        [login retain];
        if (pass != nil)
            [pass release];
	pass = [passField stringValue];
        [pass retain];
    }
}

/*
 * setLoginAndPass
 * si le login et le password sont dfinis dans les prfrences,
 * on les rcupre, sinon, on demande  s'authentifier.
 */
- (void) setLoginAndPass
{
    NSUserDefaults*	defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    login = [defaults stringForKey:@"login"];
    [login retain];
    pass = [defaults stringForKey:@"passwd"];
    [pass retain];
    if (([login length] == 0) || ([pass length] == 0)) {
	[self askLoginAndPass];
    }
}

/*
 * loadNibFile
 * chargement du fichier d'interface ConnectView.nib
 * qui contient les lments d'interface lis  la connexion
 * (la fentre d'authentification)
 */
- (void) loadNibFile
{
    // Chargement du fichier
    if (![NSBundle loadNibNamed:@"ConnectView" owner:self])  {
	NSLog(@"Failed to load ConnectView.nib");
	NSBeep();
	return;
    }
    // les fentres dcrites dans ce fichier n'ont pas  apparatre
    // dans le menu des fentres de l'application
    [passWindow setExcludedFromWindowsMenu:YES];
}

/*
 * askLoginAndPass
 * affiche la fentre d'authentification
 */
- (void) askLoginAndPass
{
    // Si la fentre n'est pas charge, on charge le fichier d'interface
    if (passWindow==nil) {
	[self loadNibFile];
    }
    // Si le login est spcifi dans les prfrences, on pr-rempli le champ
    // et on se positionne sur le champ de saisie du mot de passe
    if ([login length] > 0) {
	[loginField setStringValue:login];
	[passWindow setInitialFirstResponder:passField];
    }
    if (passWindow!=nil) {
        // Cration du dialogue modal en forme de feuille
	[NSApp beginSheet:passWindow
           modalForWindow:[NSApp mainWindow]
	    modalDelegate:nil
	   didEndSelector:nil
              contextInfo:nil];
        // lancement du mode modal pour notre dialogue
	[NSApp runModalForWindow:passWindow];
        // arrt du mode modal  la fermeture du dialogue
	[NSApp endSheet:passWindow];
        // affichage du dialogue
	[passWindow orderOut:self];
    }
}

/*
 * processStarted
 * le tche est en cours d'excution
 */
- (void)processStarted
{
    isConnected=YES;
}

/*
 * processStarted
 * le tche est en cours d'excution
 */
- (void)processFinished
{
    isConnected=NO;
}

/*
 * appendOutput:
 * gestion de l'affichage de la commande lance
 * actuellement, on affiche sur la console
 */
- (void)appendOutput:(NSString *)output
{
    NSLog(@"Photo Nav [curl] :%@",output);
}

/*
 * sendImage:withId:
 * envoi d'une image sur le serveur
 * ==> renvoie YES si le code retour de la commande est 0
 */
- (BOOL) sendImage:(id)anImage withId:(int)idImage
{
    // Cration des chaines reprsentant les paramtres de curl

    // paramtre pour l'authentification de la forme  -u<login>:<password>
    NSString *authStr = [NSString stringWithFormat:@"-u%@:%@",login,pass];

    // paramtre pour l'URL, doit contenir le nom du fichier destination
    NSString *destURL = [NSString stringWithFormat:@"ftp://%@/../Shared/PhotoNav/%d.%@",
        [[NSUserDefaults standardUserDefaults] stringForKey:@"serverHostname"],
        idImage,
        [[anImage fullImageName] pathExtension]];

    // paramtre pour spcifier l'envoi du fichier local <filepath>
    // de la forme    -T<filepath>
    NSString *fileOpt = [NSString stringWithFormat:@"-T%@",
        [anImage fullImageName]];

    // La commande  lancer :
    //NSString *command = @"/Users/Jayce/bin/essai.sh";
    NSString *command = @"/usr/bin/curl";

    // cration d'un tableau contenant la commande en premier lment et
    // les arguments en lments suivant
    NSArray *curlcmd = [NSArray arrayWithObjects:command,
        authStr,
        fileOpt,
        destURL,
        nil];

    if (isConnected)
    {
        // si une connexion est dj en cours, on stoppe tout traitement
        [connectTask stopProcess];
        [connectTask release];
        connectTask=nil;
        return NO;
    }
    else
    {
        if (connectTask!=nil)
            [connectTask release];
        NSLog(@"Commande : %@",[curlcmd componentsJoinedByString:@" "]);
        // cration du TaskWrapper avec la command et ses arguments.
        connectTask=[[TaskWrapper alloc] initWithController:self arguments:curlcmd];
        // lancement de la connexion
        [connectTask startProcess];
        // on attend la fin de la connexion et on rcupre le code retour
        int theResult = [connectTask waitForResult];

        NSLog(@"theResult == %d\n",theResult);
        [self processFinished];
        // on renvoie YES si le code retour vaut 0
        return (theResult == 0);
    }
}

/*
 * dealloc
 * destructeur de ConnectController.
 * fait le mnage dans les objets crs par ConnectController
 */
- (void) dealloc
{
    if (connectTask!=nil)
        [connectTask release];
    if (login != nil)
        [login release];
    if (pass != nil)
        [pass release];
    // aprs le traitement spcifique, on appelle le destructeur standard
    [super dealloc];
}

/*
- (ConnectController *) init
{
    isConnected = NO;
    connectTask = nil;
    return self;
}
*/

/*
 * login
 * accesseur pour le paramtre login
 * utile pour rcuprer le login depuis d'autres classes (DBController par exemple)
 */
- (NSString *) login
{
    return login;
}

@end
