//
//  DBController.m
//  Photo Nav
//

#import "DBController.h"
#import "OpenBaseWrapper.h"
#import "PNImageCell.h"

@implementation DBController

- (DBController *) init
{
    dbWrapper = [[DBWrapperName alloc] init];
    return self;
}

- (void) dealloc
{
    if (dbWrapper != nil)
        [dbWrapper release];
}

- (int) generateIdImage
{
    return [dbWrapper sendWithIntResultSQLCommand:@"newid for Image idImage"];
}

- (void) sendInfosForImage:(id)anImage withId:(int)idImage andLogin:(NSString *)login
{
    int idUser;
    int idCategory;

    idUser = [self getIdUserForImage:anImage withLogin:login];
    [self insertImage:anImage withId:idImage andIdUser:idUser];
    idCategory = [self setCategoryForImage:anImage];
    [self linkImageId:idImage withCategoryId:idCategory];
    [self setPriceForImage:anImage withId:idImage];
}

- (int) getIdUserForImage:(id)anImage withLogin:(NSString *)login
{
    NSString *sqlCommand;
    int id = 0;
    sqlCommand = [NSString stringWithFormat:@"select idUtilisateur from Utilisateur where login like '%@'", login];
    id = [dbWrapper sendWithIntResultSQLCommand:sqlCommand];
    if (id != 0)
        return id;
    sqlCommand = [NSString stringWithFormat:@"newid for Utilisateur idUtilisateur"];
    id = [dbWrapper sendWithIntResultSQLCommand:sqlCommand];
    NSString *nom = [[NSUserDefaults standardUserDefaults] stringForKey:@"lastname"];
    NSString *prenom = [[NSUserDefaults standardUserDefaults] stringForKey:@"firstname"];
    if (([nom length] == 0) && ([prenom length] == 0))
        nom = [anImage realAuthor];
    
    sqlCommand = [NSString stringWithFormat:@"insert into Utilisateur(idUtilisateur, login, nom, prenom, password) values (%d, '%@', '%@', '%@', '')",
        id,
        login,
        nom,
        prenom];

    if ([dbWrapper sendWithBoolResultSQLCommand:sqlCommand])
        return id;
    else return 0;
}

- (void) insertImage:(id)anImage withId:(int)idImage andIdUser:(int)idUser
{
    NSString *sqlCommand;
    NSString *path = [NSString stringWithFormat:@"Shared/PhotoNav/%d.%@",
        idImage,
        [[anImage fullImageName] pathExtension]];
    sqlCommand = [NSString stringWithFormat:@"insert into Image(idImage, idUtilisateur, dateCreation, cheminImage, libelle) values (%d, %d, '%@', '%@', '%@')",
        idImage,
        idUser,
        [anImage realDate],
        path,
        [anImage realTitle]];
    [dbWrapper sendWithBoolResultSQLCommand:sqlCommand];
}

- (int) setCategoryForImage:(id)anImage
{
    NSString *sqlCommand;
    int id = 0;
    sqlCommand = [NSString stringWithFormat:@"select idCategorie from Categorie where libelle like '%@'", [anImage category]];
    id = [dbWrapper sendWithIntResultSQLCommand:sqlCommand];
    if (id != 0)
        return id;
    sqlCommand = [NSString stringWithFormat:@"newid for Categorie idCategorie"];
    id = [dbWrapper sendWithIntResultSQLCommand:sqlCommand];
    sqlCommand = [NSString stringWithFormat:@"insert into Categorie(idCategorie, libelle) values (%d, '%@')",
        id,
        [anImage category]];

    if ([dbWrapper sendWithBoolResultSQLCommand:sqlCommand])
        return id;
    else return 0;    
}

- (void) linkImageId:(int)idImage withCategoryId:(int)idCategory
{
    NSString *sqlCommand;
    sqlCommand = [NSString stringWithFormat:@"insert into LienCategorieImage(idImage, idCategorie) values (%d, %d)",
        idImage,
        idCategory];
    [dbWrapper sendWithBoolResultSQLCommand:sqlCommand];
}

- (void) setPriceForImage:(id)anImage withId:(int)idImage
{
    NSString *sqlCommand;
    int id = 0, tarif = 0;
    sqlCommand = [NSString stringWithFormat:@"newid for TarifImage idTarif"];
    id = [dbWrapper sendWithIntResultSQLCommand:sqlCommand];
    
    tarif = (int) floorf([anImage price]);
    sqlCommand = [NSString stringWithFormat:@"insert into TarifImage(idTarif, idImage, tarif, dateDebut) values (%d, %d, %d, 'function NOW()')",
        id,
        idImage,
        tarif];
    [dbWrapper sendWithBoolResultSQLCommand:sqlCommand];    
}


@end
