//
//  ImportController.m
//  Photo Nav
//

#import "ImportController.h"
#import "ConnectController.h"
#import "PNImageCell.h"
#import "DBController.h"

@implementation ImportController

/*
 * importImages:
 * lancement du processus d'importation dans la base
 * des images slectionnes.
 */
- (void) importImages:(NSArray*)selectedImages
{
    if (! [self haveServerHostname]) {
	NSLog(@"Pas de serveur dfini !");
        // On demande  notre vue (ImportView) d'afficher un dialogue d'erreur
	ImportView *myView = [[[ImportView alloc] init] autorelease];
	[myView errAlert:NSLocalizedString(@"You don't have a hostname specified in your preferences. Please specify one.", @"There is no server defined in preferences.") withTitle:NSLocalizedString(@"Configuration Error", @"Configuration Error Title")];
    }
    else {
        // Cration du contrleur de connexion
        connectCtrl = [[ConnectController alloc] initWithImportCtrl:self];
	[connectCtrl autorelease];
	isCanceled = NO;
        // On vrifie la prsence du login et du password
	[connectCtrl setLoginAndPass];
        // Si l'utilisateur annule, on sort sans rien faire
	if (isCanceled) return;

        // cration d'un enumerator pour parcourir les images slectionnes
        NSEnumerator*   enumerator = [selectedImages objectEnumerator];
        id anImage;

        // cration du contrleur d'accs  la base de donnes
        dbCtrl = [[DBController alloc] init];
        [dbCtrl autorelease];

        int idImage;
        while(anImage = [enumerator nextObject])
        {
            // lancement du traitement pour chaque image
            NSLog(@"Traitement de l'image : %@",[anImage getBaseName]);
            idImage=0;
            // si l'utilisateur a annul, on arrte tout traitement
            if (isCanceled) break;
            // si tous les champs ncessaires pour l'image ne sont pas prsents
            // on ne traite pas l'image et on passe  la suivante
            if (![self verifyInfosForImage:anImage]) continue;
            // si on n'a pas pu gnrer un identifiant pour l'image, on ne traite
            // pas l'image et on passe  la suivante
            if ((idImage = [dbCtrl generateIdImage]) == 0) continue;
            // si l'envoi de l'image ne s'est pas bien pass, on passe
            //  l'image suivante sans mettre les infos dans la base
            if (![connectCtrl sendImage:anImage withId:idImage]) continue;
            // on ajoute les informations sur l'image dans la base
            [dbCtrl sendInfosForImage:anImage withId:idImage andLogin:[connectCtrl login]];
        }
    }
}

/*
 * verifyInfosForImages:
 * vrification des informations sur une image
 */
- (BOOL) verifyInfosForImage:(id)anImage
{
    BOOL isOK=YES;
    // Si aucune catgorie n'est spcifie, on est en erreur
    if ([anImage category] == nil)
        isOK = NO;
    // Si il manque des infos, on affiche un dialogue d'erreur
    // permettant d'annuler le traitement ou de continuer avec les images
    // suivantes
    if (! isOK) {
        // le dialogue est gr par la vue de notre contrleur : ImportView
        ImportView *myView = [[[ImportView alloc] init] autorelease];
        NSString *errMsg = [NSString stringWithFormat:NSLocalizedString(@"Informations for the picture %@ are incomplete. Do you want to stop the import to Database now or continue ?", @"Missing infos on image (%@)"),[anImage getBaseName]];
        [myView errOkCancel:errMsg withTitle:NSLocalizedString(@"Missing Information", @"Missing Information Error Title") withResponseTo:self];
    }
    return isOK;
}

/*
 * closeErrOkCancel:
 * ferme la fentre d'erreur
 * si l'utilisateur a annul, on positionne le boolen pour arrter tout traitement
 */
- (void)closeErrOkCancel:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
    if (returnCode == NSAlertAlternateReturn)
        [self setCanceled];
    // arrt du mode modal
    [NSApp stopModal];
    // on libre a mmoire occupe par le dialogue
    NSReleaseAlertPanel(sheet);
}

/*
 * setCanceled
 * accesseur pour le boolen isCanceled
 */
- (void) setCanceled
{
    isCanceled = YES;
}

/*
 * haveServerHostname
 * vrifie si le host du serveur est dfini dans les prfrences
 */
- (BOOL) haveServerHostname
{
    NSUserDefaults*	defaults;
    defaults = [NSUserDefaults standardUserDefaults];
    return ([[defaults stringForKey:@"serverHostname"] length] != 0);
}

@end
