//
//  ImportView.m
//  Photo Nav
//

#import "ImportView.h"
#import "ImportController.h"

@implementation ImportView

- (void) errAlert:(NSString *)errMsg withTitle:(NSString *)errTitle
{
    // cration d'une alerte critique
    NSBeginCriticalAlertSheet(errTitle, @"", nil, nil, [NSApp mainWindow], nil, nil, nil, nil, errMsg);
}

- (void) errOkCancel:(NSString *)errMsg withTitle:(NSString *)errTitle withResponseTo:(id)importCtrl
{
    NSWindow *mySheet;
    // cration d'une fentre d'alerte critique
    mySheet = NSGetCriticalAlertPanel(errTitle, errMsg, NSLocalizedString(@"Continue", @"Continue Button Label"), NSLocalizedString(@"Cancel", @"Cancel Button Label"), nil);
    // affichage en mode modal de cette alerte sous forme de feuille
    [NSApp beginSheet:mySheet
       modalForWindow:[NSApp mainWindow]
               modalDelegate:importCtrl
       didEndSelector:@selector(closeErrOkCancel:returnCode:contextInfo:)
          contextInfo:nil];
    [NSApp runModalForWindow:mySheet];
    [NSApp endSheet:mySheet];
    [mySheet orderOut:self];
}

@end
