//
//  OpenBaseWrapper.m
//  Photo Nav
//

#import "OpenBaseWrapper.h"


@implementation OpenBaseWrapper

- (int) sendWithIntResultSQLCommand:(NSString *)sqlCmd
{
    int returnCode = 0;
    int result = 0;
    OpenBase *connection = [[OpenBase alloc] init];
    NSUserDefaults*	defaults;

    [sqlCmd retain];

    defaults = [NSUserDefaults standardUserDefaults];

    if (! [connection connectToDatabase: "Photo_Base"
                                 onHost: [[defaults stringForKey:@"serverHostname"] cString]
                                  login: ""
                               password: ""
                                 return: &returnCode] ) {
        NSLog( @"Impossible de se connecter.");
        [sqlCmd release];
        return result;
    }

    [connection makeCommand:[sqlCmd cString]];

    if ([connection executeCommand] && [connection resultReturned]) {
        [connection bindInt:&result];
        [connection nextRow];
    }
    else {
        NSLog( @"Impossible d'executer la commande.");
        [connection invalidate];
    }

    if (connection != nil) [connection release];
    [sqlCmd release];
    return result;
}

- (BOOL) sendWithBoolResultSQLCommand:(NSString *)sqlCmd
{
    int returnCode = 0;
    BOOL result = NO;
    OpenBase *connection = [[OpenBase alloc] init];
    NSUserDefaults*	defaults;

    [sqlCmd retain];

    defaults = [NSUserDefaults standardUserDefaults];

    if (! [connection connectToDatabase: "Photo_Base"
                                 onHost: [[defaults stringForKey:@"serverHostname"] cString]
                                  login: ""
                               password: ""
                                 return: &returnCode] ) {
        NSLog( @"Impossible de se connecter.");
        [sqlCmd release];
        return result;
    }

    [connection makeCommand:[sqlCmd cString]];

    if ([connection executeCommand]) {
        result = YES;
    }
    else {
        NSLog(sqlCmd);
        NSLog( @"Impossible d'executer la commande.");
        [connection invalidate];
    }

    if (connection != nil) [connection release];
    [sqlCmd release];
    return result;
}

@end
