//
//  PNImageCell.m
//  Photo Nav
//
//  Created by Jacques on Thu Dec 05 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//

#import "PNImageCell.h"

@implementation PNImageCell

- (NSString *) realTitle
{
    if (([self title] == nil) || ([[self title] length] == 0))
        return [self getBaseName];
    return [self title];
}

- (NSString *) realDate
{
    NSString *theDateFormat = @"%d-%d-%d 00:00:00";
    if ((day == 0) || (month == 0) || (year == 0)) {
        NSCalendarDate *current = [NSCalendarDate calendarDate];
        [current autorelease];
        return [NSString stringWithFormat:theDateFormat,
            [current dayOfMonth],
            [current monthOfYear],
            [current yearOfCommonEra]];
    }
    return [NSString stringWithFormat:theDateFormat, year, month, day];
}

- (NSString *) realAuthor
{
    if (([self author] == nil) || ([[self author] length] == 0))
        return NSFullUserName();
    return [self author];
}

- (NSString *) getBaseName
{
    return [[self fullImageName] lastPathComponent];
}

- (void)setTag:(int)newTag
{
    Tag = newTag;
}
- (int)Tag
{
    return Tag;
}


- (id)imageID
{
    return imageID;
}

- (void)setImageID:(NSString *)newImageID
{
    [newImageID retain];
    [imageID release];
    imageID = newImageID;
}

- (NSString *)fullImageName
{
    return fullImageName;
}

- (void)setFullImageName:(NSString *)newFullImageName
{
    [newFullImageName retain];
    [fullImageName release];
    fullImageName = newFullImageName;
}

- (NSString *)title
{
    return title;
}

- (void)setTitle:(NSString *)newTitle
{
    [newTitle retain];
    [title release];
    title = newTitle;
}

- (NSString *)author
{
    return author;
}
- (void)setAuthor:(NSString *)newAuthor
{
    [newAuthor retain];
    [author release];
    author = newAuthor;
}

- (NSString* )category
{
    return category;
}
- (void)setCategory:(NSString *)newCategory
{
    [newCategory retain];
    [category release];
    category = newCategory;
}

- (float)price
{
    return price;
}
- (void)setPrice:(float)newPrice;
{
    price = newPrice;
}

- (int)day
{
    return day;
}
- (void)setDay:(int)newDay
{
    day = newDay;
}

- (int)month
{
    return month;
}
- (void)setMonth:(int)newMonth
{
    month = newMonth;
}

- (int)year
{
    return year;
}
- (void)setYear:(int)newYear
{
    year = newYear;
}
@end
