#import "PhotoNavController.h"
#import "PNImageCell.h"
#import "ImportController.h"

@implementation PhotoNavController

// Dfinition des variables utilises par la NSToolbar.

static NSString*	photoNavToolbarIdentifier 		= @"photoNav Toolbar Identifier";
NSString*		photoNavToolbarOpenIdentifier		= @"photoNav Open Identifier";
NSString*		photoNavToolbarReloadIdentifier		= @"photoNav Reload identifier";
NSString*		photoNavToolbarExportIdentifier		= @"photoNav Export Identifier";
NSString*		photoNavToolbarInspecteurIdentifier	= @"photoNav Inspecteur Identifier";
NSString*		photoNavToolbarDeleteIdentifier		= @"photonav Delete Identifier";

- (void)awakeFromNib
{
    // Appel  la mthode de mise en place de la barre d'outil
    [self setupToolbar];
}

// Mthode de la barre d'outils

-(void)setupToolbar
{
    // Un pointeur sur une fentre, celle qui contiendra la barre d'outil

    NSWindow	*win;

    // Un pointeur sur un objet de type NSToolbar

    NSToolbar *theToolbar = [[[NSToolbar alloc] initWithIdentifier: photoNavToolbarIdentifier] autorelease];

    // Mise en place de quelque proprit de la barre d'outil
    [theToolbar setAllowsUserCustomization: YES];
    [theToolbar setAutosavesConfiguration: YES];
    [theToolbar setDisplayMode: NSToolbarDisplayModeIconAndLabel];

    [theToolbar setDelegate:self];

    // On initialize le pointeur vers la fentre en indiquant que c'est celle qui contient
    // tel ou tel autre lment. Ici notre NSMatrix.

    win = [theMatrix window];

    // NSWindow a une mthode pour afficher la barre d'outil que nous venons de dfinir
    [win setToolbar:theToolbar];
}

- (NSToolbarItem *) toolbar: (NSToolbar *)toolbar itemForItemIdentifier: (NSString *) itemIdent willBeInsertedIntoToolbar:(BOOL) willBeInserted {

    // Dfinition d'un NSToolBarItem

    NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier: itemIdent] autorelease];

    if ([itemIdent isEqual: photoNavToolbarOpenIdentifier]) {
        [toolbarItem setLabel:NSLocalizedString(@"Open a Directory", @"Open a Directory Toolbar label")];
        [toolbarItem setPaletteLabel:NSLocalizedString(@"Open a Directory", @"Open a Directory Palette label")];
        [toolbarItem setToolTip:NSLocalizedString(@"Open a Directory containing image files", @"Open a Directory ToolTip label")];
        [toolbarItem setImage: [NSImage imageNamed: @"lecture"]];
        // Indique quel message sera envoy quand le bouton sera cliqu
        [toolbarItem setTarget: self];
        [toolbarItem setAction: @selector(openDirectory:)];
    } else if ([itemIdent isEqual: photoNavToolbarReloadIdentifier]) {
        [toolbarItem setLabel:NSLocalizedString(@"Reload Directory", @"Reload current Directory Toolbar label")];
        [toolbarItem setPaletteLabel:NSLocalizedString(@"Reload Directory", @"Reload current Directory Palette lable")];
        [toolbarItem setToolTip:NSLocalizedString(@"Reload current Directory", @"Reload current Directory ToolTip label")];
        [toolbarItem setImage: [NSImage imageNamed: @"relecture"]];
        // Indique quel message sera envoy quand le bouton sera cliqu
        [toolbarItem setTarget: self];
        [toolbarItem setAction: @selector(reloadDirectory:)];
    } else if ([itemIdent isEqual: photoNavToolbarExportIdentifier]) {
        [toolbarItem setLabel:NSLocalizedString(@"Export to Database", @"Export to Database Toolbar label")];
        [toolbarItem setPaletteLabel:NSLocalizedString(@"Export to Database", @"Export to Database Palette label")];
        [toolbarItem setToolTip:NSLocalizedString(@"Export to Database selected images", @"Export to Database TooTip label")];
        [toolbarItem setImage: [NSImage imageNamed: @"2DB"]];
        // Indique quel message sera envoy quand le bouton sera cliqu
        [toolbarItem setTarget: self];
        [toolbarItem setAction: @selector(export2DB:)];
    } else if ([itemIdent isEqual: photoNavToolbarInspecteurIdentifier]) {
        [toolbarItem setLabel:NSLocalizedString(@"Inspector", @"Inspector Toolbar label")];
        [toolbarItem setPaletteLabel:NSLocalizedString(@"Inspector", @"Inspector Palette label")];
        [toolbarItem setToolTip:NSLocalizedString(@"Inspector", @"Inspector ToolTip label")];
        [toolbarItem setImage: [NSImage imageNamed: @"inspecteur"]];
        // Indique quel message sera envoy quand le bouton sera cliqu
        [toolbarItem setTarget: self];
        [toolbarItem setAction: @selector(callInspector:)];
    } else if ([itemIdent isEqual: photoNavToolbarDeleteIdentifier]) {
        [toolbarItem setLabel:NSLocalizedString(@"Delete", @"Delete Toolbar label")];
        [toolbarItem setPaletteLabel:NSLocalizedString(@"Delete", @"Delete Palette label")];
        [toolbarItem setToolTip:NSLocalizedString(@"Delete selected files", @"Delete ToolTip label")];
        [toolbarItem setImage: [NSImage imageNamed: @"poubelle"]];
        // Indique quel message sera envoy quand le bouton sera cliqu
        [toolbarItem setTarget: self];
        [toolbarItem setAction: @selector(deleteFile:)];
    } else {
        toolbarItem = nil;
    }
    return toolbarItem;
}

- (NSArray *) toolbarDefaultItemIdentifiers: (NSToolbar *) toolbar {
    // Required delegate method:  Returns the ordered list of items to be shown in the toolbar by default
    // If during the toolbar's initialization, no overriding values are found in the user defaults, or if the
    // user chooses to revert to the default items this set will be used
    return [NSArray arrayWithObjects:
        photoNavToolbarOpenIdentifier,
        photoNavToolbarReloadIdentifier,
        photoNavToolbarExportIdentifier,
        photoNavToolbarInspecteurIdentifier,
        photoNavToolbarDeleteIdentifier,
        NSToolbarFlexibleSpaceItemIdentifier,
        NSToolbarCustomizeToolbarItemIdentifier,
        nil];
}

- (NSArray *) toolbarAllowedItemIdentifiers: (NSToolbar *) toolbar {
    // Required delegate method:  Returns the list of all allowed items by identifier.  By default, the toolbar
    // does not assume any items are allowed, even the separator.  So, every allowed item must be explicitly listed
    // The set of allowed items is used to construct the customization palette
    return [NSArray arrayWithObjects:
        photoNavToolbarOpenIdentifier,
        photoNavToolbarReloadIdentifier,
        photoNavToolbarExportIdentifier,
        photoNavToolbarInspecteurIdentifier,
        photoNavToolbarDeleteIdentifier,
        NSToolbarFlexibleSpaceItemIdentifier,
        NSToolbarCustomizeToolbarItemIdentifier,
        NSToolbarPrintItemIdentifier,
        NSToolbarShowFontsItemIdentifier,
        nil];
}

- (IBAction)callInspector:(id)sender
{

    // Variables ncessaires
    NSImage*	aPicture;		// Une image
    NSArray*	localArray;		// Un tableau qui contiendra les images slectionne

    //	On rempli le tableau local avec les cellules slectionnes
    localArray = [theMatrix selectedCells];

    // Dbut d'un aiguillage. Slection multiple ou slection simple (plusieurs ou une images)
    
    if ([localArray count] >1)		// Si il y a plus d'un image slectionnes
    {
        aPicture = [NSImage imageNamed:@"multiple"];	// On utilise une image gnrique qui reprsente la slection multiple
        [authorField setStringValue:NSFullUserName()];	// On rcupre le nom du l'utilisateur et on l'affiche dans le champs prvus
        [priceField setFloatValue:500];			// On affiche le prix dans le champs prvus

        // On initialise une variable qui va nous permettre d'avoir la date systme
        NSCalendarDate*	aDate = [[NSCalendarDate date] dateWithCalendarFormat:nil timeZone:nil];

        // On dcompose la date
        int day = [aDate dayOfMonth];
        int month = [aDate monthOfYear];
        int year = [aDate yearOfCommonEra];

        // On affiche les lments dcoompos dans les champs prvus
        [dayField setIntValue:day];

        // Pour le menu des mois, on slectionne l'item du numro du mois -1
        // -1 parce que l'item "janvier" porte le numro 0 dans le menu
        [monthMenu selectItemAtIndex:month-1];
        [yearField setIntValue:year];

        // On fixe le menu de catgorie sur le premier item du menu
        [categoryMenu selectItemAtIndex:0];

        // On rend le champ de titre non-modifiable
        [titleField setEditable:NO];
    }
    else		// Sinon, slection unique
    {
        // On utilise l'image slectionne
        aPicture = [[NSImage alloc] initWithContentsOfFile:[[localArray objectAtIndex:0] fullImageName]];

        [titleField setEditable:YES];		// On rend le champs titre ditable
        [titleField setStringValue:@""];	// On y met une chane vide


        // Il faut remplir les diffrents champs
        // Si il y a dj une valeur dans les variables de PNImacCell qui correspond
        //  l'image slectione, on affiche cette valeur
        // si on affiche une veleur par dfaut
        
        if([[localArray objectAtIndex:0] author] != nil)
        {
            [authorField setStringValue:[[localArray objectAtIndex:0] author]]; // On connait l'auteur
        }
        else									// Sinon
        {
            [authorField setStringValue:NSFullUserName()];			// On met le nom de l'utilsateur
        }

        // Pas de sinon pour le titre, il est dj mise  vide plus haut.
        if([[localArray objectAtIndex:0] title] != nil)
        {
            [titleField setStringValue:[[localArray objectAtIndex:0] title]];	// On connait le titre
        }

        if([[localArray objectAtIndex:0] price] != 0)
        {
            [priceField setFloatValue:[[localArray objectAtIndex:0] price]];	// On connait le prix
        }
        else									// sinon
        {	
            [priceField setFloatValue:500];					// On met une valeur par dfaut
        }

        // Vrification que la date est valide
        BOOL valide = [self validateDay:[[localArray objectAtIndex:0] day] month:[[localArray objectAtIndex:0] month] year:[[localArray objectAtIndex:0] year]];

        // Si la date est valide on la raffiche
        if(valide == YES)
        {
            [dayField setIntValue:[[localArray objectAtIndex:0] day]];
            [monthMenu selectItemAtIndex:[[localArray objectAtIndex:0] month] -1];
            [yearField setIntValue:[[localArray objectAtIndex:0] year]];
        }
        else		// Sinon, on remet la date du jour
        {
            NSCalendarDate*	aDate = [[NSCalendarDate date] dateWithCalendarFormat:nil timeZone:nil];

            int day = [aDate dayOfMonth];
            int month = [aDate monthOfYear];
            int year = [aDate yearOfCommonEra];

            [dayField setIntValue:day];
            [monthMenu selectItemAtIndex:month-1];
            [yearField setIntValue:year];
        }

        if([[localArray objectAtIndex:0] category] != nil)	
        {
            [categoryMenu selectItemWithTitle:[[localArray objectAtIndex:0] category]];	// On connait la catgorie
        }
        else										// Sinon
        {
            [categoryMenu selectItemAtIndex:0];						// On met l'item 0 du menu
        }
    }

    // Fin de l'aiguillage slection multiple / slection simple
    
    [currentImage setImage:aPicture];			// On affiche l'image			
    [aPicture release];					// On rcupre la mmoire utilis par l'image
    [inspectorWindow makeKeyAndOrderFront:self];	// On met l'inspecteur au premier pal
}

- (IBAction)deleteFile:(id)sender
{
    NSBeginCriticalAlertSheet(NSLocalizedString(@"Are you sure you want to delete these files ?",@"Are you sure to delete these files"),			// Title
                              NSLocalizedString(@"Delete",@"Delete"),				// Default button
                              NSLocalizedString(@"Cancel",@"Cancel"),				// Alternate Button
                              nil,								// Other Button
                              [theScrollView window],						// docWindow
                              self,								// modal Delegate
                              @selector(closeDeleteSheet:returnCode:contextInfo:),		// selector to method
                              NULL,								// dismiss method
                              nil,								// contextInfo
                              NSLocalizedString(@"There is no undo for this operation.",@"There is no undo for this operation."));
}

- (IBAction)export2DB:(id)sender
{
    NSArray *arrayOfCells = [theMatrix selectedCells];
    // On appelle ImportController que si on a des images selectionnees :
    if ([arrayOfCells count] > 0) {
	ImportController *importC = [[[ImportController alloc] init] autorelease];
	[importC importImages:arrayOfCells];
    }
}

- (IBAction)openDirectory:(id)sender
{

    // Dfinition d'une variable qui reprsente le panneau
    NSOpenPanel* panel = [NSOpenPanel openPanel];
    NSLog(@"Nous sommes dans openAction");

    // Par ces deux paremtres nous indiquons que l'on peut choisir un rpertoire, et que l'on ne
    // peu pas choisir un fichier spcifique.
    [panel setCanChooseDirectories: YES];
    [panel setCanChooseFiles: NO];

    // Appel du paaneau, le resultat sera mis dans la variable result
    int result = [panel runModalForDirectory: NSHomeDirectory()
                                    file:nil
                                   types:nil];

    //Traitement du retour du panneau : que contient la variable result
    if (result == NSOKButton) {				// L'utilisateur a choisis "ok"

        // Rcupration du chemin du rpertoire choisi dans path
        NSString* path = [panel filename];
        NSLog(@"path == %@\n",path);

        // Appel du manager de fichier
        NSFileManager* fileManager = [NSFileManager defaultManager];

        // Nous allons iterer sur les fichiers contenus dans le dossier
        // Dfinition d'un object qui va nous aider a passer d'un fichier a l'autre
        NSDirectoryEnumerator* enumerator = [fileManager enumeratorAtPath: path];
        [enumerator skipDescendents];

        // Deux variables, une pour le chermin du fichier (son nom)
        // une pour mettre le chemin complet vers l'image (depuis /)
        NSString* filepath;
        NSString* fullPath;

        // Initialisation du tableau qui stockera les chemins vers les images
        imagePathArray = [[NSMutableArray alloc] init];

        // Essentiel, la boucle de lecture.
        // Tant que l'enumerateur renvois autre chose que nil
        while ((filepath = (NSString*)[enumerator nextObject]) != nil) {
            fullPath = [[NSString alloc] initWithString:path];	// On stock dans fullPath le chemin du rpertoire
            fullPath = [fullPath stringByAppendingPathComponent:filepath]; // On cr la variable fullPath
            [imagePathArray addObject: fullPath];		// On stock fullPath dans le tableau
        }

        // On initialise la variable currentWorkingDirectoryPath avec le chemin vers le rpertoire
        currentWorkingDirectoryPath = [[NSString alloc] initWithString:path];

        // On va afficher les images dont le chemin est dans le tableau imagePathArray
        [theMatrix afficheImage:self imageArray:imagePathArray];
    }
    /*[panel beginSheetForDirectory:NSHomeDirectory() file:nil
                   modalForWindow:[theScrollView window]
                    modalDelegate:self
                   didEndSelector:@selector(openPanelDidEnd:returnCode:contextInfo:)
                      contextInfo:NULL];*/

}

/*- (void) openPanelDidEnd:(NSOpenPanel *)panel returnCode:(int)returnCode
             contextInfo:(void  *)contextInfo
{
    imagePathArray = [[NSMutableArray alloc] init];
    if(returnCode == NSOKButton)
    {
        NSString* path;
        NSFileManager* fileManager;
        NSDirectoryEnumerator* enumerator;
        NSString* filepath;
        NSString* fullPath;
        fileManager = [NSFileManager defaultManager];
        path = [panel filename];
        //NSLog(@"path = %@",path);
        // Nous allons iterer sur les fichiers contenus dans le dossier
        enumerator = [fileManager enumeratorAtPath: path];
        [enumerator skipDescendents];
        while ((filepath = (NSString*)[enumerator nextObject]) != nil)
        {
            fullPath = [path stringByAppendingPathComponent:filepath];
            //NSLog(@"fullPath = %@", fullPath);
            [imagePathArray addObject: fullPath];
        }
        // On initialise la variable currentWorkingDirectoryPath avec le chemin vers le rpertoire
        currentWorkingDirectoryPath = [[NSString alloc] initWithString:path];
        [theMatrix afficheImage:self imageArray:imagePathArray];
    }
}*/

- (void) closeDeleteSheet:(NSWindow *)sheet returnCode:(int)returnCode
             contextInfo:(void  *)contextInfo
{
    if(returnCode == NSAlertDefaultReturn)
    {
        // Dans la cas du yes.
        NSArray*	localArray = [theMatrix selectedCells];
        NSFileManager*	fileManager = [NSFileManager defaultManager];
        NSEnumerator*	enumerator = [localArray objectEnumerator];
        id anObject;
    
        while(anObject = [enumerator nextObject])
        {
            int currentTag = [anObject Tag];
            
            if ([fileManager removeFileAtPath:[anObject fullImageName] handler:nil] == YES)
            {
                [imagePathArray removeObjectAtIndex:currentTag];
            }
            [theMatrix afficheImage:self imageArray:imagePathArray];
        }
    }
}

- (IBAction)reloadDirectory:(id)sender
{
    [imagePathArray release];

    if(!currentWorkingDirectoryPath)
    {
        [self openDirectory:sender];
    }
    else
    {
       // NSArray* files = [panel filenames];
       // NSString* path = (NSString*)[files objectAtIndex:0];
        NSString* path = currentWorkingDirectoryPath;
        NSLog(@"path == %@\n",path);

        NSFileManager* fileManager = [NSFileManager defaultManager];

        // Nous allons iterer sur les fichiers contenus dans le dossier
        NSDirectoryEnumerator* enumerator = [fileManager enumeratorAtPath: path];
        [enumerator skipDescendents];

        NSString* filepath;
        NSString* fullPath;

        imagePathArray = [[NSMutableArray alloc] init];

        while ((filepath = (NSString*)[enumerator nextObject]) != nil) {
            fullPath = [[NSString alloc] initWithString:path];
            fullPath = [fullPath stringByAppendingPathComponent:filepath];
            [imagePathArray addObject: fullPath];
        }
        [theMatrix afficheImage:self imageArray:imagePathArray];
    }
}


// Cette mthode est appelle quand la fentre est ferme
// soit par un bouton spcifique, soit par le bouton
// traditionnel de fermeture de fentre.

- (BOOL)windowShouldClose:(NSWindow *)sender
{
    if (sender == inspectorWindow) {
        // Il faut ici sauvegarder les infos qui ont t changes

        // Le principe est le mme qui pour mettre les valeurs dans les champs
        // de l'inspecteur

        // Nous avons besoin d'un tableau avec les cellules slectionnes
        // Et d'un numerateur d'objet pour parcourir le tableau
        NSArray*	multipleCells = [theMatrix selectedCells];
        NSEnumerator*	enumerator = [multipleCells objectEnumerator];

        // un object sans typage (en fait il s'agira lors de l'xcution d'un PNImageCell
        id anObject;

        // Tant que l'numrateur d'objet trouve un objet dans le tableau des
        // cellules slectionne
        while(anObject = [enumerator nextObject])
        {
            [anObject setAuthor:[authorField stringValue]];		// On rcupre l'auteur dans le champs
            [anObject setTitle:[titleField stringValue]];		// On rcupre le titre
            [anObject setCategory:[categoryMenu titleOfSelectedItem]];	// On rcupre la catgorie dans le menu
            [anObject setDay:[dayField intValue]];			// On rcupre le jour
            [anObject setMonth:[monthMenu indexOfSelectedItem] +1];	// On rcupre le mois
            [anObject setYear:[yearField intValue]];			// On rcupre l'anne
            [anObject setPrice:[priceField floatValue]];		// On rcupre le prix
        } // fin de la boucle
    }
    
    // Si jamais on retour NO, la fentre ne sera pas ferme
    return(YES);
}


// Une fonction rapide pour dterminer si une anne est bisetiles ou non
#define isGregorianLeap(year) (((((year) % 4) == 0 && (((year) % 100) != 0)) || ((year) % 400) == 0))

- (BOOL)validateDay:(int)day month:(int)month year:(int)year
{
    BOOL result = YES;			// Un boolen (OUI/NON) pour le rsultat

    if(month < 1 || month > 12)		// Si le mois est infrieur a 1 ou suprieur a 12
    {
        result = NO;			// La date n'est pas valide
    }
    else if(day < 1 || day > 31)	// Si le jour est infrieur a 1 ou suprieur a 31	
    {
        result = NO;			// La date n'est pas valide
    }
    else if(month == 2 || month == 4 || month == 6 || month == 9 || month == 11)
    {					// Si le mois est 2, 4, 6, 9 ou 11
        if(month == 2)			// Si le mois est 2
        {
            if(! isGregorianLeap(year))	// Si l'anne n'est pas bisetille
            {
                if(day > 28)		// Si le mois a plus de 28 jours
                {
                    result = NO;	// La date n'est pas valide
                }
                else
                {
                    result = YES;	// La date est valide
                }
            }
        } else				// Dans le cas des autres mois
        {
            if (day > 30)		// Si le jour est suprieur a 30
            {
                result = NO;		// La date n'est pas valide
            }
        }
    }
    return result;			// On renvois le boolen 
}

- (void)dealloc
{
    [imagePathArray release];
    [super dealloc];
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApp
{
    return YES;
}

@end

