/* PreferencesController */
/* Gnr par Interface Builder
*/
#import "PreferencesController.h"

@implementation PreferencesController

/* awakeFromNib
Excut au chargement du fichier de ressource (.nib)
*/
- (void)awakeFromNib
{
    NSUserDefaults*	defaults;			// pour lire les prfrences de l'utilisateur

    defaults = [NSUserDefaults standardUserDefaults];	// les prfrences standard

    /* On positionne les valeurs par dfaut des champs
        Si il y a une valeur dans les prfrences, on met cette valeur
        Si il n'y a pas de valeur dans les prfrences, on met la version localise d'un chaine par dfaut
    */
    [firstnameField setStringValue:([defaults stringForKey:@"firstname"] == nil)?NSLocalizedString(@"Your firstname", @"User firstname"):[defaults stringForKey:@"firstname"]];
    
    [lastnameField setStringValue:([defaults stringForKey:@"lastname"] == nil)?NSLocalizedString(@"Your lastname", @"User lastname"):[defaults stringForKey:@"lastname"]];

    if ([defaults stringForKey:@"serverHostname"] != nil)
	[hostField setStringValue:[defaults stringForKey:@"serverHostname"]];

    if ([defaults stringForKey:@"login"] != nil)
	[loginField setStringValue:[defaults stringForKey:@"login"]];

    if ([defaults stringForKey:@"passwd"] != nil)
	[passwdField setStringValue:[defaults stringForKey:@"passwd"]];
    
}

/* writePrefs
On crit dans le fichier de prfrence les valeurs qui sont dans les champs de saisie
*/
- (IBAction)writePrefs:(id)sender
{
    /* Dans le mme mouvement on va lire les champs de saisie [xxxField stringVelue]
    et on met la valeur lue dans le dictionnaire des prfrences [setObjet:xxxx forkey"@"yyy"] */
    
    [[NSUserDefaults standardUserDefaults] setObject:[firstnameField stringValue] forKey:@"firstname"];
    [[NSUserDefaults standardUserDefaults] setObject:[lastnameField stringValue] forKey:@"lastname"];
    [[NSUserDefaults standardUserDefaults] setObject:[loginField stringValue] forKey:@"login"];
    [[NSUserDefaults standardUserDefaults] setObject:[hostField stringValue] forKey:@"serverHostname"];
    [[NSUserDefaults standardUserDefaults] setObject:[passwdField stringValue] forKey:@"passwd"];

    [[sender window]performClose:self];				// fermeture de la fenetre
    [[NSUserDefaults standardUserDefaults] synchronize];	// on synchronise le dictionnaire en mmoire avec le fichier sur disque
}

@end
