// Facture.java
// Created on Sat Dec 07 14:14:52 Europe/Paris 2002 by Apple EOModeler Version 5.0

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import java.math.BigDecimal;
import java.util.*;

public class Facture extends EOGenericRecord {

    public Facture() {
        super();
    }

/*
    // If you implement the following constructor EOF will use it to
    // create your objects, otherwise it will use the default
    // constructor. For maximum performance, you should only
    // implement this constructor if you depend on the arguments.
    public Facture(EOEditingContext context, EOClassDescription classDesc, EOGlobalID gid) {
        super(context, classDesc, gid);
    }

    // If you add instance variables to store property values you
    // should add empty implementions of the Serialization methods
    // to avoid unnecessary overhead (the properties will be
    // serialized for you in the superclass).
    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
    }
*/

    public NSTimestamp dateCreation() {
        return (NSTimestamp)storedValueForKey("dateCreation");
    }

    public void setDateCreation(NSTimestamp value) {
        takeStoredValueForKey(value, "dateCreation");
    }

    public Utilisateur utilisateur() {
        return (Utilisateur)storedValueForKey("utilisateur");
    }

    public void setUtilisateur(Utilisateur value) {
        takeStoredValueForKey(value, "utilisateur");
    }

    public NSArray images() {
        return (NSArray)storedValueForKey("images");
    }

    public void setImages(NSMutableArray value) {
        takeStoredValueForKey(value, "images");
    }

    public void addToImages(Image object) {
        NSMutableArray array = (NSMutableArray)images();

        willChange();
        array.addObject(object);
    }

    public void removeFromImages(Image object) {
        NSMutableArray array = (NSMutableArray)images();

        willChange();
        array.removeObject(object);
    }

    public Number montantFacture() {
	double tmpMontant = 0.0;

        if (images() == null) {
            // Si aucun article n'est prsent, on retourne null
            return (null);
        }

        // On itre sur la liste des images, et on additionne les montants
        Enumeration enumerateur = images().objectEnumerator();

        while (enumerateur.hasMoreElements()) {
            Image tmpImage = (Image)enumerateur.nextElement();
            Number tmpMontantImage = tmpImage.montantPourDate(dateCreation());

            if (tmpMontantImage != null) {
                tmpMontant += tmpMontantImage.doubleValue();
            }
        }

        return (new Double(tmpMontant));
    }

    public Number montantActuelFacture() {
        if (images() == null) {
            // Si aucun article n'est prsent, on retourne null
            return (null);
        }

        return ((Number)images().valueForKey("@sum.montantActuel"));
    }
}
