//
// VisualisationImage.java: Class file for WO Component 'VisualisationImage'
// Project PhotoWeb
//
// Created by jpl on Sat Dec 07 2002
//

import com.webobjects.foundation.*;
import com.webobjects.appserver.*;
import com.webobjects.eocontrol.*;
import com.webobjects.eoaccess.*;

public class VisualisationImage extends WOComponent {
    private Image image;
    
    public VisualisationImage(WOContext context) {
        super(context);
    }

    public Image image() {
        return (image);
    }

    public void setImage(Image uneImage) {
        image = uneImage;

        // Ajout d'un vnement de consultation

        // On rcupre le type d'vnement
        TypeEvenement tmpType =
            TypeEvenement.TypeEvenementPourLibelle(session().defaultEditingContext(),
                                                   TypeEvenement.LibelleTypeEvenementConsultation);
        
        // On instancie un nouvel vnement
        Evenement nouvelEvenement = new Evenement();
        nouvelEvenement.setDateCreation(new NSTimestamp());

        // On set le type d'vnement
        nouvelEvenement.setTypeEvenement(tmpType);
        
        // On insre le nouvel vnement dans l'editingContext
        session().defaultEditingContext().insertObject(nouvelEvenement);

        // On ajoute l'utilisateur (s'il n'existe pas, on set  null)
        nouvelEvenement.setUtilisateur(((Session)session()).utilisateur());
                                        
        // On ajoute l'image
        nouvelEvenement.setImage(image);

        // On sauve l'editingContext
        session().defaultEditingContext().saveChanges();
    }

    public WOComponent acheterImage() {
        // On ajoute l'image  la session
        ((Session)session()).setImageSelectionnee(image);

        if (((Session)session()).utilisateur() == null) {
            // Si l'utilisateur n'est pas identifi, on lui demande de le faire
            return (pageWithName("IdentificationUtilisateur"));
        }

        // Si l'utilisateur s'est dj identifi
        return (null);
    }
}
