<?php
   $file = "livres.xml";
   $TagCourrant = "";
   $titreValeur = "";        // Value of the titre element 
   $auteursValeur = array(); // Array of the values of the auteur elements 
   $isbnValeur = "";         // Value of the isbn element
   $prixValeur = "";        // Value of the prix element
   $monnaieValeur = "";     // Value of the livre element's monnaie attribute
   $descriptionValeur = "";  // Value of the description entity reference
   $auteurCpt=0;          // Variable used to populate the $auteursValeur array
   $livres = array();           // Contains the details of livres.

function startElement($parser, $nom, $attr) {
   global $TagCourrant, $monnaieValeur;
   $TagCourrant = $nom;
   if (strcmp($nom, "prix") == 0)
      $monnaieValeur = $attr["monnaie"];
   }
   function endElement($parser, $nom) {
      global $titreValeur, $auteursValeur, $isbnValeur, $prixValeur,
             $monnaieValeur, $livres, $auteurCpt, $descriptionValeur;
      if (strcmp($nom, "livre") == 0) {
         $livres[] = array("titre"=>$titreValeur, 
                          "auteurs" =>$auteursValeur, 
                          "isbn" => $isbnValeur, 
                          "prix" =>$prixValeur,
                          "monnaie" =>$monnaieValeur,
                          "description" =>$descriptionValeur) ;
         $titreValeur = "";
         $auteursValeur = array();
         $isbnValeur = "";
         $prixValeur = "";
         $auteurCpt=0;
         $monnaieValeur="";
         $descriptionValeur = "";
      } elseif (strcmp($nom, "auteur")== 0) {
         $auteurCpt++;
         $auteursValeur[$auteurCpt] = "";
      }
   }
   function characterData($parser, $data) {
      global $titreValeur, $auteursValeur, $isbnValeur,$prixValeur, 
             $TagCourrant, $auteurCpt;
      if (strcmp($TagCourrant, "titre") == 0) {
         $titreValeur .= $data;
      } elseif (strcmp($TagCourrant, "auteur") == 0) {
         $auteursValeur[$auteurCpt] .= $data;
      } elseif (strcmp($TagCourrant, "isbn") == 0) {
         $isbnValeur .= $data;
      } elseif (strcmp($TagCourrant, "prix") == 0) {
         $prixValeur .= $data;
      }
   }
   function externalEntityHandler($parser, $entityName, $base, 
                                  $systemId, $publicId) {
      global $descriptionValeur;
      if (!systemId)
         return false;
      $descriptionValeur = $systemId;
      return true;
   }
   function LireInfoLivre() {
      global $file, $livres;
      $xml_parser = xml_parser_create();
      xml_set_element_handler($xml_parser, "startElement", "endElement");
      xml_set_character_data_handler($xml_parser,"characterData");
      xml_set_external_entity_ref_handler($xml_parser, "externalEntityHandler");
      xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, false);
   if (!($fp = fopen($file, "r"))) {
      die("Could not open $file for reading") ;
   }
   while (($data = fread($fp, 4096))) {
      if (!xml_parse($xml_parser, $data, feof($fp))){
         die(sprintf("XML error at line %d column %d", 
                      xml_get_current_line_number($xml_parser), 
                      xml_get_current_column_number($xml_parser)));
      }
   }
      xml_parser_free($xml_parser);
      return $livres;
   }
   function afficheInfoLivre($titreValeur, $auteursValeur, $isbnValeur, $prixValeur, 
                          $monnaieValeur) {
      print "<TR>";
      print "<TD><A HREF=\"display_description.php?isbn=$isbnValeur\">
           $titreValeur</A></TD>";
      print "<TD>";
      for($j=0; $j<count($auteursValeur)-1; $j++) {
         if ($j !=0)
            print ",";
         print " $auteursValeur[$j] ";
      }
      print "</TD>";
      print "<TD>$isbnValeur</TD>";
      print "<TD>$prixValeur $monnaieValeur</TD>";
      print "</TR>";
   }
   function RechercheParISBN($livres, $isbn) {
      for($i = 0; $i < count($livres); $i++) {
         if (strcmp(trim($livres[$i]["isbn"]), trim($isbn)) == 0) {
            return $livres[$i];
         }
      }
      return null;
   }
?>

