<HTML>
   <HEAD>
      <TITLE>Table of Contents</TITLE>
   </HEAD>
   <BODY>
      <?php
         require("common.php");

         $currentTag1 = "";     // Name of the element that is being parsed 
         $chapters = array();   // Array of the values of chapter elements
         $chapterNo=0;          // Variable used to populate the $chapters array
         $appendixes = array(); // Array of the values of appendix elements
         $appendixNo=0;         // Variable used to populate the $appendix array
                  function startElement1($parser, $name, $attr) {
            global $currentTag1;
            $currentTag1 = $name;
         }
         function endElement1($parser, $name) {
            global $chapterNo, $appendixNo;

            if (strcmp($name, "chapter") == 0) {
               $chapterNo++;
            } else if (strcmp($name, "appendix") == 0) {
               $appendixNo++ ;
            }
         }

         function characterData1($parser, $data) {
            global $chapters, $chapterNo, $appendixes, $appendixNo,
                   $currentTag1;

            if (strcmp($currentTag1, "chapter")==0) {
               $chapters[$chapterNo] .= $data;
            } else if (strcmp($currentTag1, "appendix") == 0) {
               $appendixes[$appendixNo] .= $data;
            }
         }

         $books = readBookInfo();
         if (!($book = searchBookByISBN($books, $isbn))) {
            die ("Boom with ISBN $isbn does not exist") ;
         }

         $titleValue = $book["title"];
         $authors = $book["authors"];
         for($j=0, $authorValue=""; $j < count($authors)-1; $j++) {
            if ($j != 0)
               $authorsValue .= ", ";
            $authorsValue .= $authors[$j];
         }

         print "<B><FONT SIZE=6>$titleValue</FONT></B>";
         print "<BR>";
         print "by ";
         for ($j=0; $j < count($authors)-1; $j++) { 
            if ($j != 0)
               print ", ";
            print "$authors[$j]";
         }

         $xml_parser = xml_parser_create();
         xml_set_element_handler($xml_parser, "startElement1", "endElement1");
         xml_set_character_data_handler($xml_parser,"characterData1");
         xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, false);

         if (!($fp = fopen($book["description"], "r"))) {
            die("Could not open $file for reading");
         }
         while (($data = fread($fp, 4096))) {
            if (!xml_parse($xml_parser, $data, feof($fp))) {
               die(sprintf("XML error at line %d column %d",
               xml_get_current_line_number($xml_parser),
               xml_get_current_column_number($xml_parser))) ;
            }
         }

        xml_parser_free($xml_parser) ;
      ?>

      <HR><BR>
      <B>Table of Contents</B>
      <BR><BR>
      <?php
         for ($i=0; $i < count($chapters)-1; $i++) {
            print "Chapter ".($i+1).": $chapters[$i] <BR>";
         }
         print "<BR>";

         for($i=0; $i < count($appendixes)-1; $i++) {
            $j = chr(ord("A") + $i);
            printf("Appendix %s: %s <BR>\n", $j, $appendixes[$i]);
         }
      ?>
   </BODY>
</HTML>

