CONNECT boutique ;

CREATE TABLE profil_utilisateur (
         nom VARCHAR(40) NOT NULL,
         id_utilisateur VARCHAR(20) NOT NULL,
         motdepasse VARCHAR(20) NOT NULL,
         adresse_ligne1 VARCHAR(40) NOT NULL,
         adresse_ligne2 VARCHAR(40) DEFAULT NULL,
         ville VARCHAR(20) NOT NULL,
         pays VARCHAR(20) NOT NULL,
         codepostal VARCHAR(20) NOT NULL,
         sexe VARCHAR(20) NOT NULL,
         age VARCHAR(20) NOT NULL,
         adresse_email VARCHAR(20) NOT NULL,
         telephone VARCHAR(20) NOT NULL,
         no_carte VARCHAR(20) NOT NULL,
         date_expiration VARCHAR(20) NOT NULL,
         type_carte VARCHAR(20) NOT NULL,
         solde_compte FLOAT NOT NULL,
         PRIMARY KEY(id_utilisateur));

CREATE TABLE boutique_livre (
         no_article VARCHAR(20) NOT NULL,
         type_article VARCHAR(20) NOT NULL,
         titre VARCHAR(60) NOT NULL,
         auteur VARCHAR(60) NOT NULL,
         prix float NOT NULL,
         PRIMARY KEY(no_article)); 

CREATE TABLE boutique_musique (
         no_article VARCHAR(20) NOT NULL,
         type_article VARCHAR(20) NOT NULL,
         titre VARCHAR(60) NOT NULL,
         artiste VARCHAR(60) NOT NULL,
         prix float NOT NULL,
         PRIMARY KEY(no_article)); 

CREATE TABLE transaction (
         no_commande INT NOT NULL primary key auto_increment,
         id_utilisateur VARCHAR(20) NOT NULL,
         no_article VARCHAR(20) NOT NULL,
         quantite INT NOT NULL DEFAULT 0,
         date date NOT NULL,
         etat VARCHAR(20) NOT NULL);

GRANT ALL PRIVILEGES ON boutique.* TO php@localhost identified by 'php' ;

GRANT ALL PRIVILEGES ON boutique.* TO php@"%" identified by 'php' ;

CREATE INDEX index_on_livre_no_article ON boutique_livre(no_article) ;

CREATE INDEX index_on_livre_titre ON boutique_livre(titre) ;

CREATE INDEX index_on_livre_auteur ON boutique_livre(auteur) ;

CREATE INDEX index_on_musique_no_article ON boutique_musique(no_article) ;

CREATE INDEX index_on_musique_titre ON boutique_musique(titre) ;

CREATE INDEX index_on_musique_artiste ON boutique_musique(artiste) ;
