<?php function display_menu() { ?>

<FORM ENCTYPE="multipart/form-data">
   <INPUT TYPE=SUBMIT NAME=action VALUE=" New Entry ">&nbsp;
   <INPUT TYPE=SUBMIT NAME=action VALUE=" Overview ">&nbsp;
   Search: <INPUT TYPE=TEXT NAME=word>
   <INPUT TYPE=SUBMIT NAME=action VALUE=" Search ">&nbsp;
   CSV import: <INPUT TYPE=FILE NAME=csvfile>
   <INPUT TYPE=SUBMIT NAME=action VALUE=" CSV import "><BR><BR>

</FORM>

<? } ?>

<?php function overview_start() { ?>
<FORM>
   <TABLE>
      <TR>
         <TH>Nom</TH>
         <TH>Slection</TH>
      </TR>
<? } ?>

<?php function overview_entry($data) { ?>
      <TR>
         <TD><?echo $data["name"]?></TD>
         <TD><INPUT TYPE=RADIO NAME=id VALUE="<?echo $data["id"]?>">
      </TR>
<? } ?>

<?php function overview_end() { ?>

   </TABLE>

   <INPUT TYPE=SUBMIT NAME=action VALUE=" Edit ">
   <INPUT TYPE=SUBMIT NAME=action VALUE=" View ">
   <INPUT TYPE=SUBMIT NAME=action VALUE=" Delete ">
</FORM>

<? } ?>

<?php

function action_overview() {
   global $dbpath, $dbtype;

   $db = dba_open($dbpath, "r", $dbtype);

   if(!$db) {
      echo "Database open failed";
      return -1;
   }

   overview_start();
   $key = dba_firstkey($db);
	
   while ($key != false) {
      $value = dba_fetch($key, $db);
      $entry = unserialize($value);
      overview_entry($entry);
      $key = dba_nextkey($db);
   }

   overview_end();
   dba_close($db);
}

function search_keyword($db, $keyword) {
   $r = array();
	
   $key = dba_firstkey($db);
	
   $count = 1;
   while($key != false) {
      $value = dba_fetch($key, $db);
      if(ereg($keyword, $value)) {
         $r[$count] = $value;
         $count++;
      }
      $key = dba_nextkey($db);
   }
   return $r;
}

function action_search($keyword) {
   global $dbpath, $dbtype;

   $db = dba_open($dbpath, "r", $dbtype);

   if(!$db) {
      echo "Database open failed";
      return;
   }

   $matches = search_keyword($db, $keyword);

   dba_close($db);

   $nr = count($matches);
   echo "Search found $nr " . (($nr == 1) ? "entry.<P>" : "entries.<P>");

   overview_start();
   for($i = 1; $i <= $nr; $i++) {
      overview_entry(unserialize($matches[$i]));
   }
   overview_end();
}

function action_delete($id) {
   global $dbpath, $dbtype;
	
   $db = dba_open($dbpath, "w", $dbtype);

   if(!$db) {
      echo("Database open failed");
      return;
   }

   dba_delete($id, $db);
   echo("Entry $id successfully deleted");
   dba_sync($db);
   dba_close($db);
}

?>

<?php function display_entry($data) { ?>

<B>Name: <? echo($data["name"]); ?></B><P>
E-mail: <? echo($data["email"]); ?><P>
Tel no: <? echo($data["telno"]); ?><P>
Address: <? echo(nl2br($data["address"])); ?><P>
	
<? } ?>

<?php

function action_view($id) {
   global $dbpath, $dbtype;

   $db = dba_open($dbpath, "r", $dbtype);

   if(!$db) {
      echo "database open failed";
      return;
   }

   $value = dba_fetch($id, $db);
   $data = unserialize($value);

   dba_close($db);
	
   display_entry($data);
}

?>

<?php function edit_form($data) { ?>

<FORM>
   <INPUT TYPE=HIDDEN NAME="action" VALUE="update">
   <INPUT TYPE=HIDDEN NAME=id VALUE="<? echo($data["id"]); ?>">

   Name: <INPUT TYPE=TEXT NAME=name VALUE="<? echo($data["name"]); ?>"><P>
   E-mail: <INPUT TYPE=TEXT NAME=email VALUE="<? echo($data["email"]); ?>"><P>
   Tel no: <INPUT TYPE=TEXT NAME=telno VALUE="<? echo($data["telno"]); ?>"><P>
   Address: <TEXTAREA ROWS=4 COLS=40 NAME=address>
      <? echo($data["address"]); ?>
   </TEXTAREA><P>

   <INPUT TYPE=SUBMIT VALUE="   OK   ">
</FORM>

<? } ?>

<?php

function action_edit($id) {
   global $dbpath, $dbtype;

   $db = dba_open($dbpath, "r", $dbtype);

   if (!$db) {
      echo("database open failed");
      return;
   }

   $value = dba_fetch($id, $db);
   $data = unserialize($value);

   dba_close($db);

   edit_form($data);
}

function action_update($data) {
   global $dbpath, $dbtype;

   $db = dba_open($dbpath, "c", $dbtype);

   if(!$db) {
      echo "Database open failed";
      return;
   }
	
   dba_replace($data["id"], serialize($data), $db);
   dba_sync($db);
   dba_close($db);
}

function get_next_id($db) {
   $max_id = 0;
	
   $key = dba_firstkey($db);
   while($key != false) {
      if ($key > $max_id) {
         $max_id = $key;
      }
      $key = dba_nextkey($db);
   }
   return $max_id + 1;
}

function action_new() {
   global $dbpath, $dbtype;

   if (is_file($dbpath)) {
      $db = dba_open($dbpath, "r", $dbtype);
   } else {
      $db = dba_open($dbpath, "c", $dbtype);
   }

   if(!$db) {
      echo "database open failed";
      return;
   }

   $data = array();
   $data["id"] = get_next_id($db);

   dba_close($db);
   edit_form($data);
}

function csv_import($path) {
   global $dbpath, $dbtype, $vars;
	
   $db = dba_open($dbpath, "c", $dbtype, "0644");

   if(!$db) {
      echo "db open failed";
      return -1;
   }

   $fp = fopen($path, "r");
	
   if(!$fp) {
      dba_close($db);
      echo "Cannot open CSV file ($path)";
      return -1;
   }

   $id = get_next_id($db);
   $nr_entries = 0;
	
   while(!feof($fp)) {
      $data = fgetcsv($fp, 4096);
			
      if (is_array($data) && count($data) > 0) {
         $new = array();
         for($i = 0; $i < count($data); $i++) {
            $new[$vars[$i]] = $data[$i];
         }
         $new["id"] = $id;
         dba_replace($id, serialize($new), $db);
         $id++;
         $nr_entries++;
      }
   }
	
   fclose($fp);
   dba_sync($db);
   dba_close($db);

   return $nr_entries;
}

function action_csv_import() {
   global $csvfile;

   $csvfile = stripslashes($csvfile);

   if($csvfile != "") {
      $nr = csv_import($csvfile);
      if ($nr > 0) {
         echo "import successful - $nr entries imported.<p>";
      } else if($nr == 0) {
         echo "Import did not find any entries.<p>";
      } else {
         echo "import failed<p>";
      }
   } else {
      echo "please select a file and try again.<p>";
   }
}

// ***** Configure the following part

// path to the database
$dbpath = "database.db";

// database type
$dbtype = "db2";

$data = array();
$vars = array("name","email","telno","address","id");

for($i = 0; $i < count($vars); $i++) {
   $data[$vars[$i]] = ${$vars[$i]};
}

display_menu();

$action = strtolower(trim($action));

switch($action) {
   case "search":
      action_search($word);
      break;
   case "view":
      action_view($id);
      break;
   case "overview":
      action_overview();
      break;
   case "edit":
      action_edit($id);
      break;
   case "delete":
      action_delete($id);
      break;
   case "csv import":
      action_csv_import();
      break;
   case "new entry":
      action_new();
      break;
   case "update":
      action_update($data);
      break;
}

?>