<?php
   // First we define the handler functions to inform the parser what action to
   // take on encountering a specific type of node.

   // We'll just print out element opening and closing tags and character data

   // The handler for element opening tags
   function startElementHandler($parser, $name, $attribs) {
      echo("&lt;$name&gt;<BR>");
   }
   // The handler for element closing tags
   function endElementHandler($parser, $name) {
      echo("&lt;/$name&gt;<BR>");
   }

   // The handler for character data
   function cdataHandler($parser, $data) {
      echo("$data<BR>");
   }

   // Now we create the parser
   $parser=xml_parser_create();

   // Register the start and end element handlers
   xml_set_element_handler($parser, "startElementHandler", "endElementHandler");

   // Register the character data parser
   xml_set_character_data_handler($parser, "cdataHandler");

   // Open the XML file
   $file="exemple1.xml";
   if (!($fp = fopen($file, "r"))) {
      die("could not open $file for reading");
   }

   // Read chunks of 4K from the file, and pass it to the parser 
   while ($data = fread($fp, 4096)) {
      if (!xml_parse($parser, $data, feof($fp))) {
         die(sprintf("XML error %d %d", xml_get_current_line_number($parser), 
                     xml_get_current_column_number($parser)));
      }
   }
?>
