unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ScktComp, StdCtrls, ComCtrls, Menus, ExtCtrls, inifiles;

type
  TErrorDetails = class(TObject)
  public
    EventTime:String;
    UnitFileName:String;
    ErrorLineNo:String;
    ErrorType:String;
    ErrorDescription:String;
    Stack:String;
  end;

  TPHP3DebugForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Newlog1: TMenuItem;
    Savelogas1: TMenuItem;
    N1: TMenuItem;
    Options1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    AboutPHP3DebugTrace1: TMenuItem;
    Listen1: TMenuItem;
    ServerSocket1: TServerSocket;
    SaveDialog1: TSaveDialog;
    lbxCallStack: TMemo;
    Splitter1: TSplitter;
    lbxErrors: TListBox;
    procedure Listen1Click(Sender: TObject);
    procedure ServerSocket1ClientRead(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure lbxErrorsClick(Sender: TObject);
    procedure PHP3DebugFormCreate(Sender: TObject);
    procedure PHP3DebugFormClose(Sender: TObject;
      var Action: TCloseAction);
    procedure Newlog1Click(Sender: TObject);
    procedure AboutPHP3DebugTrace1Click(Sender: TObject);
    procedure Savelogas1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure PHP3DebugFormShow(Sender: TObject);
  private
    FErrorDetails:TErrorDetails;
    procedure LogError(RawError:String);
    procedure SeparateError(Error:String);
  public
    { Public declarations }
  end;

var
  PHP3DebugForm: TPHP3DebugForm;

implementation

uses Options;

{$R *.DFM}

procedure TPHP3DebugForm.Listen1Click(Sender: TObject);
begin
  Listen1.Checked := not Listen1.Checked;
  ServerSocket1.Active := Listen1.Checked;
end;

procedure TPHP3DebugForm.LogError(RawError: String);
var
  LineBreakPos : integer;
  ErrorData:String;
begin
  ErrorData:=RawError;
  LineBreakPos := Pos(#10, ErrorData);
  while (LineBreakPos > 0) do
    begin
      SeparateError(Copy(ErrorData, 1, LineBreakPos - 1));
      ErrorData:=Copy(ErrorData, LineBreakPos+1, 450);
      LineBreakPos := Pos(#10, ErrorData);
    end;
end;

procedure TPHP3DebugForm.ServerSocket1ClientRead(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  LogError(Socket.ReceiveText);
end;

procedure TPHP3DebugForm.lbxErrorsClick(Sender: TObject);
var
  ErrorDetails:TErrorDetails;
  Msg:String;
begin
  ErrorDetails:=TErrorDetails(lbxErrors.Items.Objects[lbxErrors.ItemIndex]);
  lbxCallStack.Text := ErrorDetails.Stack;
end;

procedure TPHP3DebugForm.SeparateError(Error: String);
var
  Location:String;
  LinePosition:Integer;
begin
  if Pos(') start:', Error) > 0 then
    begin
      FErrorDetails:=TErrorDetails.Create;
      FErrorDetails.ErrorType := Copy(Error, Pos(') start:', Error) + 8, 450);
      FErrorDetails.ErrorType := Uppercase(FErrorDetails.ErrorType[1]) + Copy(FErrorDetails.ErrorType, 2, 255);
    end
  else if Pos(') end:', Error) > 0 then
    begin
      lbxErrors.Items.AddObject(
      '[' + FErrorDetails.ErrorType + '] ' + FErrorDetails.UnitFileName + ' (' + FErrorDetails.ErrorLineNo +
      '):' + FErrorDetails.ErrorDescription, FErrorDetails);
      FErrorDetails:=nil;
      lbxErrors.ItemIndex:=lbxErrors.Items.Count-1;
    end
  else if Pos(') message:', Error) > 0 then
    begin
      FErrorDetails.ErrorDescription := Copy(Error, Pos(') message:', Error) + 11, 450);
      FErrorDetails.EventTime:= Copy(Error, 9, 2) + '/' + Copy(Error, 6,2) + '/' + Copy(Error, 1, 4) + ' ' +
        Copy(Error, 12, 5);
    end
  else if (Pos(') location:', Error) > 0) and (FErrorDetails.UnitFileName = '') then
    begin
      Location:=Copy(Error, Pos(') location:', Error) + 12, 450);
      LinePosition:= Pos(':', Location);
      if Pos(':', Copy(Location, LinePosition+1, 450))>0 then
        LinePosition:= Pos(':', Copy(Location, LinePosition+1, 450));
      FErrorDetails.UnitFileName := Copy(Location, 1, LinePosition-1);
      FErrorDetails.ErrorLineNo := Copy(Location, LinePosition+1, 450);
    end
  else if (Pos(') location:', Error) > 0) then
    begin
      Location:=Copy(Error, Pos(') location:', Error) + 12, 450);
      LinePosition:= Pos(':', Location);
      if Pos(':', Copy(Location, LinePosition+1, 450))>0 then
        LinePosition:= Pos(':', Copy(Location, LinePosition+1, 450));
      FErrorDetails.Stack := FErrorDetails.Stack + ' (' + Copy(Location, 1, LinePosition-1) +
        ' at line ' + Copy(Location, LinePosition+1, 450) + ')' + #13#10;
    end
  else if (Pos(') function:', Error) > 0) then
    begin
      FErrorDetails.Stack := FErrorDetails.Stack + Copy(Error, Pos(') function:', Error) + 12, 450);
    end;
end;

procedure TPHP3DebugForm.PHP3DebugFormCreate(Sender: TObject);
begin
  FErrorDetails:=nil;
  ReadIniFile;
  if OnTop then
    FormStyle:=fsStayOnTop;
  Listen1.Checked := Listening;
  ServerSocket1.Active := Listening;
end;

procedure TPHP3DebugForm.PHP3DebugFormClose(Sender: TObject;
  var Action: TCloseAction);
var
  n:integer;
  IniFile:TIniFile;
begin
  for n:=0 to lbxErrors.Items.Count - 1 do
    lbxErrors.Items.Objects[n].Free;

  IniFile:=TIniFile.Create('PHP3Debug.ini');
  IniFile.WriteInteger('Position', 'LastX', Left);
  IniFile.WriteInteger('Position', 'LastY', Top);
  IniFile.WriteInteger('Position', 'LastHeight', Height);
  IniFile.WriteInteger('Position', 'LastWidth', Width);
end;

procedure TPHP3DebugForm.Newlog1Click(Sender: TObject);
var
  n:integer;
begin
  for n:=0 to lbxErrors.Items.Count - 1 do
    lbxErrors.Items.Objects[n].Free;
  lbxErrors.Items.Clear;
end;

procedure TPHP3DebugForm.AboutPHP3DebugTrace1Click(Sender: TObject);
begin
  MessageDlg('PHP3 Debug Trace v1.0'#13#10#13#10'Written and Copyright  1999 Andy Jeffries',
    mtInformation, [mbOK], 0);
end;

procedure TPHP3DebugForm.Savelogas1Click(Sender: TObject);
var
  n:integer;
  Log:TStringList;
  ErrorDetails:TErrorDetails;
begin
  if SaveDialog1.Execute then
  begin
    Log:=TStringList.Create;
    try
      for n:=0 to lbxErrors.Items.Count-1 do
        begin
          ErrorDetails:=TErrorDetails(lbxErrors.Items.Objects[n]);
          Log.Add(ErrorDetails.EventTime + ' [' + ErrorDetails.UnitFileName + ', ' +
            ErrorDetails.ErrorLineNo + '] - ' + ErrorDetails.ErrorDescription);
        end;
    finally
      Log.SaveToFile(SaveDialog1.FileName);
      Log.free;
    end;
  end;
end;

procedure TPHP3DebugForm.Options1Click(Sender: TObject);
begin
  frmOptions.ShowModal;
end;

procedure TPHP3DebugForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TPHP3DebugForm.PHP3DebugFormShow(Sender: TObject);
begin
  case ShowStyle of
    1:begin
        Left:=LastX;
        Top:=LastY;
        Height:=LastHeight;
        Width:=LastWidth;
      end;
    2:begin
        Left:=0;
        Height:=160;
        Top:=Screen.Height-(Height+28);
        Width:=Screen.Width;
      end;
  end;
end;

end.
