unit Options;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Spin, StdCtrls, ExtCtrls, ComCtrls, inifiles;

type
  TfrmOptions = class(TForm)
    PageControl1: TPageControl;
    btnApply: TButton;
    btnOK: TButton;
    btnCancel: TButton;
    tsGeneral: TTabSheet;
    RadioGroup1: TRadioGroup;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    procedure frmOptionsCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure SetApplyButton(Sender: TObject);
    procedure btnApplyClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOptions: TfrmOptions;
  ShowStyle:Integer = -1;
  ErrorsRed:Boolean;
  Listening:Boolean;
  OnTop:Boolean;
  LastX, LastY, LastHeight, LastWidth:Integer;

procedure ReadIniFile;
procedure WriteIniFile;

implementation

{$R *.DFM}

uses
  Main;

procedure TfrmOptions.frmOptionsCreate(Sender: TObject);
var
  PHP3IniFile:TIniFile;
  WinDir:array[0..255] of char;
  DbgPort, DbgEnabled:String;
begin
  if ShowStyle <> -1 then
    begin
      RadioGroup1.ItemIndex := ShowStyle;
      CheckBox2.Checked := ErrorsRed;
      CheckBox3.Checked := Listening;
      CheckBox4.Checked := OnTop;
      GetWindowsDirectory(WinDir, 255);
      Edit1.Text := WinDir;
      if FileExists(WinDir + '\php3.ini') then
        begin
          PHP3IniFile:=TIniFile.Create(WinDir + '\php3.ini');
          try
            DbgPort:=PHP3IniFile.ReadString('Debugger', 'debugger.port', '');
            DbgEnabled:=PHP3IniFile.ReadString('Debugger', 'debugger.enabled', '');
            try
              SpinEdit1.Value := StrToInt(DbgPort);
            except
              on EConvertError do ;
            end;
            CheckBox1.Checked:=Uppercase(DbgEnabled) = 'TRUE';
          finally
            PHP3IniFile.Free;
          end;
          btnApply.enabled:=false;
        end;
    end
  else
    begin
      RadioGroup1.ItemIndex := 0;
      CheckBox2.Checked := true;
      CheckBox3.Checked := false;
      CheckBox4.Checked := false;
      GetWindowsDirectory(WinDir, 255);
      Edit1.Text := WinDir;
      if FileExists(WinDir + '\php3.ini') then
        begin
          PHP3IniFile:=TIniFile.Create(WinDir + '\php3.ini');
          try
            DbgPort:=PHP3IniFile.ReadString('Debugger', 'debugger.port', '');
            DbgEnabled:=PHP3IniFile.ReadString('Debugger', 'debugger.enabled', '');
            try
              SpinEdit1.Value := StrToInt(DbgPort);
            except
              on EConvertError do ;
            end;
            CheckBox1.Checked:=Uppercase(DbgEnabled) = 'TRUE';
          finally
            PHP3IniFile.Free;
          end;
          btnApply.enabled:=false;
          WriteIniFile;
        end;
    end;
end;

procedure ReadIniFile;
var
  IniFile:TIniFile;
begin
  IniFile:=TIniFile.Create('PHP3Debug.ini');
  ShowStyle:=IniFile.ReadInteger('Position', 'Style', 0);
  ErrorsRed:=IniFile.ReadBool('General', 'ErrorsRed', true);
  Listening:=IniFile.ReadBool('General', 'ListenOnStart', false);
  OnTop:=IniFile.ReadBool('General', 'StayOnTop', false);
  LastX:=IniFile.ReadInteger('Position', 'LastX', 0);
  LastY:=IniFile.ReadInteger('Position', 'LastY', 0);
  LastHeight:=IniFile.ReadInteger('Position', 'LastHeight', 250);
  LastWidth:=IniFile.ReadInteger('Position', 'LastWidth', 500);
end;

procedure WriteIniFile;
var
  IniFile:TIniFile;
begin
  IniFile:=TIniFile.Create('PHP3Debug.ini');
  IniFile.WriteInteger('Position', 'Style', frmOptions.RadioGroup1.ItemIndex);
  IniFile.WriteBool('General', 'ErrorsRed', frmOptions.CheckBox2.Checked);
  IniFile.WriteBool('General', 'ListenOnStart', frmOptions.CheckBox3.Checked);
  IniFile.WriteBool('General', 'StayOnTop', frmOptions.CheckBox4.Checked);
end;

procedure TfrmOptions.btnCancelClick(Sender: TObject);
begin
  btnApply.Enabled:=false;
  ModalResult:=mrCancel;
end;

procedure TfrmOptions.SetApplyButton(Sender: TObject);
begin
  btnApply.Enabled:=true;
end;

procedure TfrmOptions.btnApplyClick(Sender: TObject);
begin
  WriteIniFile;
  btnApply.Enabled:=false;
end;

procedure TfrmOptions.btnOKClick(Sender: TObject);
begin
  WriteIniFile;
  btnApply.Enabled:=false;
  ModalResult:=mrOK;
end;

end.
