/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.SQLBuilder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.enhydra.instantdb.SQLBuilder.SQLBuilder;
import org.enhydra.instantdb.jdbc.idbResultsSet;

class QueryPanel
extends JPanel {
    JComboBox tables;
    ResourceBundle res1 = ResourceBundle.getBundle("Res");
    ResourceBundle res = ResourceBundle.getBundle("org.enhydra.instantdb.SQLBuilder.Res");
    JComboBox columns;
    JComboBox sqlCommands;
    JTextField sqlText;
    JTextField rowCount;
    JButton submitButton;
    ActionListener theHandler;
    JFrame applicationFrame;
    JLabel statusBar;
    Connection con;
    SQLBuilder parent;
    JTable outputTable;
    JScrollPane scrollpane;
    Statement stmt;
    ResultSet rs;
    String[] selectedCols;
    StringBuffer selectBuf;
    int selectCount;
    boolean firstTime;

    QueryPanel(SQLBuilder sQLBuilder) {
        super(new GridBagLayout());
        this.parent = sQLBuilder;
        this.applicationFrame = this.parent.getFrame();
        this.statusBar = this.parent.getStatusBar();
        this.theHandler = new theQueryListener();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(this.res1.getString("Tables"));
        this.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(this.res1.getString("Columns"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridx = 1;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel(this.res1.getString("Enter_row_limit_"));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.tables = new JComboBox();
        this.add((Component)this.tables, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.columns = new JComboBox();
        this.add((Component)this.columns, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.rowCount = new JTextField(20);
        this.add((Component)this.rowCount, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.submitButton = new JButton(this.res1.getString("Submit"));
        this.add((Component)this.submitButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jLabel = new JLabel(this.res1.getString("Query_"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel, gridBagConstraints);
        this.sqlText = new JTextField(50);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.sqlText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.outputTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this.outputTable);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.tables.addActionListener(this.theHandler);
        this.columns.addActionListener(this.theHandler);
        this.submitButton.addActionListener(this.theHandler);
        this.sqlText.addActionListener(this.theHandler);
        this.selectBuf = new StringBuffer(this.res1.getString("SELECT"));
    }

    void addResultsToList(ResultSet resultSet, JComboBox jComboBox, String string) throws SQLException {
        if (jComboBox.getItemCount() > 0) {
            jComboBox.removeAllItems();
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = resultSet.findColumn(string);
        while (resultSet.next()) {
            this.firstTime = true;
            jComboBox.addItem(resultSet.getString(n2));
        }
    }

    void getColumns() {
        try {
            String string = (String)this.tables.getSelectedItem();
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, string, this.res1.getString("KEY"));
            this.addResultsToList(resultSet, this.columns, this.res1.getString("COLUMN_NAME"));
            this.selectedCols = new String[this.columns.getItemCount()];
            resultSet.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), this.res1.getString("Error_getting_columns"), -1);
        }
    }

    void getTables() {
        try {
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, this.res1.getString("KEY"), null);
            this.addResultsToList(resultSet, this.tables, this.res1.getString("TABLE_NAME"));
            resultSet.close();
            this.getColumns();
            this.firstTime = false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), this.res1.getString("Error_getting_tables"), -1);
        }
    }

    void onConnect(Connection connection) {
        this.con = connection;
        this.getTables();
        try {
            this.stmt = this.con.createStatement();
        }
        catch (Exception exception) {}
    }

    class theQueryListener
    implements ActionListener {
        theQueryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == QueryPanel.this.tables) {
                    QueryPanel.this.getColumns();
                    String string = (String)QueryPanel.this.tables.getSelectedItem();
                    String string2 = String.valueOf(QueryPanel.this.res.getString("SELECT_FROM")) + string;
                    QueryPanel.this.sqlText.setText(string2);
                    QueryPanel.this.selectCount = 0;
                    QueryPanel.this.firstTime = false;
                } else if (actionEvent.getSource() == QueryPanel.this.columns) {
                    if (QueryPanel.this.firstTime) {
                        QueryPanel.this.firstTime = false;
                        return;
                    }
                    String string = (String)QueryPanel.this.columns.getSelectedItem();
                    QueryPanel.this.selectBuf.setLength(7);
                    QueryPanel.this.selectedCols[QueryPanel.this.selectCount++] = string;
                    int n = 0;
                    while (n < QueryPanel.this.selectCount) {
                        if (n != 0) {
                            QueryPanel.this.selectBuf.append(',');
                        }
                        QueryPanel.this.selectBuf.append(QueryPanel.this.selectedCols[n]);
                        ++n;
                    }
                    String string3 = (String)QueryPanel.this.tables.getSelectedItem();
                    QueryPanel.this.selectBuf.append(String.valueOf(QueryPanel.this.res.getString("FROM")) + string3);
                    QueryPanel.this.sqlText.setText(QueryPanel.this.selectBuf.toString());
                } else if (actionEvent.getSource() == QueryPanel.this.submitButton) {
                    String string = QueryPanel.this.rowCount.getText();
                    if (!string.equals("")) {
                        QueryPanel.this.stmt.setMaxRows(Integer.parseInt(string));
                    } else {
                        QueryPanel.this.stmt.setMaxRows(0);
                    }
                    if (QueryPanel.this.stmt.execute(QueryPanel.this.sqlText.getText())) {
                        QueryPanel.this.rs = QueryPanel.this.stmt.getResultSet();
                        QueryPanel.this.outputTable.setModel(new ResultModel());
                        QueryPanel.this.parent.onQuery(QueryPanel.this.rs);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    class ResultModel
    extends AbstractTableModel {
        String blank;

        ResultModel() {
            this.blank = QueryPanel.this.res.getString("BLANK");
        }

        public int getColumnCount() {
            try {
                if (!this.resultsOK()) {
                    return 10;
                }
                return QueryPanel.this.rs.getMetaData().getColumnCount();
            }
            catch (Exception exception) {
                return 10;
            }
        }

        public String getColumnName(int n) {
            try {
                if (!this.resultsOK()) {
                    return new Integer(n).toString();
                }
                return QueryPanel.this.rs.getMetaData().getColumnName(n + 1);
            }
            catch (Exception exception) {
                return new Integer(n).toString();
            }
        }

        public int getRowCount() {
            try {
                if (!this.resultsOK()) {
                    return 100;
                }
                if (!(QueryPanel.this.rs instanceof idbResultsSet)) {
                    return 1000;
                }
                return ((idbResultsSet)QueryPanel.this.rs).getRowCount();
            }
            catch (Exception exception) {
                return 100;
            }
        }

        public Object getValueAt(int n, int n2) {
            try {
                if (!this.resultsOK()) {
                    return this.blank;
                }
                if (!(QueryPanel.this.rs instanceof idbResultsSet)) {
                    if (!QueryPanel.this.rs.next()) {
                        return this.blank;
                    }
                    return QueryPanel.this.rs.getString(n2 + 1);
                }
                ((idbResultsSet)QueryPanel.this.rs).setCurRow(n + 1);
                QueryPanel.this.rs.next();
                return QueryPanel.this.rs.getString(n2 + 1);
            }
            catch (Exception exception) {
                return this.blank;
            }
        }

        boolean resultsOK() throws SQLException {
            if (QueryPanel.this.rs == null) {
                return false;
            }
            QueryPanel.this.rs.getMetaData();
            return true;
        }
    }
}

