/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.sample.forms;

import com.lutris.sample.IState;
import com.lutris.sample.IStateMachine;
import com.lutris.sample.RemoteServices;
import com.lutris.sample.data.Person;
import com.lutris.sample.data.PersonLink;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class QueryResultsList
extends List
implements CommandListener,
IState {
    private IStateMachine parent;
    private Command back;
    private Command details;
    private Vector personLinks;
    private static final boolean DEBUG = false;

    public QueryResultsList(String string, IStateMachine iStateMachine) {
        super(string, 3);
        this.parent = iStateMachine;
        this.back = new Command("Back", 2, 1);
        this.details = new Command("Details", 1, 1);
        this.addCommand(this.back);
        this.addCommand(this.details);
        this.setCommandListener(this);
    }

    private void buildList(Object object) {
        if (this.size() != 0) {
            this.clearScreen();
        }
        this.personLinks = (Vector)object;
        int n = this.personLinks.size();
        if (n == 0) {
            this.append("No people found.", null);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            PersonLink personLink = (PersonLink)this.personLinks.elementAt(n2);
            this.append(personLink.getName(), null);
            ++n2;
        }
    }

    private void clearScreen() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            this.delete(0);
            ++n2;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.back) {
            this.parent.setCurrentState(1, null);
        } else if (command == this.details) {
            PersonLink personLink = this.getSelectedPerson();
            if (personLink == null) {
                this.parent.setCurrentState(1, null);
            } else {
                Person person = null;
                try {
                    person = RemoteServices.getInstance().getDetails(personLink.getOid());
                    this.parent.setCurrentState(3, person);
                }
                catch (IOException iOException) {
                    Alert alert = new Alert("Network Error", "Exception Message: " + iOException.getMessage(), null, AlertType.ERROR);
                    alert.setTimeout(5000);
                    Display.getDisplay((MIDlet)((MIDlet)this.parent)).setCurrent((Displayable)alert);
                }
            }
        } else {
            System.out.println("ERROR in QueryResultsList: Unknown command.");
        }
    }

    private PersonLink getSelectedPerson() {
        int n = this.getSelectedIndex();
        String string = this.getString(n);
        int n2 = this.personLinks.size();
        int n3 = 0;
        while (n3 < n2) {
            PersonLink personLink = (PersonLink)this.personLinks.elementAt(n3);
            if (personLink.getName().equals(string)) {
                return personLink;
            }
            ++n3;
        }
        System.out.println("\tQueryResultsList.getSelectedPerson: No person found.");
        return null;
    }

    public void handleTransition(Object object) {
        Vector vector = (Vector)object;
        if (vector != null) {
            this.buildList(vector);
        }
    }
}

