/*
 * Decompiled with CFR 0.152.
 */
package de.kxml.io;

import de.kxml.PrefixMap;
import de.kxml.Xml;
import de.kxml.io.AbstractXmlWriter;
import de.kxml.io.AbstractXmlWriter$State;
import java.io.IOException;
import java.io.Writer;

public class XmlWriter
extends AbstractXmlWriter {
    protected Writer writer;
    boolean pending = false;
    int indentLevel = 0;
    int noIndent = Integer.MAX_VALUE;
    static char[] indent = new char[]{'\r', '\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

    public XmlWriter(Writer writer) {
        this.writer = writer;
    }

    protected void checkPending() throws IOException {
        if (this.pending) {
            this.writer.write(62);
            this.pending = false;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    public void flush() throws IOException {
        this.checkPending();
        this.writer.flush();
    }

    public void write(char c) throws IOException {
        this.checkPending();
        if (this.noIndent > this.indentLevel) {
            this.noIndent = this.indentLevel;
        }
        switch (c) {
            case '<': {
                this.writer.write("&lt;");
                break;
            }
            case '>': {
                this.writer.write("&gt;");
                break;
            }
            case '&': {
                this.writer.write("&amp;");
                break;
            }
            default: {
                this.writer.write(c);
            }
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        this.checkPending();
        if (this.noIndent > this.indentLevel) {
            this.noIndent = this.indentLevel;
        }
        int n4 = n + n2;
        do {
            n3 = n;
            while (n3 < n4 && "<>&".indexOf(cArray[n3]) == -1) {
                ++n3;
            }
            this.writer.write(cArray, n, n3 - n);
            if (n3 == n4) break;
            this.write(cArray[n3]);
        } while ((n = n3 + 1) < n4);
    }

    public void writeAttribute(String string, String string2) throws IOException {
        if (!this.pending) {
            throw new RuntimeException("can write attr only immediately after a startTag");
        }
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write("=\"");
        this.writer.write(Xml.encode(string2, 1));
        this.writer.write(34);
    }

    public void writeEndTag() throws IOException {
        --this.indentLevel;
        if (this.pending) {
            this.writer.write(" />");
            this.pending = false;
        } else {
            if (this.indentLevel + 1 < this.noIndent) {
                this.writeIndent();
            }
            this.writer.write("</");
            this.writer.write(this.current.tag);
            this.writer.write(">");
        }
        if (this.indentLevel + 1 == this.noIndent) {
            this.noIndent = Integer.MAX_VALUE;
        }
        this.current = this.current.prev;
    }

    public void writeIndent() throws IOException {
        int n = this.indentLevel + 2;
        if (n < 2) {
            n = 2;
        } else if (n > indent.length) {
            n = indent.length;
        }
        this.checkPending();
        this.writer.write(indent, 0, n);
    }

    public void writeLegacy(int n, String string) throws IOException {
        this.checkPending();
        switch (n) {
            case 45: {
                this.writer.write("<!--");
                this.writer.write(string);
                this.writer.write("-->");
                break;
            }
            case 33: {
                this.writer.write("<!DOCTYPE");
                this.writer.write(string);
                this.writer.write(">");
                break;
            }
            case 63: {
                this.writer.write("<?");
                this.writer.write(string);
                this.writer.write("?>");
            }
        }
    }

    public void writeRaw(String string) throws IOException {
        this.checkPending();
        this.writer.write(string);
    }

    protected void writeStartTag(PrefixMap prefixMap, String string) throws IOException {
        XmlWriter xmlWriter = this;
        xmlWriter.getClass();
        this.current = new AbstractXmlWriter$State(xmlWriter, this.current, prefixMap, string);
        this.checkPending();
        if (this.indentLevel < this.noIndent) {
            this.writeIndent();
        }
        ++this.indentLevel;
        this.writer.write(60);
        this.writer.write(string);
        this.pending = true;
    }
}

