/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.SQLBuilder;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.enhydra.instantdb.SQLBuilder.SQLBuilder;

class ConnectionPanel
extends JPanel {
    static ResourceBundle res = ResourceBundle.getBundle("org.enhydra.instantdb.SQLBuilder.Res");
    static String[] drivers = new String[]{res.getString("org_enhydra_instantdb"), res.getString("sun_jdbc_odbc")};
    JComboBox driverList;
    JTextField urlText;
    JTextField userText;
    JTextField passText;
    JButton browseButton;
    JButton connectButton;
    ActionListener buttonHandler;
    JFrame applicationFrame;
    JLabel statusBar;
    Connection con;
    SQLBuilder parent;

    ConnectionPanel(SQLBuilder sQLBuilder) {
        this.parent = sQLBuilder;
        this.applicationFrame = this.parent.getFrame();
        this.statusBar = this.parent.getStatusBar();
        this.driverList = new JComboBox();
        int n = 0;
        while (n < drivers.length) {
            this.driverList.addItem(drivers[n]);
            ++n;
        }
        this.setLayout(null);
        JLabel jLabel = new JLabel(res.getString("Driver"));
        this.add(jLabel);
        jLabel.setBounds(50, 50, 80, 20);
        this.add(this.driverList);
        this.driverList.setBounds(140, 50, 150, 20);
        this.urlText = this.addLabelledTextBox(res.getString("URL"), 80);
        this.userText = this.addLabelledTextBox(res.getString("Username"), 100);
        this.passText = this.addLabelledTextBox(res.getString("Password"), 120);
        this.buttonHandler = new ButtonListener();
        this.browseButton = this.addButton(res.getString("Browse"), 100);
        this.connectButton = this.addButton(res.getString("Connect"), 210);
        this.setSize(250, 120);
    }

    JButton addButton(String string, int n) {
        JButton jButton = new JButton(string);
        this.add(jButton);
        jButton.setBounds(n, 170, 100, 30);
        jButton.addActionListener(this.buttonHandler);
        return jButton;
    }

    JTextField addLabelledTextBox(String string, int n) {
        JLabel jLabel = new JLabel(string);
        this.add(jLabel);
        jLabel.setBounds(50, n, 80, 20);
        JTextField jTextField = null;
        jTextField = string.equals(res.getString("Password")) ? new JPasswordField() : new JTextField();
        this.add(jTextField);
        jTextField.setBounds(140, n, 150, 20);
        return jTextField;
    }

    void onDisconnect() throws SQLException {
        if (this.con != null) {
            this.statusBar.setText(res.getString("Disconnecting_"));
            this.con.close();
            this.con = null;
            this.connectButton.setText(res.getString("Connect"));
            this.statusBar.setText(res.getString("Disconnected"));
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                if (actionEvent.getSource() == ConnectionPanel.this.browseButton) {
                    FileDialog fileDialog = new FileDialog((Frame)ConnectionPanel.this.applicationFrame, res.getString("Browse_Database"), 0);
                    fileDialog.show();
                    ConnectionPanel.this.urlText.setText(String.valueOf(res.getString("jdbc_idb_")) + fileDialog.getDirectory() + fileDialog.getFile());
                } else {
                    String string = ConnectionPanel.this.statusBar.getText();
                    try {
                        if (ConnectionPanel.this.con == null) {
                            ConnectionPanel.this.statusBar.setText(res.getString("Connecting_"));
                            ConnectionPanel.this.statusBar.paintImmediately(0, 0, 1000, 30);
                            String string2 = (String)ConnectionPanel.this.driverList.getSelectedItem();
                            Class.forName(string2).newInstance();
                            ConnectionPanel.this.con = ConnectionPanel.this.userText.getText().equals("") ? DriverManager.getConnection(ConnectionPanel.this.urlText.getText()) : DriverManager.getConnection(ConnectionPanel.this.urlText.getText(), ConnectionPanel.this.userText.getText(), ConnectionPanel.this.passText.getText());
                            ConnectionPanel.this.parent.onConnect(ConnectionPanel.this.con);
                            ConnectionPanel.this.connectButton.setText(res.getString("Disconnect"));
                            ConnectionPanel.this.statusBar.setText(String.valueOf(res.getString("Connected_to")) + ConnectionPanel.this.urlText.getText());
                            break block5;
                        }
                        ConnectionPanel.this.onDisconnect();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString(), res.getString("Error"), -1);
                        ConnectionPanel.this.statusBar.setText(string);
                    }
                }
            }
        }
    }
}

