/*
 * Decompiled with CFR 0.152.
 */
package de.kxml.kdom;

import de.kxml.Attribute;
import de.kxml.PrefixMap;
import de.kxml.io.XmlWriter;
import de.kxml.kdom.Document;
import de.kxml.parser.ParseEvent;
import de.kxml.parser.Parser;
import de.kxml.parser.StartTag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;

public abstract class Element {
    public abstract void addChild(int var1, int var2, Object var3);

    public void addChild(int n, Object object) {
        this.addChild(this.getChildCount(), n, object);
    }

    public void clear() {
        this.setAttributes(new Vector());
        int n = this.getChildCount() - 1;
        while (n >= 0) {
            this.removeChild(n);
            --n;
        }
    }

    public abstract Attribute getAttribute(int var1);

    public Attribute getAttribute(String string) {
        return this.getAttribute("", string);
    }

    public Attribute getAttribute(String string, String string2) {
        int n = this.getAttributeCount();
        if (string == null) {
            string = "";
        }
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = this.getAttribute(n2);
            if (string.equals(attribute.getNamespace()) && string2.equals(attribute.getName())) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public abstract Vector getAttributes();

    public abstract int getAttributeCount();

    public abstract Object getChild(int var1);

    public abstract int getChildCount();

    public Element getElement(int n) {
        Object object = this.getChild(n);
        return object instanceof Element ? (Element)object : null;
    }

    public abstract String getName();

    public abstract String getNamespace();

    public abstract PrefixMap getPrefixMap();

    public abstract void setPrefixMap(PrefixMap var1);

    public abstract Document getDocument();

    public abstract Element getParentElement();

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getType(n2) == 116) {
                stringBuffer.append(this.getText(n2));
            } else if (this.getType(n2) == 60) {
                throw new RuntimeException("not text-only content!");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getText(int n) {
        return this.getType(n) == 116 ? (String)this.getChild(n) : null;
    }

    public abstract int getType(int var1);

    public String getValue(String string) {
        Attribute attribute = this.getAttribute("", string);
        return attribute == null ? null : attribute.getValue();
    }

    public String getValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute == null ? null : attribute.getValue();
    }

    public int indexOf(String string) {
        return this.indexOf(this.getNamespace(), string, 0);
    }

    public int indexOf(String string, int n) {
        return this.indexOf(this.getNamespace(), string, n);
    }

    public int indexOf(String string, String string2) {
        return this.indexOf(string, string2, 0);
    }

    public int indexOf(String string, String string2, int n) {
        int n2 = this.getChildCount();
        if (string == null) {
            string = "";
        }
        int n3 = n;
        while (n3 < n2) {
            Element element = this.getElement(n3);
            if (element != null && string.equals(element.getNamespace()) && string2.equals(element.getName())) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void parse(Parser parser, StartTag startTag) throws IOException {
        if (startTag != null) {
            this.setPrefixMap(startTag.getPrefixMap());
        }
        boolean bl = false;
        do {
            ParseEvent parseEvent = parser.read();
            switch (parseEvent.getType()) {
                case 60: {
                    Element element = this.getDocument().createElement(this, parseEvent.getNamespace(), parseEvent.getName(), parseEvent.getAttributes());
                    this.addChild(60, element);
                    element.parse(parser, (StartTag)parseEvent);
                    break;
                }
                case 116: {
                    String string = parseEvent.getText();
                    this.addChild(116, parseEvent.getText());
                    break;
                }
                case 45: 
                case 63: {
                    this.addChild(parseEvent.getType(), parseEvent.getText());
                    break;
                }
                case 46: {
                    if (startTag != null) {
                        throw new RuntimeException("Unexpected end of document!");
                    }
                }
                case 47: {
                    bl = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected parse event: " + parseEvent);
                }
            }
        } while (!bl);
        if (startTag != null && !startTag.getDegenerated() && this.getChildCount() == 0) {
            this.addChild(116, "");
        }
    }

    public abstract void removeAttribute(int var1);

    public abstract void removeChild(int var1);

    public abstract void setAttribute(Attribute var1);

    public abstract void setAttributes(Vector var1);

    public abstract void setName(String var1);

    public abstract void setNamespace(String var1);

    public abstract void setParent(Object var1);

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlWriter xmlWriter = new XmlWriter(new OutputStreamWriter(byteArrayOutputStream));
            this.write(xmlWriter);
            xmlWriter.close();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO/Exception should not occur with a StringWriter!");
        }
    }

    public String childrenToString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlWriter xmlWriter = new XmlWriter(new OutputStreamWriter(byteArrayOutputStream));
            this.write(xmlWriter);
            xmlWriter.close();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO/Exception should not occur with a StringWriter!");
        }
    }

    public void writeChildren(XmlWriter xmlWriter) throws IOException {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            switch (this.getType(n2)) {
                case 60: {
                    this.getElement(n2).write(xmlWriter);
                    break;
                }
                case 116: {
                    xmlWriter.write(this.getText(n2));
                    break;
                }
                default: {
                    xmlWriter.writeLegacy(this.getType(n2), (String)this.getChild(n2));
                }
            }
            ++n2;
        }
    }

    public void writeStartTag(XmlWriter xmlWriter) throws IOException {
        Document document = this.getDocument();
    }

    public void write(XmlWriter xmlWriter) throws IOException {
        xmlWriter.writeStartTag(this.getPrefixMap(), this.getNamespace(), this.getName());
        int n = this.getAttributeCount();
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = this.getAttribute(n2);
            xmlWriter.writeAttribute(attribute.getNamespace(), attribute.getName(), attribute.getValue());
            ++n2;
        }
        this.writeChildren(xmlWriter);
        xmlWriter.writeEndTag();
    }
}

