/*
 * Decompiled with CFR 0.152.
 */
package de.kxml.wap;

import de.kxml.Attribute;
import de.kxml.io.ParseException;
import de.kxml.parser.EndDocument;
import de.kxml.parser.EndTag;
import de.kxml.parser.ParseEvent;
import de.kxml.parser.Parser;
import de.kxml.parser.StartTag;
import de.kxml.parser.TextEvent;
import de.kxml.wap.WapExtensionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class WbxmlParser
extends Parser {
    InputStream in;
    String[] attrStartTable;
    String[] attrValueTable;
    String[] tagTable;
    String stringTable;
    int version;
    int publicIdentifierId;
    int charSet;
    StartTag current;
    ParseEvent next;

    public WbxmlParser(InputStream inputStream) throws IOException {
        this.in = inputStream;
        this.version = this.readByte();
        this.publicIdentifierId = this.readInt();
        if (this.publicIdentifierId == 0) {
            this.readInt();
        }
        this.charSet = this.readInt();
        int n = this.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append((char)this.readByte());
            ++n2;
        }
        this.stringTable = stringBuffer.toString();
        this.read();
    }

    public ParseEvent peek() {
        return this.next;
    }

    public ParseEvent read() throws IOException {
        ParseEvent parseEvent = this.next;
        if (this.current != null && this.current.getDegenerated()) {
            this.next = new EndTag(this.current);
            this.current = this.current.getPrevious();
            return parseEvent;
        }
        this.next = null;
        block10: do {
            int n = this.in.read();
            switch (n) {
                case -1: {
                    if (this.current != null) {
                        throw new RuntimeException("unclosed elements: " + this.current);
                    }
                    this.next = new EndDocument();
                    break;
                }
                case 0: {
                    if (this.readByte() == 0) continue block10;
                    throw new IOException("Curr. only CP0 supported");
                }
                case 1: {
                    this.next = new EndTag(this.current);
                    this.current = this.current.getPrevious();
                    break;
                }
                case 2: {
                    this.next = new TextEvent("" + (char)this.readInt());
                    break;
                }
                case 3: {
                    this.next = new TextEvent(this.readStrI());
                    break;
                }
                case 64: 
                case 65: 
                case 66: 
                case 128: 
                case 129: 
                case 130: 
                case 192: 
                case 193: 
                case 194: 
                case 195: {
                    this.next = this.parseWapExtension(n);
                    break;
                }
                case 67: {
                    throw new RuntimeException("PI curr. not supp.");
                }
                case 131: {
                    int n2 = this.readInt();
                    int n3 = this.stringTable.indexOf(0, n2);
                    this.next = new TextEvent(this.stringTable.substring(n2, n3));
                    break;
                }
                default: {
                    this.next = this.parseElement(n);
                }
            }
        } while (this.next == null);
        return parseEvent;
    }

    public ParseEvent parseWapExtension(int n) throws IOException {
        switch (n) {
            case 64: 
            case 65: 
            case 66: {
                return new WapExtensionEvent(n, this.readStrI());
            }
            case 128: 
            case 129: 
            case 130: {
                return new WapExtensionEvent(n, new Integer(this.readInt()));
            }
            case 192: 
            case 193: 
            case 194: {
                return new WapExtensionEvent(n, null);
            }
            case 195: {
                int n2 = this.readInt();
                byte[] byArray = new byte[n2];
                int n3 = 0;
                while (n3 < n2) {
                    byArray[n2] = (byte)this.readByte();
                    ++n3;
                }
                return new WapExtensionEvent(n, byArray);
            }
        }
        throw new IOException("illegal id!");
    }

    public Vector readAttr() throws IOException {
        Vector<Attribute> vector = new Vector<Attribute>();
        int n = this.readByte();
        while (n != 1) {
            StringBuffer stringBuffer;
            String string = this.resolveId(this.attrStartTable, n);
            int n2 = string.indexOf(61);
            if (n2 == -1) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer = new StringBuffer(string.substring(n2 + 1));
                string = string.substring(0, n2);
            }
            n = this.readByte();
            while (n > 128 || n == 2 || n == 3 || n == 131 || n >= 64 && n <= 66 || n >= 128 && n <= 130) {
                switch (n) {
                    case 2: {
                        stringBuffer.append((char)this.readInt());
                        break;
                    }
                    case 3: {
                        stringBuffer.append(this.readStrI());
                        break;
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: {
                        ParseEvent parseEvent = this.parseWapExtension(n);
                        if (!(parseEvent instanceof TextEvent)) {
                            throw new RuntimeException("parse WapExtension must return TextEvent in order to work inside Attributes!");
                        }
                        stringBuffer.append(parseEvent.getText());
                    }
                    case 131: {
                        stringBuffer.append(this.readStrT());
                        break;
                    }
                    default: {
                        stringBuffer.append(this.resolveId(this.attrValueTable, n));
                    }
                }
                n = this.readByte();
            }
            vector.addElement(new Attribute(null, string, stringBuffer.toString()));
        }
        return vector;
    }

    String resolveId(String[] stringArray, int n) throws IOException {
        int n2 = (n & 0x7F) - 5;
        if (n2 == -1) {
            return this.readStrT();
        }
        if (n2 < 0 || stringArray == null || n2 >= stringArray.length || stringArray[n2] == null) {
            throw new IOException("id " + n + " undef.");
        }
        return stringArray[n2];
    }

    StartTag parseElement(int n) throws IOException {
        String string = this.resolveId(this.tagTable, n & 0x3F);
        this.current = new StartTag(this.current, null, string, (n & 0x80) != 0 ? this.readAttr() : null, (n & 0x40) == 0);
        if (this.processNamespaces) {
            try {
                this.current.fixNamespaces();
            }
            catch (Exception exception) {
                throw new ParseException(exception);
            }
        }
        return this.current;
    }

    int readByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new IOException("Unexpected EOF");
        }
        return n;
    }

    int readInt() throws IOException {
        int n;
        int n2 = 0;
        do {
            n = this.readByte();
            n2 = n2 << 7 | n & 0x7F;
        } while ((n & 0x80) != 0);
        return n2;
    }

    String readStrI() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.in.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (n == 0) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    String readStrT() throws IOException {
        int n = this.readInt();
        int n2 = this.stringTable.indexOf(0, n);
        return this.stringTable.substring(n, n2);
    }

    public void setTagTable(int n, String[] stringArray) {
        this.tagTable = stringArray;
        if (n != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrStartTable(int n, String[] stringArray) {
        this.attrStartTable = stringArray;
        if (n != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrValueTable(int n, String[] stringArray) {
        this.attrValueTable = stringArray;
        if (n != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }
}

