/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import org.ksoap.ClassMap;
import org.ksoap.SoapEnvelope;
import org.ksoap.SoapFault;
import org.ksoap.SoapObject;
import org.kxml.io.XmlWriter;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.XmlParser;

public class HttpTransport {
    String url;
    String soapAction = "\"\"";
    SoapEnvelope requestEnvelope = new SoapEnvelope();
    SoapEnvelope responseEnvelope = new SoapEnvelope();
    public boolean debug;
    public String requestDump;
    public String responseDump;

    public HttpTransport() {
    }

    public HttpTransport(String string, String string2) {
        this.url = string;
        this.soapAction = string2;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public void setClassMap(ClassMap classMap) {
        this.requestEnvelope.setClassMap(classMap);
        this.responseEnvelope.setClassMap(classMap);
    }

    public void call() throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(new OutputStreamWriter(byteArrayOutputStream));
        this.requestEnvelope.write(xmlWriter);
        xmlWriter.flush();
        byteArrayOutputStream.write(13);
        byteArrayOutputStream.write(10);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = null;
        xmlWriter = null;
        this.requestDump = this.debug ? new String(byArray) : null;
        this.responseDump = null;
        HttpConnection httpConnection = (HttpConnection)Connector.open((String)this.url);
        httpConnection.setRequestProperty("SOAPAction", this.soapAction);
        httpConnection.setRequestProperty("Content-Type", "text/xml");
        httpConnection.setRequestProperty("Content-Length", "" + byArray.length);
        httpConnection.setRequestProperty("User-Agent", "kSOAP/0.98");
        httpConnection.setRequestMethod("POST");
        OutputStream outputStream = httpConnection.openOutputStream();
        outputStream.write(byArray, 0, byArray.length);
        byArray = null;
        InputStream inputStream = httpConnection.openInputStream();
        if (this.debug) {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[256];
            while ((n = inputStream.read((byte[])object, 0, 256)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            object = byteArrayOutputStream.toByteArray();
            this.responseDump = new String((byte[])object);
            inputStream.close();
            inputStream = new ByteArrayInputStream((byte[])object);
        }
        object = new XmlParser(new InputStreamReader(inputStream));
        this.responseEnvelope.parse((AbstractXmlParser)object);
        outputStream.close();
        inputStream.close();
        httpConnection.close();
    }

    public Object call(SoapObject soapObject) throws IOException {
        this.requestEnvelope.setBody(soapObject);
        this.call();
        if (this.responseEnvelope.getBody() instanceof SoapFault) {
            throw (SoapFault)this.responseEnvelope.getBody();
        }
        return this.responseEnvelope.getResult();
    }
}

