/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Vector;
import org.enhydra.instantdb.db.Cache;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.RowRangeCache;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;
import org.enhydra.instantdb.db.indexTable;

public abstract class Column {
    Table cTable;
    String colName;
    int recOffset;
    int colLength;
    boolean isPrimaryKey;
    boolean unique;
    boolean notNull;
    boolean readOnly;
    Object defaultValue;
    Object lastValueInserted;
    int type;
    int cardinality;
    Database dbase;
    Object nullObj;
    Integer colID;
    boolean requiresRecovery;
    boolean allowAccidentalNulls;
    Cache rowCache;
    int order;
    long headerPosn;
    Table underlyingTable;
    String fkTableName;
    String fkColName;
    Column fk;
    int fk_flags;
    Vector fkList;
    int fkID;
    static int totalLookups;
    static final int DELETE_CASCADE = 1;
    static final int DELETE_SET_NULL = 2;
    static final int DELETE_SET_DEFAULT = 4;
    static final int DELETE_MASK = 7;
    static final int UPDATE_CASCADE = 8;
    static final int UPDATE_SET_NULL = 16;
    static final int UPDATE_SET_DEFAULT = 32;
    static final int UPDATE_MASK = 56;
    static final int INITIALLY_DEFERRED = 64;
    static final int NOT_DEFERRABLE = 128;
    static final int PRIMARY_KEY = 1;
    static final int UNIQUE = 2;
    static final int NOT_NULL = 3;
    static final int DEFAULT = 4;
    static final int AUTOINCREMENT = 5;
    static final int ALLOW_ACCIDENTAL_NULLS = 6;
    static final int AUTO_BASE = 7;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_DATE = 5;
    public static final int TYPE_CURRENCY = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_DOUBLE = 8;
    public static final int TYPE_INDEX = 9;
    public static final int TYPE_BLOB = 10;
    public static final int TYPE_CHAR1 = 11;
    static final int ORDER_NONE = 0;
    static final int ORDER_ASC = 1;
    static final int ORDER_DESC = 2;
    public static final int[] SQL_TYPES;
    public static final String[] typeNames;

    static {
        int[] nArray = new int[12];
        nArray[1] = -6;
        nArray[2] = 4;
        nArray[3] = 12;
        nArray[4] = -5;
        nArray[5] = 91;
        nArray[6] = -5;
        nArray[7] = 6;
        nArray[8] = 8;
        nArray[9] = 1111;
        nArray[10] = -4;
        nArray[11] = 1;
        SQL_TYPES = nArray;
        typeNames = new String[]{"", "BYTE", "INTEGER", "CHAR", "LONG", "DATE", "CURRENCY", "FLOAT", "DOUBLE", "INDEX", "BINARY", "CHAR1", "BIT"};
    }

    Column(Table table, String string, int n) throws SQLException {
        this.colName = string;
        this.dbase = table.dbase;
        this.colLength = n;
        table.addColumn(this);
        this.cTable = table;
        this.rowCache = new RowRangeCache(this);
        if (this.cTable.rndFile == null) {
            this.rowCache.setCacheCondition(2, 100);
        } else {
            this.rowCache.setRange(1, 0);
        }
    }

    boolean RUcalled(Object object, Object object2) {
        String string;
        if (object != null && !(string = object instanceof Table ? ((Table)object).getTableName() : (String)object).equalsIgnoreCase(this.cTable.getTableName())) {
            return false;
        }
        String string2 = object2 instanceof Column ? ((Column)object2).getName() : (String)object2;
        return string2.equalsIgnoreCase(this.colName);
    }

    void addFk(Column column) {
        if (this.fkList == null) {
            this.fkList = new Vector(3, 3);
        }
        this.fkList.addElement(column);
        this.cTable.hasFK = true;
    }

    public boolean allowsNull() {
        return this.notNull ^ true;
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(this.headerPosn);
    }

    abstract boolean compare(int var1, Object var2, int var3, boolean var4) throws SQLException;

    Object getByRow(int n) throws SQLException {
        if (n == 0) {
            return String.valueOf(this.colName) + '(' + typeNames[this.type] + ')';
        }
        ++totalLookups;
        Object object = this.rowCache.get(n);
        if (object != null) {
            return object;
        }
        try {
            this.cTable.rndFile.readRow(n, this.recOffset);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return null;
    }

    public int getColID() {
        return this.colID;
    }

    Object getDefault() {
        return this.defaultValue;
    }

    abstract int getHash(Object var1);

    public Object getLastValueInserted() {
        return this.lastValueInserted;
    }

    public int getLength() {
        return this.colLength;
    }

    public String getName() {
        return this.colName;
    }

    Object getNull() {
        return this.nullObj;
    }

    int getNullHash() {
        return this.getHash(this.nullObj);
    }

    int getOffset() {
        return this.recOffset;
    }

    int getRowByValue(Object object, int n) throws SQLException {
        int n2 = 1;
        int n3 = this.cTable.rowCount;
        indexTable indexTable2 = this.cTable.getIndex(this);
        if (indexTable2 != null) {
            int[] nArray = indexTable2.lookupValue(object, true);
            if (nArray == null) {
                return 0;
            }
            n2 = nArray[0];
            n3 = nArray[1];
        }
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = n4;
            if (indexTable2 != null) {
                n5 = indexTable2.getRowByRow(n4);
            }
            if (n5 != n && this.compare(n5, object, 1, false) && !this.cTable.rowDeleted(n5)) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public int getRowCount() {
        return this.cTable.getRowCount();
    }

    Table getTable() {
        return this.cTable;
    }

    public int getType() {
        return this.type;
    }

    public Table getUnderlyingTable() {
        return this.underlyingTable;
    }

    boolean hasOwnIndex() {
        return this.cTable.getIndex(this) != null;
    }

    abstract boolean hashPreservesOrder();

    public boolean inPrimaryKey() {
        return this.isPrimaryKey;
    }

    public abstract boolean isAutoIncrement();

    public abstract boolean isNull(Object var1);

    public boolean isReadOnly() {
        return this.readOnly;
    }

    abstract boolean numeric();

    void onClose() {
        if (this.rowCache == null) {
            return;
        }
        this.rowCache = null;
    }

    void onDelete(RandomAccessFile randomAccessFile, int n, Transaction transaction, Vector vector) throws SQLException {
        if (this.fkList == null || transaction == null) {
            return;
        }
        Object object = this.getByRow(n);
        if (vector != null) {
            if (object == vector.elementAt(this.cardinality - 1)) {
                return;
            }
            if (this.compare(n, vector.elementAt(this.cardinality - 1), 1, true)) {
                return;
            }
        }
        int n2 = 0;
        while (n2 < this.fkList.size()) {
            Column column = (Column)this.fkList.elementAt(n2);
            int n3 = column.fk_flags;
            n3 = this.cTable.updating ? (n3 & 0x38) >> 3 : (n3 &= 7);
            int n4 = 0;
            while ((n4 = column.getRowByValue(object, 0)) != 0) {
                if (Trace.traceIt(8192)) {
                    Trace.traceOut("FK delete. Delete for value, " + object + ", row, " + n4 + ", in column " + column);
                }
                switch (n3) {
                    case 1: {
                        if (this.cTable.updating) {
                            if (vector == null) {
                                return;
                            }
                            this.updateOnDelete(column, n4, transaction, vector.elementAt(this.cardinality - 1));
                            break;
                        }
                        column.cTable.deleteRow(n4, transaction, null);
                        break;
                    }
                    case 2: {
                        this.updateOnDelete(column, n4, transaction, column.nullObj);
                        break;
                    }
                    case 4: {
                        if (column.defaultValue == null) {
                            throw new SQLException("Attempt to set FK to default but default is null: " + column);
                        }
                        this.updateOnDelete(column, n4, transaction, column.defaultValue);
                        break;
                    }
                    default: {
                        throw new SQLException("Cannot delete value, " + object + ". In use by column " + column);
                    }
                }
            }
            ++n2;
        }
    }

    void onDrop() throws SQLException {
        if (this.fkList != null) {
            throw new SQLException("Cannot drop table. Column, " + this.toString() + ", is referenced by " + this.fkList.elementAt(0));
        }
        if (this.fk == null) {
            return;
        }
        this.fk.removeFk(this);
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
        this.headerPosn = randomAccessFile.getFilePointer();
    }

    void recover(Object object) {
    }

    void removeFk(Column column) {
        if (this.fkList == null) {
            return;
        }
        this.fkList.removeElement(column);
        if (this.fkList.size() == 0) {
            this.fkList = null;
            int n = 0;
            while (n < this.cTable.columnList.size()) {
                Column column2 = (Column)this.cTable.columnList.elementAt(n);
                if (column2.fkList != null) {
                    return;
                }
                ++n;
            }
            this.cTable.hasFK = false;
        }
    }

    void setBooleanProperty(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.isPrimaryKey = bl;
                break;
            }
            case 2: {
                this.unique = bl;
                break;
            }
            case 3: {
                this.notNull = bl;
                break;
            }
            case 6: {
                this.allowAccidentalNulls = bl;
                break;
            }
        }
    }

    void setCacheCondition(int n, int n2) {
        this.setCacheCondition(n, n2, false);
    }

    void setCacheCondition(int n, int n2, boolean bl) {
        if (this.cTable.rndFile == null && !bl) {
            return;
        }
        this.rowCache.setCacheCondition(n, n2);
    }

    void setOffset(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Column offset must be positive");
        }
        this.recOffset = n;
    }

    void setProperty(int n, Object object) {
        switch (n) {
            case 4: {
                this.defaultValue = object;
                break;
            }
        }
    }

    final void setRow(idbDataOutputStream idbDataOutputStream2, int n, Object object, Transaction transaction) throws SQLException {
        int n2;
        Object object2;
        if (object instanceof String && ((String)(object2 = (String)object)).equalsIgnoreCase("NULL")) {
            object = null;
        }
        if ((object2 = this.toObject(object)) == null) {
            throw new SQLException("Column " + this.colName + " cannot accept value " + object);
        }
        if (object2 == this.nullObj && this.notNull) {
            throw new SQLException(String.valueOf(this.colName) + " column does not allow nulls");
        }
        if (this.unique && object2 != this.nullObj && (n2 = this.getRowByValue(object2, n)) != 0) {
            throw new SQLException("Value " + object2 + " already exists in column " + this.cTable.getTableName() + "." + this.colName);
        }
        if (this.fk != null && transaction != null) {
            int n3;
            String string = object2.toString();
            if (object2 == this.nullObj) {
                string = "NULL";
            }
            if (Trace.traceIt(8192)) {
                Trace.traceOut("FK insert. Checking value, " + string + ", in column " + this.fk);
            }
            if ((n3 = this.fk.getRowByValue(object2, 0)) == 0 && object2 != this.nullObj && object2 != this.defaultValue && !this.fk.cTable.updating) {
                throw new SQLException("FK insert error. Value, " + object2 + ", does not exist in column " + this.fk);
            }
        }
        try {
            if (idbDataOutputStream2 != null) {
                this.writeObject(idbDataOutputStream2, object2, transaction, n);
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.rowCache.add(object2, n);
        this.lastValueInserted = object2;
    }

    void setUnderlyingTable(Table table) {
        this.underlyingTable = table;
    }

    abstract Object toObject(Object var1);

    public String toString() {
        String string = String.valueOf(this.cTable.getTableName()) + "." + this.colName;
        return string;
    }

    public abstract String toString(Object var1);

    void updateOnDelete(Column column, int n, Transaction transaction, Object object) throws SQLException {
        Table table = column.cTable;
        Vector<Object> vector = new Vector<Object>(table.columnList.size());
        table.getRow(n, vector);
        vector.setElementAt(object, column.cardinality - 1);
        table.deleteRow(n, transaction, null);
        table.addRow(vector, transaction);
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
        this.headerPosn = randomAccessFile.getFilePointer();
    }

    abstract void writeObject(idbDataOutputStream var1, Object var2, Transaction var3, int var4) throws IOException;
}

