/*
 * Decompiled with CFR 0.152.
 */
package de.kxml.kdom;

import de.kxml.io.ParseException;
import de.kxml.io.XmlWriter;
import de.kxml.kdom.DefaultElement;
import de.kxml.kdom.Element;
import de.kxml.parser.ParseEvent;
import de.kxml.parser.Parser;
import de.kxml.parser.StartTag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;

public class Document {
    protected int rootIndex = -1;
    protected Hashtable namespaceMap = new Hashtable();
    protected Vector children = new Vector();
    protected StringBuffer types = new StringBuffer();

    public void addChild(int n, Object object) {
        if (n == 60) {
            this.rootIndex = this.children.size();
        }
        this.types.append((char)n);
        this.children.addElement(object);
    }

    public Object getChild(int n) {
        return this.children.elementAt(n);
    }

    public Hashtable getNamespaceMap() {
        return this.namespaceMap;
    }

    public String getPrefix(String string) {
        return (String)this.namespaceMap.get(string);
    }

    public int getType(int n) {
        return this.types.charAt(n);
    }

    public Element createElement(Object object, String string, String string2, Vector vector) {
        return new DefaultElement(object, string, string2, vector);
    }

    public Element getRootElement() {
        return (Element)this.getChild(this.rootIndex);
    }

    public void parse(Parser parser) throws IOException {
        boolean bl = false;
        do {
            ParseEvent parseEvent = parser.read();
            switch (parseEvent.getType()) {
                case 60: {
                    StartTag startTag = (StartTag)parseEvent;
                    Element element = this.createElement(this, startTag.getNamespace(), startTag.getName(), startTag.getAttributes());
                    this.addChild(60, element);
                    element.parse(parser, startTag);
                    break;
                }
                case 116: {
                    String string = parseEvent.getText();
                    int n = string.length();
                    while (n-- > 0) {
                        if (string.charAt(n) <= ' ') continue;
                        throw new ParseException("Illegal Text at document level", parser.getLineNumber(), -1);
                    }
                    this.addChild(116, parseEvent.getText());
                    break;
                }
                case 46: {
                    bl = true;
                    break;
                }
                case 47: {
                    throw new RuntimeException("Unexpected end of document!");
                }
                default: {
                    this.addChild(parseEvent.getType(), parseEvent.getText());
                }
            }
        } while (!bl);
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlWriter xmlWriter = new XmlWriter(new OutputStreamWriter(byteArrayOutputStream));
            this.write(xmlWriter);
            xmlWriter.close();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException("StringWriter shouldn't throw an IOException?!?");
        }
    }

    public void write(XmlWriter xmlWriter) throws IOException {
        int n = 0;
        while (n < this.children.size()) {
            int n2 = this.getType(n);
            Object e = this.children.elementAt(n);
            if (n2 == 60) {
                ((Element)e).write(xmlWriter);
            } else if (n2 == 116) {
                xmlWriter.write((String)e);
            } else {
                xmlWriter.writeLegacy(n2, (String)e);
            }
            ++n;
        }
        xmlWriter.flush();
    }
}

