/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap;

import java.io.IOException;
import org.kobjects.serialization.KvmSerializable;
import org.ksoap.ClassMap;
import org.ksoap.SoapFault;
import org.ksoap.SoapParser;
import org.ksoap.SoapWriter;
import org.kxml.Attribute;
import org.kxml.XmlIO;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.StartTag;

public class SoapEnvelope {
    Object body;
    ClassMap classMap;
    String encodingStyle;

    public SoapEnvelope() {
        this(new ClassMap());
    }

    public SoapEnvelope(ClassMap classMap) {
        this.classMap = classMap;
    }

    public Object getBody() {
        return this.body;
    }

    public Object getResult() {
        KvmSerializable kvmSerializable = (KvmSerializable)this.body;
        return kvmSerializable.getPropertyCount() == 0 ? null : kvmSerializable.getProperty(0);
    }

    public void parse(AbstractXmlParser abstractXmlParser) throws IOException {
        this.parseHead(abstractXmlParser);
        this.parseBody(abstractXmlParser);
        this.parseTail(abstractXmlParser);
    }

    public void parseHead(AbstractXmlParser abstractXmlParser) throws IOException {
        abstractXmlParser.skip();
        StartTag startTag = (StartTag)abstractXmlParser.read(64, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        Attribute attribute = startTag.getAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        if (attribute != null) {
            this.encodingStyle = attribute.getValue();
        }
        abstractXmlParser.skip();
        if (abstractXmlParser.peek(64, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
            abstractXmlParser.ignoreTree();
        }
        abstractXmlParser.skip();
        startTag = (StartTag)abstractXmlParser.read(64, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        attribute = startTag.getAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        if (attribute != null) {
            this.encodingStyle = attribute.getValue();
        }
    }

    public void parseBody(AbstractXmlParser abstractXmlParser) throws IOException {
        abstractXmlParser.skip();
        if (abstractXmlParser.peek(64, "http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
            SoapFault soapFault = new SoapFault();
            soapFault.parse(abstractXmlParser);
            this.body = soapFault;
        } else {
            this.body = new SoapParser(abstractXmlParser, this.classMap).read();
        }
    }

    public void parseTail(AbstractXmlParser abstractXmlParser) throws IOException {
        abstractXmlParser.skip();
        abstractXmlParser.read(16, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        abstractXmlParser.skip();
        abstractXmlParser.read(16, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    }

    public void setEncodingStyle(String string) {
        this.encodingStyle = string;
    }

    public void write(AbstractXmlWriter abstractXmlWriter) throws IOException {
        this.writeHead(abstractXmlWriter);
        this.writeBody(abstractXmlWriter);
        this.writeTail(abstractXmlWriter);
    }

    public void writeHead(AbstractXmlWriter abstractXmlWriter) throws IOException {
        abstractXmlWriter.startTag(this.classMap.prefixMap, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        abstractXmlWriter.startTag("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    }

    public void writeBody(AbstractXmlWriter abstractXmlWriter) throws IOException {
        if (this.body instanceof XmlIO) {
            if (this.encodingStyle != null) {
                abstractXmlWriter.attribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.encodingStyle);
            }
            ((XmlIO)this.body).write(abstractXmlWriter);
        } else {
            abstractXmlWriter.attribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", this.encodingStyle == null ? "http://schemas.xmlsoap.org/soap/encoding/" : this.encodingStyle);
            new SoapWriter(abstractXmlWriter, this.classMap).write(this.body);
        }
    }

    public void writeTail(AbstractXmlWriter abstractXmlWriter) throws IOException {
        abstractXmlWriter.endTag();
        abstractXmlWriter.endTag();
    }

    public void setBody(Object object) {
        this.body = object;
    }

    public void setClassMap(ClassMap classMap) {
        this.classMap = classMap;
    }
}

