/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap;

import java.io.IOException;
import java.util.Vector;
import org.kobjects.serialization.ElementType;
import org.kobjects.serialization.KvmSerializable;
import org.kobjects.serialization.PropertyInfo;
import org.ksoap.ClassMap;
import org.ksoap.Marshal;
import org.kxml.io.AbstractXmlWriter;

public class SoapWriter {
    public AbstractXmlWriter writer;
    ClassMap classMap;
    Vector multiRef = new Vector();
    Vector types = new Vector();

    public SoapWriter(AbstractXmlWriter abstractXmlWriter, ClassMap classMap) {
        this.writer = abstractXmlWriter;
        this.classMap = classMap;
    }

    public void write(Object object) throws IOException {
        this.multiRef.addElement(object);
        this.types.addElement(ElementType.OBJECT_TYPE);
        int n = 0;
        while (n < this.multiRef.size()) {
            object = this.multiRef.elementAt(n);
            Object[] objectArray = this.classMap.getInfo(null, object);
            this.writer.startTag(this.classMap.prefixMap, (String)objectArray[0], (String)objectArray[1]);
            this.writer.attribute("id", objectArray[2] == null ? "o" + n : (String)objectArray[2]);
            if (n == 0) {
                this.writer.attribute("http://schemas.xmlsoap.org/soap/encoding/", "root", "1");
            }
            if (objectArray[3] != null) {
                ((Marshal)objectArray[3]).writeInstance(this, object);
            } else if (object instanceof KvmSerializable) {
                this.writeObjectBody((KvmSerializable)object);
            } else if (object instanceof Vector) {
                this.writeVectorBody((Vector)object, ((ElementType)this.types.elementAt((int)n)).elementType);
            } else {
                throw new RuntimeException("Cannot serialize: " + object);
            }
            this.writer.endTag();
            ++n;
        }
    }

    public void writeObjectBody(KvmSerializable kvmSerializable) throws IOException {
        PropertyInfo propertyInfo = new PropertyInfo();
        int n = kvmSerializable.getPropertyCount();
        int n2 = 0;
        while (n2 < n) {
            kvmSerializable.getPropertyInfo(n2, propertyInfo);
            Object object = kvmSerializable.getProperty(n2);
            this.writer.startTag(propertyInfo.name);
            this.writeProperty(kvmSerializable.getProperty(n2), propertyInfo);
            this.writer.endTag();
            ++n2;
        }
    }

    protected void writeProperty(Object object, ElementType elementType) throws IOException {
        if (object == null) {
            this.writer.attribute(this.classMap.xsi, "nil", "true");
            return;
        }
        Object[] objectArray = this.classMap.getInfo(null, object);
        if (elementType.multiRef || objectArray[2] != null) {
            int n = this.multiRef.indexOf(object);
            if (n == -1) {
                n = this.multiRef.size();
                this.multiRef.addElement(object);
                this.types.addElement(elementType);
            }
            this.writer.attribute("href", objectArray[2] == null ? "#o" + n : "#" + objectArray[2]);
        } else {
            if (!this.classMap.implicitTypes || object.getClass() != elementType.type) {
                String string = this.writer.getPrefixMap().getPrefix((String)objectArray[0]);
                if (string == null) {
                    throw new RuntimeException("Prefix for namespace " + objectArray[0] + " undefined!");
                }
                this.writer.attribute(this.classMap.xsi, "type", string + ":" + objectArray[1]);
            }
            if (objectArray[3] != null) {
                ((Marshal)objectArray[3]).writeInstance(this, object);
            } else if (object instanceof KvmSerializable) {
                this.writeObjectBody((KvmSerializable)object);
            } else if (object instanceof Vector) {
                this.writeVectorBody((Vector)object, elementType.elementType);
            } else {
                throw new RuntimeException("Cannot serialize: " + object);
            }
        }
    }

    protected void writeVectorBody(Vector vector, ElementType elementType) throws IOException {
        if (elementType == null) {
            elementType = ElementType.OBJECT_TYPE;
        }
        int n = vector.size();
        Object[] objectArray = this.classMap.getInfo(elementType.type, null);
        this.writer.attribute("http://schemas.xmlsoap.org/soap/encoding/", "arrayType", this.writer.getPrefixMap().getPrefix((String)objectArray[0]) + ":" + objectArray[1] + "[" + n + "]");
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == null) {
                bl = true;
            } else {
                this.writer.startTag("item");
                if (bl) {
                    this.writer.attribute("http://schemas.xmlsoap.org/soap/encoding/", "position", "[" + n2 + "]");
                    bl = false;
                }
                this.writeProperty(vector.elementAt(n2), elementType);
                this.writer.endTag();
            }
            ++n2;
        }
    }
}

