VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "OLE Drag avec format spcifique"
   ClientHeight    =   1080
   ClientLeft      =   7650
   ClientTop       =   5760
   ClientWidth     =   5790
   LinkTopic       =   "Form1"
   ScaleHeight     =   1080
   ScaleWidth      =   5790
   Begin VB.TextBox txtSource 
      Height          =   375
      Left            =   1380
      OLEDropMode     =   1  'Manual
      TabIndex        =   1
      Top             =   60
      Width           =   3795
   End
   Begin VB.TextBox txtDest 
      Height          =   375
      Left            =   1380
      OLEDropMode     =   1  'Manual
      TabIndex        =   3
      Top             =   540
      Width           =   3795
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Destination :"
      Height          =   195
      Left            =   300
      TabIndex        =   2
      Top             =   660
      Width           =   885
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Source :"
      Height          =   195
      Left            =   540
      TabIndex        =   0
      Top             =   180
      Width           =   600
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function RegisterClipboardFormat Lib "user32.dll" Alias "RegisterClipboardFormatA" (ByVal lpszFormat As String) As Integer
Dim MonFormat As Integer

'---- Initialisations
Private Sub Form_Load()
    ' Initialise les modes
    ' Glisser
    txtSource.OLEDragMode = vbOLEDragAutomatic
    txtDest.OLEDragMode = vbOLEDragManual
    ' Poser
    txtSource.OLEDropMode = vbOLEDropAutomatic
    txtDest.OLEDropMode = vbOLEDropManual
    
    ' Cr un format particulier
    MonFormat = RegisterClipboardFormat("Chane code")
End Sub

'---- Demande initiale des donnes
Private Sub txtSource_OLEStartDrag(Data As DataObject, AllowedEffects As Long)
    ' Texte de la source
    Dim txt As String
    txt = txtSource.SelText
    
    ' Supprime les donnes places automatiquement
    Data.Clear
    
    ' Construit un tableau de bytes pour les donnes :
    ' 1er caractre = nombre de caractres (limit  255)
    ' caractres suivants : caractres de la chane, augments de 1 (codage)
    Dim t() As Byte
    ReDim t(1 To Len(txt) + 1) As Byte
    Dim i, l
    ' Longueur
    l = Len(txt)
    ' Limite  255
    If l > 255 Then l = 155
    ' Stocke la longueur
    t(1) = l
    ' Ajoute les caractres +1
    For i = 1 To l
        t(i + 1) = Asc(Mid(txt, i, 1)) + 1
    Next
    ' Donne le tableau construit pour le glisser-poser
    Data.SetData t, MonFormat
End Sub

'---- Passage sur la destination
Private Sub txtDest_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    ' Indique si le dpt est possible
    If Data.GetFormat(MonFormat) Then
        ' Copie ou dplacement, selon touche CTRL
        Effect = IIf(Shift And vbCtrlMask, vbDropEffectCopy, vbDropEffectMove)
    Else
        ' Refuse toute autres donnes (on pourrait laisser passer le texte...)
        Effect = vbDropEffectNone
    End If
End Sub

'---- Dpt des dennes sur la destination
Private Sub txtDest_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim t() As Byte
    Dim txt As String
    Dim l As Integer
    Dim i
    ' Les donnes sont-elles dans notre format ?
    If Data.GetFormat(MonFormat) Then
        ' Indique si copie ou dplacement, pour le OLECompleteDrag qui suit
        Effect = IIf(Shift And vbCtrlMask, vbDropEffectCopy, vbDropEffectMove)
        ' Rcupre les donnes
        t = Data.GetData(MonFormat)
        ' Longueur
        l = t(1)
        For i = 1 To l
            ' Place chaque octet dans la chane aprs l'avoir dcod (-1)
            txt = txt & Chr(t(i + 1) - 1)
        Next
    
        ' Met dans la slection
        txtDest.SelText = txt
    End If
End Sub

'---- Fin du poser pour la source
Private Sub txtSource_OLECompleteDrag(Effect As Long)
    ' Si dplacement, supprime les donnes de la source
    If Effect And vbDropEffectMove Then txtSource.SelText = ""
End Sub

