VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SubClasser"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Description = "Subclass a Windows window"
Option Explicit

'---- Evnement
Event WindowMessage(ByVal hwnd As Long, ByVal uMsg As Long, _
        ByVal wParam As Long, ByVal lParam As Long, Result As Long, CallDefault As Boolean)

'---- Donnes prives
Private m_hwnd As Long
Private fSubclassed As Boolean

'---- Proprit hwnd
Public Property Let hwnd(newValue As Long)
    If m_hwnd <> 0 Then
        m_hwnd = newValue
    End If
End Property

Public Property Get hwnd() As Long
    hwnd = m_hwnd
End Property

'---- Mthode SubClass
Public Sub SubClass(Optional hwnd As Long)
    ' Dj sous-class ?
    If fSubclassed Then
        Err.Raise Number:=33001, Description:="Fentre dj sous-classe"
        Exit Sub
    End If
    
    ' Nouveau hwnd
    If Not IsMissing(hwnd) Then m_hwnd = hwnd
    ' Vrifie non nul
    If m_hwnd = 0 Then
        Err.Raise Number:=33000, Description:="hwnd est null"
        Exit Sub
    End If
    
    ' Fait le sous-classement
    modSubClass Me
    fSubclassed = True
End Sub

'---- Mthode ReClass
Public Sub ReClass()
    ' Vrifie sous-classement en cours
    If Not fSubclassed Then
        Err.Raise Number:=33002, Description:="Fentre pas sous-classe"
        Exit Sub
    End If
    
    ' Retire le sous-classement
    modReClass Me
    fSubclassed = False
End Sub

'---- Appelle la procdure d'origine
Public Function CallPrevWindowProc(ByVal hwnd As Long, ByVal uMsg As Long, _
        ByVal wParam As Long, ByVal lParam As Long) As Long
    CallPrevWindowProc = modCallPrevWindowProc(hwnd, uMsg, wParam, lParam)
End Function

'---- Message dans la WindowProc
Friend Function Message(ByVal hwnd As Long, ByVal uMsg As Long, _
        ByVal wParam As Long, ByVal lParam As Long, CallDefault As Boolean) As Long
    Dim Result As Long
    Result = 0
    ' Gnre le message
    RaiseEvent WindowMessage(hwnd, uMsg, wParam, lParam, Result, CallDefault)
    ' Rsultat
    Message = Result
End Function

'---- Termine
Private Sub Class_Terminate()
    If fSubclassed Then
        ' Retire le sous-classement
        modReClass Me
    End If
End Sub
