VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "Glisser-dposer sur listes"
   ClientHeight    =   3630
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5055
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   3630
   ScaleWidth      =   5055
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox pctInsert 
      Appearance      =   0  'Flat
      BackColor       =   &H00000000&
      ForeColor       =   &H80000008&
      Height          =   75
      Left            =   3000
      ScaleHeight     =   45
      ScaleWidth      =   1305
      TabIndex        =   2
      Top             =   2520
      Visible         =   0   'False
      Width           =   1335
   End
   Begin VB.ListBox lstDest 
      Height          =   2595
      Left            =   2760
      TabIndex        =   1
      Top             =   540
      Width           =   1815
   End
   Begin VB.ListBox lstSource 
      Height          =   2595
      Left            =   240
      TabIndex        =   0
      Top             =   540
      Width           =   1815
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Indicateur de Drag possible
Private DragOk As Boolean

' Sous-classement
Dim WithEvents sc As SubClasser

'---------------- Procdures gnrales ----------------
'---- Chargement
Private Sub Form_Load()
    Dim i As Integer
    
    ' Remplit la liste source
    For i = 1 To 20
        ' Ajoute l'lment
        lstSource.AddItem "Source " & i
    Next
    
    ' Remplit la liste destination
    For i = 1 To 5
        ' Ajoute l'lment
        lstDest.AddItem "Destination " & i
    Next
    
    ' Initialise les proprits
    lstSource.OLEDragMode = vbOLEDragManual
    lstDest.OLEDropMode = vbOLEDropManual
    
    ' Sous-classement de la barre d'insertion
    Set sc = New SubClasser
    sc.SubClass pctInsert.hwnd
End Sub

'---- Dchargement
Private Sub Form_Unload(Cancel As Integer)
    ' Retire le sous-classement
    sc.ReClass
    Set sc = Nothing
End Sub

'---------------- Traitement de la source ----------------
'---- MouseDown
Private Sub lstSource_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    ' Indique si le drag peut commencer au prochain dplacement
    DragOk = lstSource.ListIndex <> -1
End Sub

'---- MouseMove
Private Sub lstSource_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    If DragOk Then
        ' Initialise le drag
        DragOk = False
        lstSource.OLEDrag
    End If
End Sub

'---- MouseUp
Private Sub lstSource_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    DragOk = False
End Sub

'---- OLEStartDrag
Private Sub lstSource_OLEStartDrag(Data As DataObject, AllowedEffects As Long)
    ' Promet les donnes
    Data.SetData , vbCFText
    ' Autorise copie et dplacement
    AllowedEffects = vbDropEffectCopy + vbDropEffectMove
End Sub

'---- OLEGiveFeedback
Private Sub lstSource_OLEGiveFeedback(Effect As Long, DefaultCursors As Boolean)
    DefaultCursors = True
End Sub

'---- OLESetData
Private Sub lstSource_OLESetData(Data As DataObject, DataFormat As Integer)
    ' Fournit effectivement les donnes
    If DataFormat = vbCFText Then
        Data.SetData lstSource.Text, vbCFText
    End If
End Sub

'---- OLECompleteDrag
Private Sub lstSource_OLECompleteDrag(Effect As Long)
    ' Cache la barre d'insersion
    pctInsert.Visible = False
    ' Si dplacement, supprime de la source
    If Effect = vbDropEffectMove Then
        lstSource.RemoveItem lstSource.ListIndex
    End If
End Sub

'---------------- Traitement de la destination ----------------
'---- OLEDragOver
Private Sub lstDest_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single, State As Integer)
    ' Positionne la barre d'insertion
    pctInsert.Move lstDest.Left, GetCurrentItemTop(lstDest, x, y), lstDest.Width
    pctInsert.Visible = True
    
    ' Indique s'il s'agit d'une copie ou d'un dplacement
    If Shift And vbCtrlMask Then
        Effect = vbDropEffectCopy
    Else
        Effect = vbDropEffectMove
    End If
    
    ' Sortie du contrle
    If State = vbLeave Then pctInsert.Visible = False
End Sub

'---- OLEDragDrop
Private Sub lstDest_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)
    ' Rcupre les donnes et les insre
    If Data.GetFormat(vbCFText) Then
        Dim iInsert As Integer
        Dim Out As Boolean
        iInsert = GetItemFromPoint(lstDest, x, y, Out)
        If Out And iInsert = lstDest.ListCount - 1 Then
            lstDest.AddItem Data.GetData(vbCFText), iInsert + 1
        Else
            lstDest.AddItem Data.GetData(vbCFText), iInsert
        End If
    End If
    
    ' Indique s'il s'agit d'une copie ou d'un dplacement
    If Shift And vbCtrlMask Then
        Effect = vbDropEffectCopy
    Else
        Effect = vbDropEffectMove
    End If
End Sub

'---- GetItemFromPoint
Private Function GetItemFromPoint(lst As ListBox, ByVal x As Integer, ByVal y As Integer, Optional Out As Boolean) As Integer
    ' Passe en pixels
    Dim l As Long
    l = CLng(y / Screen.TwipsPerPixelY) * 2 ^ 16 + x / Screen.TwipsPerPixelX
    ' Demande l'lment  la liste
    Dim iRet As Long
    iRet = SendMessage(lst.hwnd, LB_ITEMFROMPOINT, 0, ByVal l)
    ' Valeur de retour
    GetItemFromPoint = LOWORD(iRet)
    ' Indicateur en dehors de l'lment
    If Not IsMissing(Out) Then Out = (HIWORD(iRet) = 1)
End Function

'---- GetCurrentItemTop
Private Function GetCurrentItemTop(lst As ListBox, ByVal x As Integer, ByVal y As Integer) As Integer
    ' Elment courant
    Dim iItem As Integer
    Dim Out As Boolean
    iItem = GetItemFromPoint(lst, x, y, Out)
    
    ' Rectangle de l'lment
    Dim rc As RECT
    SendMessage lstDest.hwnd, LB_GETITEMRECT, iItem, rc
    
    ' Calcule le point haut
    Dim h As Integer
    If Out And iItem = lst.ListCount - 1 Then h = rc.Bottom Else h = rc.Top
    GetCurrentItemTop = h * Screen.TwipsPerPixelX + lst.Top
End Function

'---- Procdure de sous-classement de la barre d'insertion
Private Sub sc_WindowMessage(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long, Result As Long, CallDefault As Boolean)
    If uMsg = WM_NCHITTEST Then
        ' Indique que la barre est transparente
        CallDefault = False
        Result = HTTRANSPARENT
    Else
        CallDefault = True
    End If
End Sub
