VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Adresses"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'---- Collection prive des adresses
Private mAdresses As New Collection

'---- Ajoute une adresse
Public Function Ajoute(adr As Adresse) As Integer
Dim cl As String
Dim i As Integer
Dim a As Adresse
Dim fAjout As Boolean

    'Cherche l'emplacement
    cl = adr.Nom
    fAjout = False
    For i = 1 To mAdresses.Count
        Set a = mAdresses(i)
        'Cl existe dj
        If a.Nom = cl Then
            Ajoute = 0
            Exit Function
        End If
        'Cl suivante
        If a.Nom > cl Then
            mAdresses.Add adr, cl, before:=i
            fAjout = True
            Exit For
        End If
    Next
    
    'Si pas trouv, l'ajoute en fin
    If Not fAjout Then mAdresses.Add adr, cl
    
    Ajoute = mAdresses.Count
End Function

'---- Supprime une adresse
Public Sub Supprime(i As Integer)
    mAdresses.Remove i
End Sub

'---- Supprime toutes les adresses
Public Sub SupprimeTout()
    Do While mAdresses.Count > 0
        mAdresses.Remove 1
    Loop
End Sub

'---- Enregistre un fichier
Public Sub Enregistre(fic As String)
Dim ficnum As Integer
Dim adr As Adresse

    'Ouvre le fichier
    ficnum = FreeFile
    Open fic For Output As ficnum
    
    'Ecrit le nombre d'adresses
    Print #ficnum, mAdresses.Count
    
    'Parcourt les adresses
    For Each adr In mAdresses
        ' Demande  l'adresse de s'crire
        adr.Ecrit ficnum
    Next
    
    Close ficnum
End Sub

'---- Lit un fichier
Public Sub Ouvre(fic As String)
Dim ficnum As Integer
Dim adr As Adresse
Dim nb
Dim i As Integer

    'Ouvre le fichier
    ficnum = FreeFile
    Open fic For Input As ficnum
    
    'Lit le nombre d'adresses
    Line Input #ficnum, nb
    
    'Parcourt les adresses
    For i = 1 To nb
        ' Cre l'adresse
        Set adr = New Adresse
        ' Lui demande de lire
        adr.Lit ficnum
        ' L'ajoute  la collection
        Ajoute adr
    Next
    
    Close ficnum
End Sub

'---- Proprit Nombre : retourne le nombre d'adresses
Property Get Nombre() As Integer
    Nombre = mAdresses.Count
End Property

'---- Proprit Elem : retourne un lment
Property Get Elem(elm) As Adresse
Attribute Elem.VB_ProcData.VB_Invoke_Property = ";(Aucun)"
Attribute Elem.VB_UserMemId = 0
    ' Le paramtre peut tre un entier ou une chane
    If VarType(elm) = vbInteger Then
        ' Entier : numro d'lment
        If elm >= 1 And elm <= mAdresses.Count Then
            Set Elem = mAdresses.Item(elm)
        Else
            Set Elem = Nothing
        End If
        
    ElseIf VarType(elm) = vbString Then
        ' Chane : nom
        On Error Resume Next
        If Not Err Then
            Set Elem = mAdresses.Item(elm)
        Else
            Set Elem = Nothing
        End If
    Else
        ' Autres (on pourrait gnrer une erreur
        Set Elem = Nothing
    End If
End Property
