VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Disques et fichiers"
   ClientHeight    =   5265
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6270
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5265
   ScaleWidth      =   6270
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraFiles 
      Caption         =   "Files"
      Height          =   1635
      Left            =   120
      TabIndex        =   4
      Top             =   3480
      Width           =   6015
      Begin VB.TextBox txtFile 
         Height          =   1215
         Left            =   1920
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   8
         Top             =   240
         Width           =   3735
      End
      Begin VB.ListBox lstFiles 
         Height          =   1230
         Left            =   120
         Sorted          =   -1  'True
         TabIndex        =   5
         Top             =   240
         Width           =   1575
      End
   End
   Begin VB.Frame fraFolders 
      Caption         =   "Folders"
      Height          =   1635
      Left            =   120
      TabIndex        =   2
      Top             =   1740
      Width           =   6015
      Begin VB.TextBox txtFolder 
         Height          =   1215
         Left            =   1920
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   7
         Top             =   240
         Width           =   3735
      End
      Begin VB.ListBox lstFolders 
         Height          =   1230
         Left            =   120
         Sorted          =   -1  'True
         TabIndex        =   3
         Top             =   240
         Width           =   1575
      End
   End
   Begin VB.Frame fraDrives 
      Caption         =   "Drives"
      Height          =   1635
      Left            =   120
      TabIndex        =   0
      Top             =   60
      Width           =   6015
      Begin VB.TextBox txtDrive 
         Height          =   1215
         Left            =   1920
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   6
         Top             =   240
         Width           =   3735
      End
      Begin VB.ListBox lstDrives 
         Height          =   1230
         Left            =   120
         Sorted          =   -1  'True
         TabIndex        =   1
         Top             =   240
         Width           =   1575
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Systme de fichier
Dim fso As New FileSystemObject
' Chemin courant
Private CurrentPath As String

'---- Load
Private Sub Form_Load()
    ' Remplit la liste des disques
    RemplitDrives
End Sub

'---- RemplitDrives
Private Sub RemplitDrives()
    Dim d As Drive
    Dim txt As String
    
    ' Vide les listes et textes
    NouveauDrive
    NouveauFolder
    NouveauFile
    
    ' Chemin courant
    CurrentPath = ""
    
    ' Ajoute les noms de disques
    For Each d In fso.Drives
        ' Chemin du disque
        txt = d.Path
        ' Ajoute le nom de volume
        If d.IsReady Then txt = txt & " [" & d.VolumeName & "]"
        ' Dans la liste
        lstDrives.AddItem txt
    Next
End Sub

'---- RemplitFolders
Private Sub RemplitFolders(ByVal Path As String)
    ' Vide les folders
    NouveauFolder
    
    ' Ajoute ventuellement ".." pour remonter
    If Not fso.GetFolder(Path).IsRootFolder Then
        lstFolders.AddItem ".."
    End If
    
    ' Boucle sur les folders
    Dim f As Folder
    For Each f In fso.GetFolder(Path).SubFolders
        lstFolders.AddItem f.Name
    Next
End Sub

'---- RemplitFiles
Private Sub RemplitFiles(ByVal Path As String)
    ' Vide les files
    NouveauFile
    
    ' Folder courant
    Dim fld As Folder
    Set fld = fso.GetFolder(Path)
    
    ' Liste des fichiers
    Dim f As File
    For Each f In fld.Files
        lstFiles.AddItem f.Name
    Next
End Sub

'---- Slection d'un disque
Private Sub lstDrives_Click()
    ' Sablier
    Screen.MousePointer = vbHourglass
    
    ' Cherche le drive
    Dim d As Drive
    Set d = fso.GetDrive(Left(lstDrives.Text, 1))
    ' Chemin courant
    CurrentPath = d.Path & "\"
    
    ' Remplit le texte
    With txtDrive
        .Text = ""
        On Error Resume Next
        .Text = .Text & "AvailableSpace: " & d.AvailableSpace & vbCrLf
        .Text = .Text & "DriveLetter: " & d.DriveLetter & vbCrLf
        .Text = .Text & "DriveType: " & DriveTypeString(d.DriveType) & vbCrLf
        .Text = .Text & "FileSystem: " & d.FileSystem & vbCrLf
        .Text = .Text & "FreeSpace: " & d.FreeSpace & vbCrLf
        .Text = .Text & "Path: " & d.Path & vbCrLf
        .Text = .Text & "RootFolder: " & d.RootFolder & vbCrLf
        .Text = .Text & "SerialNumber: " & d.SerialNumber & vbCrLf
        .Text = .Text & "ShareName: " & d.ShareName & vbCrLf
        .Text = .Text & "TotalSize: " & d.TotalSize & vbCrLf
        .Text = .Text & "VolumeName: " & d.VolumeName & vbCrLf
    End With
    
    ' Remplit la liste de folders
    If d.IsReady Then
        ' Remplit la liste de dossiers
        RemplitFolders CurrentPath
        
        ' Remplit la liste de fichiers
        RemplitFiles CurrentPath
    
    Else
        ' Vide les folders et files
        NouveauFolder
        NouveauFile
    End If
    
    ' Fin sablier
    Screen.MousePointer = vbDefault
End Sub

'---- Slection d'un folder
Private Sub lstFolders_Click()
    ' Ne fait rien pour ".."
    If lstFolders.Text = ".." Then Exit Sub
    
    ' Sablier
    Screen.MousePointer = vbHourglass
    
    ' Folder courant
    Dim f As Folder
    Set f = fso.GetFolder(AddPath(CurrentPath, lstFolders.Text))
    
    ' Remplit le texte
    With txtFolder
        .Text = ""
        On Error Resume Next
        .Text = .Text & "Attributes: " & AttributesString(f.Attributes) & vbCrLf
        .Text = .Text & "DateCreated: " & f.DateCreated & vbCrLf
        .Text = .Text & "DateLastAccessed: " & f.DateLastAccessed & vbCrLf
        .Text = .Text & "DateLastModified: " & f.DateLastModified & vbCrLf
        .Text = .Text & "IsRootFolder: " & f.IsRootFolder & vbCrLf
        .Text = .Text & "Name: " & f.Name & vbCrLf
        .Text = .Text & "ShortName: " & f.ShortName & vbCrLf
        .Text = .Text & "Path: " & f.Path & vbCrLf
        .Text = .Text & "ShortPath: " & f.ShortPath & vbCrLf
        .Text = .Text & "Size: " & f.Size & vbCrLf
        .Text = .Text & "Type: " & f.Type & vbCrLf
        .Text = .Text & "Folders: " & f.SubFolders.Count & vbCrLf
        .Text = .Text & "Files: " & f.Files.Count & vbCrLf
    End With
    
    ' Remplit la liste des fichiers
    RemplitFiles f.Path
    
    ' Fin sablier
    Screen.MousePointer = vbDefault
End Sub

'---- Slection d'un fichier
Private Sub lstFiles_Click()
    ' Sablier
    Screen.MousePointer = vbHourglass
    
    ' Folder courant
    Dim fld As Folder
    Set fld = fso.GetFolder(AddPath(CurrentPath, lstFolders.Text))
    ' Fichier courant
    Dim f As File
    Set f = fso.GetFile(AddPath(fld.Path, lstFiles.Text))
    
    ' Remplit le texte
    With txtFile
        .Text = ""
        .Text = .Text & "Attributes: " & AttributesString(f.Attributes) & vbCrLf
        .Text = .Text & "DateCreated: " & f.DateCreated & vbCrLf
        .Text = .Text & "DateLastAccessed: " & f.DateLastAccessed & vbCrLf
        .Text = .Text & "DateLastModified: " & f.DateLastModified & vbCrLf
        .Text = .Text & "Name: " & f.Name & vbCrLf
        .Text = .Text & "ShortName: " & f.ShortName & vbCrLf
        .Text = .Text & "Path: " & f.Path & vbCrLf
        .Text = .Text & "ShortPath: " & f.ShortPath & vbCrLf
        .Text = .Text & "Size: " & f.Size & vbCrLf
        .Text = .Text & "Type: " & f.Type & vbCrLf
    End With

    
    ' Fin sablier
    Screen.MousePointer = vbDefault
End Sub

'---- Changement de folder
Private Sub lstFolders_DblClick()
    ' Rpertoire slectionn
    Dim fPath As String
    Dim OK As Boolean
    If lstFolders.Text = ".." Then
        ' On remonte
        fPath = fso.GetParentFolderName(CurrentPath)
        OK = True
    Else
        ' On descend
        fPath = AddPath(CurrentPath, lstFolders.Text)
        Dim f As Folder
        Set f = fso.GetFolder(fPath)
        OK = f.SubFolders.Count > 0
    End If
    
    ' Traite
    If OK Then
        ' Nouveau rpertoire courant
        CurrentPath = fPath
        
        ' Remplit la liste
        RemplitFolders CurrentPath
    End If
End Sub

'---- NouveauDrive
Private Sub NouveauDrive()
    lstDrives.Clear
    txtDrive = ""
End Sub

'---- NouveauFolder
Private Sub NouveauFolder()
    lstFolders.Clear
    txtFolder = ""
End Sub

'---- NouveauFile
Private Sub NouveauFile()
    lstFiles.Clear
    txtFile = ""
End Sub

'---- DriveTypeString
Private Function DriveTypeString(DriveType As DriveTypeConst) As String
    Select Case DriveType
        Case CDRom
            DriveTypeString = "CDRom"
        Case Fixed
            DriveTypeString = "Fixed"
        Case RamDisk
            DriveTypeString = "RamDisk"
        Case Remote
            DriveTypeString = "Remote"
        Case Removable
            DriveTypeString = "Removable"
        Case Unknown
            DriveTypeString = "Unknown"
    End Select
End Function

'---- AttributesString
Private Function AttributesString(Attributes As FileAttribute) As String
    AttributesString = ""
    If Attributes And Alias Then AttributesString = AttributesString & "Alias" & " "
    If Attributes And Archive Then AttributesString = AttributesString & "Archive" & " "
    If Attributes And Compressed Then AttributesString = AttributesString & "Compressed" & " "
    If Attributes And Directory Then AttributesString = AttributesString & "Directory" & " "
    If Attributes And Hidden Then AttributesString = AttributesString & "Hidden" & " "
    If Attributes And Normal Then AttributesString = AttributesString & "Normal" & " "
    If Attributes And ReadOnly Then AttributesString = AttributesString & "ReadOnly" & " "
    If Attributes And System Then AttributesString = AttributesString & "System" & " "
    If Attributes And Volume Then AttributesString = AttributesString & "Volume" & " "
End Function

'---- AddPath
Private Function AddPath(Path As String, Item As String) As String
    AddPath = Path
    If Right(AddPath, 1) <> "\" Then AddPath = AddPath & "\"
    AddPath = AddPath & Item
End Function
