Attribute VB_Name = "WindowProc"
Option Explicit

'---- Constantes systme pour la bordure
Dim cxFrame As Integer
Dim cyFrame As Integer
Dim cyCaption As Integer

'---- Initialisations
Public Sub Init()
    ' Recherche les constantes de bordures
    cxFrame = GetSystemMetrics(SM_CXFRAME)
    cyFrame = GetSystemMetrics(SM_CYFRAME)
    cyCaption = GetSystemMetrics(SM_CYCAPTION)
End Sub

'---- Met en place le sous classement
Public Sub SousClasse(hwnd As Long)
    ' Sous classe
    If Not GetPrevWindowProc(hwnd) Then
        Dim lpPrevWindowProc As Long
        lpPrevWindowProc = SetWindowLong(hwnd, GWL_WNDPROC, AddressOf WindowProc)
        StorePrevWindowProc hwnd, lpPrevWindowProc
    End If
End Sub

'---- Retire le sous classement
Public Sub ReClasse(hwnd As Long)
    Dim lpPrevWindowProc As Long
    lpPrevWindowProc = GetPrevWindowProc(hwnd)
    If lpPrevWindowProc Then
        SetWindowLong hwnd, GWL_WNDPROC, lpPrevWindowProc
    End If
End Sub

'---- Nouvelle procdure de fentre
Function WindowProc(ByVal hwnd As Long, ByVal uMsg As Long, _
        ByVal wParam As Long, ByVal lParam As Long) As Long
    ' Indique si appel  la procdure prcdente
    Dim fCall As Boolean: fCall = True

    ' Traite le message
    Select Case uMsg
        Case WM_NCHITTEST
            ' Rectangle de la fentre
            Dim rc As RECT
            GetWindowRect hwnd, rc
            ' Point du hittest
            Dim x As Integer, y As Integer
            x = LOWORD(lParam)
            y = HIWORD(lParam)
            If Abs(rc.Left - x) < cxFrame Then
                ' Ct gauche
                If Abs(rc.Top - y) < cyCaption Then
                    ' Coin haut et gauche
                    WindowProc = HTTOPLEFT
                ElseIf Abs(rc.Bottom - y) < cyCaption Then
                    ' Coin bas et gauche
                    WindowProc = HTBOTTOMLEFT
                Else
                    ' Ct gauche
                    WindowProc = HTLEFT
                End If
            ElseIf Abs(rc.Right - x) < cxFrame Then
                ' Ct droit
                If Abs(rc.Top - y) < cyCaption Then
                    ' Coin haut et droite
                    WindowProc = HTTOPRIGHT
                ElseIf Abs(rc.Bottom - y) < cyCaption Then
                    ' Coin bas et droite
                    WindowProc = HTBOTTOMRIGHT
                Else
                    ' Ct droite
                    WindowProc = HTRIGHT
                End If
            ElseIf Abs(rc.Top - y) < cyFrame Then
                ' Ct haut
                If Abs(rc.Left - x) < cyCaption Then
                    ' Coin haut et gauche
                    WindowProc = HTTOPLEFT
                ElseIf Abs(rc.Right - x) < cyCaption Then
                    ' Coin haut et droit
                    WindowProc = HTTOPRIGHT
                Else
                    ' Ct haut
                    WindowProc = HTTOP
                End If
            ElseIf Abs(rc.Bottom - y) < cyFrame Then
                ' Ct bas
                If Abs(rc.Left - x) < cyCaption Then
                    ' Coin bas et gauche
                    WindowProc = HTBOTTOMLEFT
                ElseIf Abs(rc.Right - x) < cyCaption Then
                    ' Coin bas et droit
                    WindowProc = HTBOTTOMRIGHT
                Else
                    ' Ct bas
                    WindowProc = HTBOTTOM
                End If
            Else
                WindowProc = HTCAPTION
            End If
            fCall = False
    End Select
    
    ' Appel de la procdure d'origine
    If fCall Then
        WindowProc = CallWindowProc(GetPrevWindowProc(hwnd), hwnd, uMsg, wParam, lParam)
    End If
End Function

'---- Retourne le mot bas d'un long
Function LOWORD(l As Long) As Integer
    LOWORD = l And &HFFFF&
End Function

'---- Retourne le mot haut d'un long
Function HIWORD(l As Long) As Integer
    HIWORD = CInt((l And &HFFFF0000) / 65536)
End Function

'---- Enregistre l'ancienne WindowProc d'une fentre
Public Sub StorePrevWindowProc(hwnd As Long, lpPrevWindowProc As Long)
    SetProp hwnd, "PrevWindowProc", lpPrevWindowProc
End Sub

'---- Retourne l'ancienne WindowProc d'une fentre
Public Function GetPrevWindowProc(hwnd As Long) As Long
    GetPrevWindowProc = GetProp(hwnd, "PrevWindowProc")
End Function

'---- Retire l'ancienne WindowProc d'une fentre
Public Sub RemovePrevWindowProc(hwnd As Long)
    RemoveProp hwnd, "PrevWindowProc"
End Sub
