VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Connect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Description = "Ordonne les contrles"
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Implmente le modle d'extensibilit
Implements IDTExtensibility

' Instance courante
Public VBInstance As VBIDE.VBE

' Traitement des vnements des boutons
Public WithEvents evtTabOrder As CommandBarEvents
Attribute evtTabOrder.VB_VarHelpID = -1

' Boutons pour le complment dans la barre d'outils
Private mcbCtrlTabOrder As Office.CommandBarControl

'---- Ajoute le complment
Private Sub IDTExtensibility_OnConnection(ByVal VBInst As Object, ByVal ConnectMode As vbext_ConnectMode, ByVal AddInInst As VBIDE.AddIn, custom() As Variant)
    
    On Error GoTo OnConnectionErr
    
    ' Sauve l'instance courante
    Set VBInstance = VBInst

    ' Ajoute "TabOrder" dans la barre d'outils
    Set mcbCtrlTabOrder = AjouteBarreOutils("Standard", 100, 1000)
    If mcbCtrlTabOrder Is Nothing Then GoTo OnConnectionErrButton
    ' Indique le gestionnaire d'vnements
    Set Me.evtTabOrder = VBInst.Events.CommandBarEvents(mcbCtrlTabOrder)

    Exit Sub

' Erreur
OnConnectionErr:
    MsgBox Err.Description
    Exit Sub

' Ne peut ajouter un bouton
OnConnectionErrButton:
    MsgBox "Ne peut crer un bouton dans la barre d'outils"
    Exit Sub
End Sub

'---- Retire le complment
Private Sub IDTExtensibility_OnDisconnection(ByVal RemoveMode As vbext_DisconnectMode, custom() As Variant)
    On Error Resume Next
    
    ' Supprime les boutons de la barre d'outils
    mcbCtrlTabOrder.Delete
End Sub

Private Sub IDTExtensibility_OnStartupComplete(custom() As Variant)
'
End Sub

Private Sub IDTExtensibility_OnAddInsUpdate(custom() As Variant)
'
End Sub

'---- Ajoute un bouton dans une barre
Function AjouteBarreOutils(sBar As String, idCaption As Integer, idBitmap As Integer) As Office.CommandBarControl
    On Error GoTo AjouteBarreOutilsErr
    
    ' Cherche la barre standard
    Dim cb As CommandBar
    Set cb = VBInstance.CommandBars(sBar)
    If cb Is Nothing Then
        ' Pas trouv
        Set AjouteBarreOutils = Nothing
        Exit Function
    End If
    ' Rend visible
    cb.Visible = True
    
    ' Ajoute le bouton
    Dim ctrl As Office.CommandBarButton
    Set ctrl = cb.Controls.Add(msoControlButton, , , cb.Controls.Count)
    ' Modifie le texte
    ctrl.Caption = LoadResString(idCaption)
    ' et l'icne
    Clipboard.SetData LoadResPicture(idBitmap, vbResBitmap)
    ctrl.PasteFace
    ' Nouveau groupe
    ctrl.BeginGroup = True
    
    ' Termine
    Set AjouteBarreOutils = ctrl
    Exit Function

' Erreur
AjouteBarreOutilsErr:
    Set AjouteBarreOutils = Nothing
End Function

'---- Clic sur TabOrder
Private Sub evtTabOrder_Click(ByVal CommandBarControl As Object, handled As Boolean, CancelDefault As Boolean)
    With VBInstance.SelectedVBComponent
        ' Regarde si la slection est un designer
        If .Type = vbext_ct_VBForm Or _
            .Type = vbext_ct_ActiveXDesigner Or _
            .Type = vbext_ct_DocObject Or _
            .Type = vbext_ct_MSForm Or _
            .Type = vbext_ct_PropPage Then
            ' Ajoute les contrles du designer dans une collection CControls
            ' pour les trier
            If .Designer.VBControls.Count = 0 Then
                MsgBox "Pas de contrle"
                Exit Sub
            End If
            
            Dim col As CControls
            Set col = New CControls
            Dim c As VBControl
            For Each c In .Designer.VBControls
                col.Add c.ControlObject
            Next
            
            ' Relit la collection, dans l'ordre
            Dim i As Integer
            Dim t As Integer
            On Error Resume Next
            For i = 1 To col.Count
                col(i).TabIndex = t
                If Not Err Then t = t + 1
            Next
            
            ' Termine
            Set col = Nothing
            MsgBox "Contrles ordonns !"
        End If
    End With
End Sub
