VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmMain 
   Caption         =   "Editeur de textes"
   ClientHeight    =   3990
   ClientLeft      =   1065
   ClientTop       =   1815
   ClientWidth     =   8040
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3990
   ScaleWidth      =   8040
   Begin MSComctlLib.Toolbar tb 
      Align           =   1  'Align Top
      Height          =   420
      Left            =   0
      TabIndex        =   2
      Top             =   0
      Width           =   8040
      _ExtentX        =   14182
      _ExtentY        =   741
      Appearance      =   1
      ImageList       =   "ImageList1"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   7
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Combo"
            Style           =   4
            Object.Width           =   2500
            MixedState      =   -1  'True
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Bold"
            Object.ToolTipText     =   "Caractres gras"
            ImageKey        =   "Bold"
            Style           =   1
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Italic"
            Object.ToolTipText     =   "Caractres italiques"
            ImageKey        =   "Italic"
            Style           =   1
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Style           =   3
            MixedState      =   -1  'True
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Left"
            Object.ToolTipText     =   "Aligner le paragraphe  gauche"
            ImageKey        =   "Left"
            Style           =   2
            Value           =   1
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Center"
            Object.ToolTipText     =   "Centrer le paragraphe"
            ImageKey        =   "Center"
            Style           =   2
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Key             =   "Right"
            Object.ToolTipText     =   "Aligner le paragraphe  droite"
            ImageKey        =   "Right"
            Style           =   2
         EndProperty
      EndProperty
      Begin VB.TextBox txtSize 
         Height          =   315
         Left            =   1920
         TabIndex        =   4
         Top             =   50
         Width           =   495
      End
      Begin VB.ComboBox cmbPolice 
         Height          =   315
         Left            =   100
         Sorted          =   -1  'True
         TabIndex        =   3
         Top             =   50
         Width           =   1815
      End
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   2000
      Left            =   120
      Top             =   2040
   End
   Begin MSComctlLib.StatusBar tat 
      Align           =   2  'Align Bottom
      Height          =   270
      Left            =   0
      TabIndex        =   1
      Top             =   3720
      Width           =   8040
      _ExtentX        =   14182
      _ExtentY        =   476
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   6
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   7567
            MinWidth        =   1058
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   2
            Object.Width           =   1058
            MinWidth        =   1058
            Key             =   "Position"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   1
            Alignment       =   1
            AutoSize        =   2
            Enabled         =   0   'False
            Object.Width           =   1058
            MinWidth        =   1058
            TextSave        =   "MAJ"
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   2
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   1058
            MinWidth        =   1058
            TextSave        =   "NUM"
         EndProperty
         BeginProperty Panel5 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   6
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   1402
            MinWidth        =   1411
            TextSave        =   "31/08/98"
         EndProperty
         BeginProperty Panel6 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Style           =   5
            Alignment       =   1
            AutoSize        =   2
            Object.Width           =   1402
            MinWidth        =   1411
            TextSave        =   "11:23"
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSComDlg.CommonDialog dlg 
      Left            =   120
      Top             =   600
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin RichTextLib.RichTextBox txt 
      Height          =   2895
      Left            =   720
      TabIndex        =   0
      Top             =   480
      Width           =   4935
      _ExtentX        =   8705
      _ExtentY        =   5106
      _Version        =   393217
      HideSelection   =   0   'False
      ScrollBars      =   3
      TextRTF         =   $"Editeur.frx":0000
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Arial"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin MSComctlLib.ImageList ImageList1 
      Left            =   0
      Top             =   1260
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   5
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Editeur.frx":00E0
            Key             =   "Bold"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Editeur.frx":01F2
            Key             =   "Italic"
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Editeur.frx":0304
            Key             =   "Left"
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Editeur.frx":0416
            Key             =   "Center"
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "Editeur.frx":0528
            Key             =   "Right"
         EndProperty
      EndProperty
   End
   Begin VB.Menu mnuFichier 
      Caption         =   "&Fichier"
      Begin VB.Menu mnuFichierNouveau 
         Caption         =   "&Nouveau"
      End
      Begin VB.Menu mnuFichierOuvrir 
         Caption         =   "&Ouvrir..."
         Shortcut        =   ^O
      End
      Begin VB.Menu sep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFichierEnr 
         Caption         =   "&Enregistrer"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFichierEnrsous 
         Caption         =   "En&registrer sous..."
      End
      Begin VB.Menu sep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFichierQuitter 
         Caption         =   "&Quitter"
      End
   End
   Begin VB.Menu mnuEdition 
      Caption         =   "&Edition"
      Begin VB.Menu mnuEditCouper 
         Caption         =   "&Couper"
         Shortcut        =   ^X
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'---- Initialisations
Private Sub Form_Load()
    ' Titre
    Tag = Caption
    MetTitre
    
    ' Remplit la liste des polices
    Dim i As Integer
    cmbPolice.ZOrder
    For i = 0 To Screen.FontCount - 1
        cmbPolice.AddItem Screen.Fonts(i)
    Next
    
    ' Pseudo-changement initial
    txt_SelChange
End Sub

'---- Changement de taille
Private Sub Form_Resize()
    ' Dplace le texte dans la fentre
    txt.Move 0, tb.Height, ScaleWidth, ScaleHeight - tb.Height - tat.Height
End Sub

'---- Menu Fichier
Private Sub mnuFichier_Click()
    mnuFichierEnr.Enabled = (txt.FileName <> "")
End Sub

'---- Fichier - Nouveau
Private Sub mnuFichierNouveau_Click()
    txt.TextRTF = ""
    txt.FileName = ""
    MetTitre
End Sub

'---- Fichier - Ouvrir
Private Sub mnuFichierOuvrir_Click()
    On Error Resume Next
    
    ' Flags de la bote de dialogue d'ouverture
    dlg.CancelError = True
    dlg.FileName = txt.FileName
    dlg.Filter = "Textes RTF|*.rtf|Textes ASCII|*.txt|Tous fichiers (*.*)|*.*"
    dlg.Flags = cdlOFNFileMustExist

    ' Gnre la bote de dialogue
    dlg.ShowOpen
    If Err Then Exit Sub
    
    ' Lit le fichier
    txt.LoadFile (dlg.FileName)
    If Err Then
        MsgBox "Erreur lors de la lecture du fichier " & dlg.FileName
        Exit Sub
    End If

    txt.FileName = dlg.FileName
    MetTitre
End Sub

'---- Fichier - Enregistrer
Private Sub mnuFichierEnr_Click()
    On Error Resume Next

    ' Vrifie nom OK
    If txt.FileName = "" Then DemandeNom
    
    ' Ecrit le fichier
    txt.SaveFile (txt.FileName)
    If Err Then MsgBox "Erreur lors de l'enregistrement du fichier " & dlg.FileName
End Sub

'---- Fichier - Enregistrer Sous
Private Sub mnuFichierEnrsous_Click()
    ' Enregistre
    If DemandeNom() Then
        mnuFichierEnr_Click
    End If
End Sub

'---- Fichier - Quitter
Private Sub mnuFichierQuitter_Click()
    End
End Sub

'---- Slection d'une police
Private Sub cmbPolice_Click()
    txt.SelFontName = cmbPolice.Text
    txt.SetFocus
End Sub

'---- Changement de la taille des caractres
Private Sub txtSize_LostFocus()
    ValideTaille
End Sub

'---- Entre sur texte taille
Private Sub txtSize_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyReturn Then ValideTaille
End Sub

'---- Validation de la taille
Private Sub ValideTaille()
    ' Vrifie la valeur
    Dim sz As Integer
    sz = Val(txtSize)
    If sz < 1 Then sz = 1
    If sz > 2000 Then sz = 2000
    txtSize = CStr(sz)
    ' Change la taille
    txt.SelFontSize = sz
    txt.SetFocus
End Sub

'---- Choix d'un nom de fichier
Private Function DemandeNom() As Boolean
    On Error Resume Next

    ' Flags de la bote de dialogue d'enregistrement
    dlg.CancelError = True
    dlg.FileName = txt.FileName
    dlg.Filter = "Textes RTF|*.rtf|Textes ASCII|*.txt|Tous fichiers (*.*)|*.*"
    dlg.Flags = cdlOFNCreatePrompt

    ' Gnre la bote de dialogue
    dlg.ShowSave
    If Err Then
        DemandeNom = False
        Exit Function
    End If

    ' Stocke le nom du fichier
    txt.FileName = dlg.FileName
    MetTitre
    DemandeNom = True
End Function

'---- Clic sur la barre d'outils
Private Sub tb_ButtonClick(ByVal Button As Button)
    ' Affiche la barre d'tat
    tat.Panels(1).Text = Button.Description
    Timer1.Enabled = False
    Timer1.Enabled = True
    
    ' Supprime l'ventuel tat incertain
    If Button.MixedState Then Button.MixedState = False
    
    ' Action selon le bouton
    Select Case Button.key
        Case "Bold"
            txt.SelBold = IIf(Button.Value = tbrPressed, True, False)
        Case "Italic"
            txt.SelItalic = IIf(Button.Value = tbrPressed, True, False)
        Case "Left"
            txt.SelAlignment = rtfLeft
        Case "Center"
            txt.SelAlignment = rtfCenter
        Case "Right"
            txt.SelAlignment = rtfRight
    End Select
    
    ' Rend le focus au texte
    txt.SetFocus
End Sub

'---- Timer pour la ligne d'tat
Private Sub timer1_Timer()
    ' Efface message
    tat.Panels(1).Text = ""
    Timer1.Enabled = False
End Sub

'---- Changement dans le texte
Private Sub txt_SelChange()
    ' Affiche position dans ligne d'tat
    tat.Panels(2).Text = "Li " & txt.GetLineFromChar(txt.SelStart + 1) + 1
    
    ' Nouvelle valeur
    Dim nVal As Integer
    
    ' Bouton gras
    Dim b As Button
    Set b = tb.Buttons("Bold")
    If IsNull(txt.SelBold) Then
        If Not b.MixedState Then b.MixedState = True
    Else
        If b.MixedState Then b.MixedState = False
        nVal = IIf(txt.SelBold, tbrPressed, tbrUnpressed)
        If b.Value <> nVal Then b.Value = nVal
    End If
    
    ' Bouton italique
    Set b = tb.Buttons("Italic")
    If IsNull(txt.SelItalic) Then
        If Not b.MixedState Then b.MixedState = True
    Else
        If b.MixedState Then b.MixedState = False
        nVal = IIf(txt.SelItalic, tbrPressed, tbrUnpressed)
        If b.Value <> nVal Then b.Value = nVal
    End If

    ' Boutons d'alignement
    Dim key As String
    Select Case txt.SelAlignment
        Case rtfLeft
            key = "Left"
        Case rtfCenter
            key = "Center"
        Case rtfRight
            key = "Right"
        Case Else
            key = ""
    End Select
    
    If key = "" Then
        If tb.Buttons("Left").Value <> tbrUnpressed Then tb.Buttons("Left").Value = tbrUnpressed
        If tb.Buttons("Right").Value <> tbrUnpressed Then tb.Buttons("Right").Value = tbrUnpressed
        If tb.Buttons("Center").Value <> tbrUnpressed Then tb.Buttons("Center").Value = tbrUnpressed
    Else
        If tb.Buttons(key).Value <> tbrPressed Then tb.Buttons(key).Value = tbrPressed
    End If
    
    ' Police de caractres
    On Error Resume Next    ' Si slection multiple
    cmbPolice.Text = txt.SelFontName
    If Err Then cmbPolice.Text = ""
    txtSize = CStr(txt.SelFontSize)
    If Err Then txtSize = ""
End Sub

'---- Change le titre
Sub MetTitre()
    Dim titre As String
    If txt.FileName <> "" Then titre = txt.FileName & " - "
    Caption = titre & Tag
End Sub
