VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsScreen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'---- Donnes publiques
' Jeu de caractres
Public Enum CharSetConstants
    G0
    G1
End Enum

' Codes effacement
Public Enum EraseConstants
    ToEndOfScreen
    ToEndOfLine
    FromBeginOfScreen
    FromBeginOfLine
    AllScreen
    CurrentLine
End Enum

'---- Donnes prives
' L'cran
Private mScreen() As Byte
Private mColumns As Integer
Private mLines As Integer
' Dimensions d'un caractre
Private cx As Integer, cy As Integer
' en pixels
Private cxPix As Integer, cyPix As Integer
' Le contrle d'affichage
Private mPct As PictureBox
' Position courante
Private mPos As Integer
' Dernire position
Private mLastPos As Integer
' Jeu de caractres
Private mCharSet As CharSetConstants
' Dernier caractre entr
Private mLastChar As Byte
' Indicateur d'inversion Vido
Private mInvert As Boolean
' Indicateur de double largeur
Private mDoubleWidth As Boolean
' Indicateur de double hauteur
Private mDoubleHeight As Boolean
' Couleur de fond
Private mBackColor As OLE_COLOR
' Indique si cursor on
Private mCursorOn As Boolean

'-----------------------------------------------------
' Proprits
'-----------------------------------------------------

'---- Proprit Columns
Public Property Get Columns() As Integer
    Columns = mColumns
End Property

'---- Proprit Lines
Public Property Get Lines() As Integer
    Lines = mLines
End Property

'---- Proprit CharSet
Public Property Let CharSet(New_CharSet As CharSetConstants)
    mCharSet = New_CharSet
    If mCharSet = G0 Then
        mPct.Font.Name = "Arial Alternative"
    Else
        mPct.Font.Name = "Arial Alternative Symbol"
    End If
End Property

Public Property Get CharSet() As CharSetConstants
    CharSet = mCharSet
End Property

'---- Proprit LastChar
Public Property Get LastChar() As Byte
    LastChar = mLastChar
End Property

'---- Proprit TextColor
Public Property Let TextColor(New_TextColor As OLE_COLOR)
    mPct.ForeColor = New_TextColor
End Property

Public Property Get TextColor() As OLE_COLOR
    TextColor = mPct.ForeColor
End Property

'---- Proprit BackColor
Public Property Let BackColor(New_BackColor As OLE_COLOR)
    mBackColor = New_BackColor
End Property

Public Property Get BackColor() As OLE_COLOR
    BackColor = mBackColor
End Property

'---- Proprit Underline
Public Property Let Underline(New_Underline As Boolean)
    mPct.Font.Underline = New_Underline
End Property

Public Property Get Underline() As Boolean
    Underline = mPct.Font.Underline
End Property

'---- Proprit Invert
Public Property Let Invert(New_Invert As Boolean)
    mInvert = New_Invert
End Property

Public Property Get Invert() As Boolean
    Invert = mInvert
End Property

'---- Proprit DoubleWidth
Public Property Let DoubleWidth(New_DoubleWidth As Boolean)
    mDoubleWidth = New_DoubleWidth
End Property

Public Property Get DoubleWidth() As Boolean
    DoubleWidth = mDoubleWidth
End Property

'---- Proprit DoubleHeight
Public Property Let DoubleHeight(New_DoubleHeight As Boolean)
    mDoubleHeight = New_DoubleHeight
End Property

Public Property Get DoubleHeight() As Boolean
    DoubleHeight = mDoubleHeight
End Property

'---- Proprit Cursor
Public Property Let Cursor(New_Cursor As Boolean)
    mCursorOn = New_Cursor
    SetCursor
End Property

Public Property Get Cursor() As Boolean
    Cursor = mCursorOn
End Property


'-----------------------------------------------------
' Mthodes
'-----------------------------------------------------

'---- Mthode Init
Public Sub Init(OutputControl As PictureBox, NewLines As Integer, NewColumns As Integer)
    ' Nouvelles valeurs
    mLines = NewLines
    mColumns = NewColumns
    Set mPct = OutputControl
    ' Dimensions des caractres
    cx = mPct.TextWidth("X")
    cy = mPct.TextHeight("X")
    cxPix = cx / Screen.TwipsPerPixelX
    cyPix = cy / Screen.TwipsPerPixelY
    
    ' Redimensionne l'cran
    ReDim mScreen(1 To Lines * Columns) As Byte
    
    ' Rinitialise les attributs
    ResetVideo
    mLastChar = &H20
    Cursor = False
    
    ' L'efface
    FF
End Sub

'---- Mthode AddChar
Public Sub AddChar(ByVal c As Byte)
    ' Stocke
    mScreen(mPos) = c
    
    ' Arrte le curseur
    Dim fCursor As Boolean
    fCursor = Cursor
    If fCursor Then
        Cursor = False
        SetCursor
    End If
    
    ' Inversion vido
    Dim txtColor As OLE_COLOR, bkColor As OLE_COLOR
    If mInvert Then
        ' Sauve les valeurs actuelles
        txtColor = mPct.ForeColor
        bkColor = mBackColor
        ' Nouvelles valeurs
        mPct.ForeColor = bkColor
        mBackColor = txtColor
    End If
    
    ' Affiche
    mPct.CurrentX = GetColumnFromPos(mPos) * cx
    mPct.CurrentY = GetLineFromPos(mPos) * cy
    PrintChar Chr(c)
    
    ' Position suivante
    If DoubleWidth Then
        mPos = mPos + 2
    Else
        mPos = mPos + 1
    End If
    If mPos > Lines * Columns Then mPos = 1
    
    ' Restaure inversion vido
    If mInvert Then
        ' Anciennes valeurs
        mPct.ForeColor = txtColor
        mBackColor = bkColor
    End If
    
    ' Positionne le curseur
    Cursor = fCursor
    SetCursor
    
    ' Mmorise dernier caractre
    mLastChar = c
End Sub

'---- Mthode BS - BackSpace
Public Sub BS()
    ' Recule
    If mPos > 1 Then mPos = mPos - 1 Else mPos = Lines * Columns
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode HT - Avance un caractre
Public Sub HT()
    ' Avance
    If mPos < Lines * Columns Then mPos = mPos + 1 Else mPos = 1
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode LF - Avance une ligne
Public Sub LF()
    ' Si range 0, retourne  la dernire position
    If GetLineFromPos(mPos) = 0 Then
        mPos = mLastPos
    Else
        ' Avance
        mPos = mPos + Columns
        If mPos > Lines * Columns Then mPos = mPos - Lines * Columns
    End If
    
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode VT - Recule d'une ligne
Public Sub VT()
    ' Recule
    mPos = mPos - Columns
    If mPos < 1 Then mPos = mPos + Lines * Columns
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode FF - Efface cran sauf ligne 0
Public Sub FF()
    ' Efface en mmoire et sur l'cran
    EraseScreen Columns + 1, Lines * Columns
    
    ' Position courante
    mPos = Columns + 1
    
    ' Rinitialise la vido
    ResetVideo
    
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode CR - Retour du curseur en dbut de ligne
Public Sub CR()
    mPos = mPos - ((mPos - 1) Mod mColumns)
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode RS - Retour du curseur  l'origine
Public Sub RS()
    mPos = 1
    ' Positionne le curseur
    SetCursor
End Sub

'---- Mthode SetPosition
Public Sub SetPosition(Line As Integer, Column As Integer)
    ' Mmorise la dernire position
    mLastPos = mPos
    ' Nouvelle position
    mPos = (Line - 1) * Columns + Column - 1
    
    ' Rinitialise la vido
    ResetVideo
End Sub

'---- Mthode EraseCharacters
Public Sub EraseCharacters(Action As EraseConstants)
    ' Dtermine les limites
    Dim PosBegin As Integer, PosEnd As Integer
    Select Case Action
        Case ToEndOfScreen
            PosBegin = mPos
            PosEnd = Lines * Columns
        
        Case ToEndOfLine
            PosBegin = mPos
            PosEnd = GetLineFromPos(mPos) * Columns
        
        Case FromBeginOfScreen
            PosBegin = 1
            PosEnd = mPos

        Case FromBeginOfLine
            PosBegin = (GetLineFromPos(mPos) - 1) * Columns + 1
            PosEnd = mPos
            
        Case AllScreen
            PosBegin = 1
            PosEnd = Lines * Columns
            
        Case CurrentLine
            PosBegin = (GetLineFromPos(mPos) - 1) * Columns + 1
            PosEnd = GetLineFromPos(mPos) * Columns
    End Select
    
    ' Effectue l'effacement
    EraseScreen PosBegin, PosEnd
End Sub

'-----------------------------------------------------
' Fonctions prives
'-----------------------------------------------------

'---- EraseScreen
Private Sub EraseScreen(ByVal PosBegin As Integer, ByVal PosEnd As Integer)
    ' Mmorise la position
    Dim x As Integer, y As Integer
    x = mPct.CurrentX
    y = mPct.CurrentY
    
    ' Effectue l'effacement
    Dim i As Integer
    For i = PosBegin To PosEnd
        ' En mmoire
        mScreen(i) = &H20
        
        ' Sur l'cran
        mPct.CurrentX = (GetColumnFromPos(i) - 1) * cx
        mPct.CurrentY = (GetLineFromPos(i) - 1) * cy
        PrintChar " "
    Next
    
    ' Restaure la position
    mPct.CurrentX = x
    mPct.CurrentY = y
    
    ' Remet le curseur
    SetCursor
End Sub

'---- PrintChar
Private Sub PrintChar(c As String)
    With mPct
        ' Position courante
        Dim x As Integer, y As Integer
        x = .CurrentX
        y = .CurrentY
        Dim w As Integer, h As Integer
        w = .TextWidth(c)
        h = .TextHeight(c)
        If DoubleWidth Then w = w * 2
        If DoubleHeight Then h = h * 2
        ' Fond
        mPct.Line (x, y)-(x + w, y + h), mBackColor, BF
        ' Repositionne
        .CurrentX = x
        .CurrentY = y
        ' Affiche caractre
        If CharSet = G0 Then
            mPct.Print c;
        Else
            mPct.Print G1Char(c);
        End If
        ' Si double largeur, avance
        If DoubleWidth Then .CurrentX = .CurrentX + w / 2
    End With
End Sub

'---- G1Char
Private Function G1Char(c As String) As String
    Dim v As Integer
    v = Asc(c)
    If v >= &H21 And v <= &H3F Then
        v = v + &H1F
    ElseIf v < &H5F Then
        v = &H20    ' Espace
    End If
    
    G1Char = Chr(v)
End Function

'---- ResetVideo
Private Sub ResetVideo()
    ' Repasse en G0
    CharSet = G0
    ' Initialise les autres attributs
    Invert = False
    TextColor = vbWhite
    BackColor = vbBlack
    Underline = False
    DoubleWidth = False
    DoubleHeight = False
End Sub

'---- SetCursor
Private Sub SetCursor()
    If mCursorOn Then
        ' Cre le caret
        CreateCaret mPct.hwnd, 0, cxPix, cyPix
        ' Positionne le caret
        SetCaretPos GetColumnFromPos(mPos) * cxPix, GetLineFromPos(mPos) * cyPix
        ' Rend visible
        ShowCaret mPct.hwnd
    Else
        HideCaret mPct.hwnd
    End If
End Sub

'---- GetLineFromPos
Private Function GetLineFromPos(Pos As Integer) As Integer
    GetLineFromPos = Int(((Pos - 1) / mColumns))
End Function

'---- GetColumnFromPos
Private Function GetColumnFromPos(Pos As Integer) As Integer
    GetColumnFromPos = ((Pos - 1) Mod mColumns)
End Function

'---- Finalisations
Private Sub Class_Terminate()
    Cursor = False
End Sub
