Attribute VB_Name = "WindowProc"
Option Explicit

'---- Stockage des rfrences aux objets appelants
Private mcol As New Collection

'---- Met en place le sous classement
Public Sub modSubClass(sc As SubClasser)
    ' Sous classe
    If Not GetPrevWindowProc(sc.hwnd) Then
        Dim lpPrevWindowProc As Long
        lpPrevWindowProc = SetWindowLong(sc.hwnd, GWL_WNDPROC, AddressOf WindowProc)
        StorePrevWindowProc sc.hwnd, lpPrevWindowProc
        ' Ajoute  la collection
        mcol.Add sc, Hex(sc.hwnd)
    End If
End Sub

'---- Retire le sous classement
Public Sub modReClass(sc As SubClasser)
    Dim lpPrevWindowProc As Long
    lpPrevWindowProc = GetPrevWindowProc(sc.hwnd)
    If lpPrevWindowProc Then
        SetWindowLong sc.hwnd, GWL_WNDPROC, lpPrevWindowProc
        ' Retire de la collection
        mcol.Remove Hex(sc.hwnd)
    End If
End Sub

'---- Appelle la procdure d'origine
Public Function modCallPrevWindowProc(ByVal hwnd As Long, ByVal uMsg As Long, _
        ByVal wParam As Long, ByVal lParam As Long) As Long
    modCallPrevWindowProc = CallWindowProc(GetPrevWindowProc(hwnd), hwnd, uMsg, wParam, lParam)
End Function

'---- Nouvelle procdure de fentre
Private Function WindowProc(ByVal hwnd As Long, ByVal uMsg As Long, _
        ByVal wParam As Long, ByVal lParam As Long) As Long
    ' Indique si appel  la procdure prcdente
    Dim fCall As Boolean: fCall = True

    ' Cherche l'objet associ
    Dim sc As SubClasser
    Set sc = mcol(Hex(hwnd))
    
    ' Gnre l'vnement
    WindowProc = sc.Message(hwnd, uMsg, wParam, lParam, fCall)
    
    ' Appellela procdure d'origine
    If fCall Then
        WindowProc = CallWindowProc(GetPrevWindowProc(hwnd), hwnd, uMsg, wParam, lParam)
    End If
End Function

'---- Retourne le mot bas d'un long
Private Function LOWORD(l As Long) As Integer
    LOWORD = l And &HFFFF&
End Function

'---- Retourne le mot haut d'un long
Private Function HIWORD(l As Long) As Integer
    HIWORD = CInt((l And &HFFFF0000) / 65536)
End Function

'---- Enregistre l'ancienne WindowProc d'une fentre
Private Sub StorePrevWindowProc(hwnd As Long, lpPrevWindowProc As Long)
    SetProp hwnd, "PrevWindowProc", lpPrevWindowProc
End Sub

'---- Retourne l'ancienne WindowProc d'une fentre
Private Function GetPrevWindowProc(hwnd As Long) As Long
    GetPrevWindowProc = GetProp(hwnd, "PrevWindowProc")
End Function

'---- Retire l'ancienne WindowProc d'une fentre
Private Sub RemovePrevWindowProc(hwnd As Long)
    RemoveProp hwnd, "PrevWindowProc"
End Sub
