VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Princ 
   Caption         =   "OLE"
   ClientHeight    =   4575
   ClientLeft      =   1110
   ClientTop       =   1770
   ClientWidth     =   6630
   ControlBox      =   0   'False
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   4575
   ScaleWidth      =   6630
   Begin VB.PictureBox tb 
      Align           =   1  'Align Top
      BackColor       =   &H00C0C0C0&
      Height          =   495
      Left            =   0
      Negotiate       =   -1  'True
      ScaleHeight     =   435
      ScaleWidth      =   6570
      TabIndex        =   1
      Top             =   0
      Width           =   6630
      Begin VB.CommandButton cmdFleche 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Wingdings"
            Size            =   14.25
            Charset         =   2
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   3
         Left            =   1560
         TabIndex        =   5
         Top             =   60
         Width           =   375
      End
      Begin VB.CommandButton cmdFleche 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Wingdings"
            Size            =   14.25
            Charset         =   2
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   2
         Left            =   1080
         TabIndex        =   4
         Top             =   60
         Width           =   375
      End
      Begin VB.CommandButton cmdFleche 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Wingdings"
            Size            =   14.25
            Charset         =   2
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   1
         Left            =   600
         TabIndex        =   3
         Top             =   60
         Width           =   375
      End
      Begin VB.CommandButton cmdFleche 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Wingdings"
            Size            =   14.25
            Charset         =   2
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   2
         Top             =   60
         Width           =   375
      End
   End
   Begin MSComDlg.CommonDialog Dlg 
      Left            =   240
      Top             =   840
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      FontSize        =   2,08358e-37
   End
   Begin VB.OLE Ole1 
      Height          =   915
      Index           =   0
      Left            =   2880
      OLEDropAllowed  =   -1  'True
      SizeMode        =   1  'Stretch
      TabIndex        =   0
      Top             =   1500
      Visible         =   0   'False
      Width           =   1575
   End
   Begin VB.Menu MnuFichier 
      Caption         =   "&Fichier"
      NegotiatePosition=   1  'Left
      Begin VB.Menu MnuNouveau 
         Caption         =   "&Nouveau"
      End
      Begin VB.Menu MnuOuvrir 
         Caption         =   "&Ouvrir..."
         Shortcut        =   ^O
      End
      Begin VB.Menu MnuSep1 
         Caption         =   "-"
      End
      Begin VB.Menu MnuEnr 
         Caption         =   "&Enregistrer"
         Shortcut        =   ^S
      End
      Begin VB.Menu MnuEnrSous 
         Caption         =   "En&registrer sous..."
         Shortcut        =   ^A
      End
      Begin VB.Menu MnuSep2 
         Caption         =   "-"
      End
      Begin VB.Menu MnuQuitter 
         Caption         =   "&Quitter"
      End
   End
   Begin VB.Menu MnuEdition 
      Caption         =   "&Edition"
      Begin VB.Menu MnuCouper 
         Caption         =   "&Couper"
         Shortcut        =   ^X
      End
      Begin VB.Menu MnuCopier 
         Caption         =   "Co&pier"
         Shortcut        =   ^C
      End
      Begin VB.Menu MnuColler 
         Caption         =   "C&oller"
         Shortcut        =   ^V
      End
      Begin VB.Menu MnuColSpec 
         Caption         =   "Collage &spcial"
      End
      Begin VB.Menu MnuEffacer 
         Caption         =   "&Effacer"
      End
      Begin VB.Menu MnuSep3 
         Caption         =   "-"
      End
      Begin VB.Menu MnuLiaisons 
         Caption         =   "&Liaisons..."
      End
      Begin VB.Menu MnuObj 
         Caption         =   "&Objet"
         Enabled         =   0   'False
      End
      Begin VB.Menu MnuObjMult 
         Caption         =   "&Objet"
         Visible         =   0   'False
         Begin VB.Menu MnuVerb 
            Caption         =   "Verb"
            Index           =   0
         End
      End
      Begin VB.Menu MnuInsObj 
         Caption         =   "&Insrer un objet..."
      End
   End
   Begin VB.Menu MnuObjet 
      Caption         =   "O&bjet"
      Begin VB.Menu MnuObjetTaille 
         Caption         =   "&Taille"
         Begin VB.Menu MnuSizeMode 
            Caption         =   "&Clipped"
            Index           =   0
         End
         Begin VB.Menu MnuSizeMode 
            Caption         =   "&Stretched"
            Index           =   1
         End
         Begin VB.Menu MnuSizeMode 
            Caption         =   "&Autosize"
            Index           =   2
         End
         Begin VB.Menu MnuSizeMode 
            Caption         =   "&Zoom"
            Index           =   3
         End
      End
   End
End
Attribute VB_Name = "Princ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'---- Variables globales
Public iCour As Integer         'Index du client en cours

Private iMax As Integer         'Indice max objets OLE
Private iNb As Integer          'Nombre d'objets
Private NomFic As String        'Nom du fichier
Private Modif As Integer        'Indicateur de modif

Private xDep As Integer         'Dpart d'un drag and drop
Private yDep As Integer

'---- Constantes
Const TITREBASE = "Conteneur OLE"

Private Enum ModeColle
    COLLE_NORMAL
    COLLE_SPEC
End Enum

Private Enum DirectionDplacement
    GAUCHE
    DROITE
    HAUT
    BAS
End Enum

'---- Initialisations
Private Sub Form_Load()
    'Se met en plein cran
    WindowState = vbMaximized
    
    'Initialise client OLE
    Ole1(0).HostName = TITREBASE

    'Aucun objet actif
    SetActive -1
End Sub

'---- Finalisation
Private Sub Form_Unload(Annuler As Integer)
    'Demande confirmation pour la fermeture
    Annuler = Not Nouveau()
End Sub

'---- Dessin
Private Sub Form_Paint()
    'Message d'aide
    CurrentX = 0
    CurrentY = 0
    Print "Bouton gauche pour dplacer un objet"
    Print "Double-clic pour l'activer"
End Sub

'---- Click souris
Private Sub Form_MouseDown(Bouton As Integer, Maj As Integer, X As Single, Y As Single)
    'Dsactive l'objet courant
    If iCour <> -1 Then
        Ole1(iCour).Close
        SetActive -1
    End If
End Sub

'---- Glisser-poser
Private Sub Form_DragDrop(Source As Control, X As Single, Y As Single)
    ' Dpt d'un objet Ole1 sur la feuille
    If TypeOf Source Is OLE Then
        Source.Move X - xDep, Y - yDep
    End If
End Sub

'---- Menu Fichier
Private Sub MnuFichier_Click()
    'Initialise le menu fichier
    MnuEnrSous.Enabled = True
        MnuEnr.Enabled = Not (NomFic = "")
End Sub

'---- Menu Fichier - Nouveau
Private Sub MnuNouveau_Click()
    'Nouveau fichier
    Nouveau
End Sub

'---- Menu Fichier - Ouvrir
Private Sub MnuOuvrir_Click()
Dim i As Integer
Dim X As Integer
Dim T As String

    ' Bote de dialogue d'ouverture de fichier
    With Dlg
        .FileName = NomFic
        .Filter = "Fichiers OLE (*.ole)|*.ole|Tous fichiers (*.*)|*.*"
        .FilterIndex = 1
        .CancelError = True
        .DefaultExt = "*.ole"
        .flags = cdlOFNHideReadOnly
                                  
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then Exit Sub
    
        ' Appelle nouveau
        If Not Nouveau() Then Exit Sub    'Annulation
    
        ' Lit le fichier
        NomFic = .FileName
        Screen.MousePointer = vbHourglass
    End With

    ' Ouvre
    On Error GoTo ErrFicOuvre
    Open NomFic For Binary Access Read As 1

    ' Signature et nombre d'lments
    T = Space$(3)
    Get #1, , T
    If Left$(T, 3) <> "Ole" Then Error 32767
    Get #1, , iNb

    ' Boucle de lecture des objets
    For i = 1 To iNb
        Load Ole1(i)
        With Ole1(i)
        Get #1, , X
        .Left = X
        Get #1, , X
        .Top = X
        Get #1, , X
        .Width = X
        Get #1, , X
        .Height = X
        Get #1, , X
        T = Space$(X)
        Get #1, , T
        .Visible = True
        .Tag = T
        .ReadFromFile 1
        End With
    Next
    
    iMax = iNb
    Modif = False
    Call MetTitre

FinOuvre:
    Close 1
    Screen.MousePointer = vbDefault
    Exit Sub

ErrFicOuvre:
    MsgBox Err.Description, 0 + 32, "Ouvrir le fichier"
    GoTo FinOuvre
End Sub

'---- Menu Fichier - Quitter
Private Sub MnuQuitter_Click()
    If Nouveau() Then Unload Princ
End Sub

'---- Menu Fichier - Enregistrer
Private Sub MnuEnr_Click()
    ' Enregistre
    If NomFic = "" Then
        Call MnuEnrSous_Click
    Else
        Call Enregistre
    End If
End Sub

'---- Menu Fichier - Enregistrer sous
Private Sub MnuEnrSous_Click()
    ' Bote de dialogue d'enregistrement de fichier
    With Dlg
    .FileName = NomFic
    .Filter = "Fichiers OLE (*.ole)|*.ole|Tous fichiers (*.*)|*.*"
    .FilterIndex = 1
    .CancelError = True
    .flags = cdlOFNHideReadOnly
                              
    On Error Resume Next
    .ShowSave
    If Err = cdlCancel Then Exit Sub    'Annuler
    On Error GoTo 0

'---- Vrifie si le fichier existe
    If Dir(.FileName) <> "" Then
        If MsgBox("Le fichier " + .FileName + " existe dj" + Chr(13) + "Voulez-vous le remplacer ?", 4 + 32, "Enregistrer le fichier") = 2 Then Exit Sub
    End If

'---- Enregistre
    NomFic = .FileName
    Call Enregistre
    Call MetTitre
    End With
End Sub

'---- Menu Edition
Private Sub MnuEdition_Click()
    'Il y a une slection
    If iCour <> -1 Then
        MnuEffacer.Enabled = True
        MnuCopier.Enabled = Ole1(iCour).AppIsRunning
        MnuCouper.Enabled = True
        If Ole1(iCour).OLEType = vbOLELinked Then
            MnuLiaisons.Enabled = True
        Else
            MnuLiaisons.Enabled = False
        End If
        
    'Pas de slection
    Else
        MnuEffacer.Enabled = False
        MnuCopier.Enabled = False
        MnuCouper.Enabled = False
        MnuLiaisons.Enabled = False
    End If

    With Ole1(0)
        .OLETypeAllowed = vbOLEEither
        MnuColler.Enabled = .PasteOK
        MnuColSpec.Enabled = .PasteOK
    End With
End Sub

'---- Menu Edition - Coller
Private Sub MnuColler_Click()
    Colle COLLE_NORMAL
End Sub

'---- Menu Edition - Collage spcial
Private Sub MnuColSpec_Click()
    Colle COLLE_SPEC
End Sub

'---- Menu Edition - Copier
Private Sub MnuCopier_Click()
    'Le contrle peut le faire tout seul
    Ole1(iCour).Copy
End Sub

'---- Menu Edition - Couper
Private Sub MnuCouper_Click()
    'Couper = Copier...
    MnuCopier_Click
    '... + Effacer
    MnuEffacer_Click
End Sub

'---- Menu Edition - Effacer
Private Sub MnuEffacer_Click()
    'Ne devrait pas arriver, car menu gris
    If iCour = -1 Then Exit Sub
    'Supprime le contrle
    Unload Ole1(iCour)
    iNb = iNb - 1
    Modif = True
    SetActive -1
    Refresh
End Sub

'---- Mise  jour menu Edition - objet
Private Sub InitMnuEdition()
Static nbVerbsMax As Integer
Dim i As Integer
Dim nb As Integer

    ' Supprime les ventuels verbes prsents
    If nbVerbsMax >= 1 Then
        For i = 1 To nbVerbsMax
            Unload MnuVerb(i)
        Next
        nbVerbsMax = 0
    End If

    ' Pas d'objet slectionn
    If iCour = -1 Then
        MnuObjMult.Visible = False
        With MnuObj
        .Visible = True
        .Caption = "&Objet"
        .Enabled = False
        End With

    ' Objet slectionn
    Else    'Le premier verbe est le verbe par dfaut, les autres sont affichs dans le menu
        With Ole1(iCour)
        nb = .ObjectVerbsCount - 1
        If nb = 1 Then
            MnuObj.Visible = True
            MnuObjMult.Visible = False
            MnuObj.Caption = "&Objet" + " " + .Tag + " " + .ObjectVerbs(0)
            MnuObj.Enabled = True
            FlagsMenuVerb MnuObj, (.ObjectVerbFlags(1))
        Else
            For i = 0 To nb - 1
                MnuObj.Visible = False
                MnuObjMult.Visible = True
                MnuObjMult.Caption = "&Objet" + " " + .Tag
                If i > 0 Then Load MnuVerb(i)
                MnuVerb(i).Caption = .ObjectVerbs(i + 1)
                MnuVerb(i).Visible = True
                MnuVerb(i).Enabled = True
                FlagsMenuVerb MnuVerb(i), (.ObjectVerbFlags(i + 1))
            Next
            nbVerbsMax = i - 1
        End If
        End With
    End If
End Sub

'---- Met le titre dans la feuille
Private Sub MetTitre()
Dim Titre As String

    'Nom du fichier
    If NomFic <> "" Then
        Titre = NomFic
    Else
        Titre = "(Sans titre)"
    End If

    'Ajoute indicateur de modification
    If Modif Then
        Titre = Titre & "*"
    End If
    
    'Ajoute le nom de l'objet
    If iCour <> -1 Then
        Titre = Titre & " - " & Ole1(iCour).Tag
    End If

    'Ajoute le titre de l'application
    Titre = Titre & " - " & TITREBASE

    Princ.Caption = Titre
End Sub

'---- Menu Edition - Insrer un objet
Private Sub MnuInsObj_Click()
    ' Cre nouveau contrle
    Modif = True
    iMax = iMax + 1
    iNb = iNb + 1
    Load Ole1(iMax)

    ' Appelle la bote de dialogue
    With Ole1(iMax)
        .InsertObjDlg
        
        ' Objet cr
        If .OLEType <> vbOLENone Then
            .Tag = .Class
            
            .Visible = True
            SetActive iMax
            'Action par dfaut
            .DoVerb (vbOLEPrimary)
    
        ' Annulation
        Else
            Unload Ole1(iMax)
            iMax = iMax - 1
            iNb = iNb - 1
            Refresh
        End If
    End With
End Sub

'---- Menu Edition - Liaisons
Private Sub MnuLiaisons_Click()
    Liaisons.Show vbModal
End Sub

'---- Menu Edition - Objet
Private Sub MnuObj_Click()
    FaitVerb iCour, 0
End Sub

'---- Menu Objet
Private Sub MnuObjet_Click()
Dim i
Dim mnu As Menu

    If iCour <> -1 Then
        For Each mnu In MnuSizeMode
            mnu.Enabled = True
            mnu.Checked = False
        Next
        MnuSizeMode(Ole1(iCour).SizeMode).Checked = True
    Else
        For Each mnu In MnuSizeMode
            mnu.Enabled = False
            mnu.Checked = False
        Next
    End If
End Sub

'---- Menu Edition - verbe
Private Sub MnuVerb_Click(Index As Integer)
    FaitVerb iCour, Index
End Sub

'---- Menu Objet - Taille
Private Sub MnuSizeMode_Click(Index As Integer)
    If iCour <> -1 Then
        Ole1(iCour).SizeMode = Index
    End If
End Sub

'---- Nouveau fichier
Private Function Nouveau() As Integer
Dim i As Integer
    
    ' Demande confirmation pour enregistrement
    If Modif Then
        Select Case MsgBox("Le fichier est modifi" + Chr$(13) + "Voulez-vous l'enregistrer ?", vbYesNoCancel + vbQuestion, "Nouveau fichier")
            Case vbYes
                MnuEnr_Click
    
            Case vbCancel
                Nouveau = False
                Exit Function
        End Select
    End If

    ' Dcharge les contrles
    For i = 1 To iMax
        On Error Resume Next
        Unload Ole1(i)
    Next

    ' Rinitialise les variables
    iNb = 0
    iMax = 0
    Modif = False
    NomFic = ""
    SetActive -1
    Nouveau = True
End Function

'---- Colle un objet
Private Sub Colle(ObjectType As Integer)
Dim i As Integer

    Screen.MousePointer = vbHourglass

    ' Cre nouveau contrle
    Modif = True
    iMax = iMax + 1
    iNb = iNb + 1
    Load Ole1(iMax)
    Ole1(iMax).Visible = True

    ' Active
    SetActive iMax

    ' Paste, selon l'option du menu
    Ole1(iMax).OLETypeAllowed = vbOLEEither
    Select Case ObjectType
        ' Collage normal
        Case COLLE_NORMAL
            Ole1(iMax).Paste
    
        ' Collage spcial
        Case COLLE_SPEC
            Ole1(iMax).PasteSpecialDlg
    End Select

    ' Vrifie que a s'est bien pass
    If Ole1(iMax).OLEType = vbOLENone Then
        Unload Ole1(iMax)
        iMax = iMax - 1
        iNb = iNb - 1
        SetActive -1
        Refresh
    Else
        SetActive iMax      'Remet le titre
    End If

    Screen.MousePointer = vbDefault
End Sub

'---- Enregistre
Private Sub Enregistre()
Dim i As Integer
Dim X As Integer
Dim T As String
Dim Txt As String

    Screen.MousePointer = vbHourglass

    ' Ouvre en crasant version prcdente
    On Error Resume Next
    Kill NomFic
    On Error GoTo ErrFicEnr
    Open NomFic For Binary Access Write As 1

    ' Signature et nombre d'lments
    T = "Ole"
    Put #1, , T
    Put #1, , iNb

    ' Boucle d'criture des objets
    For i = 1 To iMax
        On Error Resume Next    'Protection contre contrles supprims
        If Err = 0 Then
            On Error GoTo ErrFicEnr
            X = Ole1(i).Left
            Put #1, , X
            X = Ole1(i).Top
            Put #1, , X
            X = Ole1(i).Width
            Put #1, , X
            X = Ole1(i).Height
            Put #1, , X
            Txt = Ole1(i).Tag
            X = Len(Txt)
            Put #1, , X
            Put #1, , Txt
            Ole1(i).SaveToFile 1
        End If
    Next
    
    Modif = False

FinEnr:
    Close 1
    Screen.MousePointer = vbDefault
    Exit Sub

ErrFicEnr:
    MsgBox "Erreur d'criture du fichier " & NomFic, 0 + 32, "Enregistrer le fichier"
    GoTo FinEnr
End Sub

'---- FaitVerb
Private Sub FaitVerb(Index As Integer, iVerb As Integer)
    Ole1(Index).DoVerb (iVerb + 1)
End Sub

'---- FlagsMenuVerb
Private Sub FlagsMenuVerb(mnu As Menu, flags As Long)
    mnu.Checked = IIf(flags And vbOLEFlagChecked <> 0, True, False)
    mnu.Enabled = IIf((flags And (vbOLEFlagDisabled Or vbOLEFlagGrayed)) <> 0, False, True)
End Sub

'---- Clic sur une flche
Private Sub cmdFleche_Click(Index As Integer)
    ' Calcule les pas de dplacement
    Dim dx As Integer, dy As Integer
    dx = Screen.TwipsPerPixelX
    dy = Screen.TwipsPerPixelY
    
    ' Modifie la taille de l'objet courant
    If iCour <> -1 Then
        With Ole1(iCour)
        Select Case Index
            Case GAUCHE
                .Width = .Width - dx
            Case DROITE
                .Width = .Width + dx
            Case HAUT
                .Height = .Height - dy
            Case BAS
                .Height = .Height + dy
        End Select
        End With
    End If
End Sub

'---- Glisser-poser sur le contrle OLE
Private Sub Ole1_DragDrop(Index As Integer, Source As Control, X As Single, Y As Single)
    'Drop sur contrle Ole, transmet  la feuille
    Form_DragDrop Source, X + Ole1(Index).Left, Y + Ole1(Index).Top
End Sub

'---- KeyDown sur OLE
Private Sub Ole1_KeyDown(Index As Integer, CodeTouche As Integer, Maj As Integer)
    'Suppression du contrle
    If CodeTouche = vbKeyDelete Then
        If iCour <> -1 Then MnuEffacer_Click
    End If
End Sub

'---- Clic souris sur OLE
Private Sub Ole1_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    'Rend actif
    SetActive Index
    
    'Initialise un dplacement si bouton gauche
    If Button And vbLeftButton Then
        xDep = X
        yDep = Y
        Ole1(Index).Drag vbBeginDrag
    End If
End Sub

'---- Mise  jour OLE
Private Sub Ole1_Updated(Index As Integer, Code As Integer)
    'L'objet a t mis  jour
    Modif = True
End Sub

'---- Dplacement contrle OLE
Private Sub Ole1_ObjectMove(Index As Integer, Left As Single, Top As Single, Width As Single, Height As Single)
    'Dplacement de l'objet, dplace le conteneur
    Ole1(Index).Move Left, Top, Width, Height
End Sub

'---- SetActive
Private Sub SetActive(Index As Integer)
Dim hwndCli As Integer

    iCour = Index
    If iCour <> -1 Then
        Ole1(iCour).ZOrder
    End If
    Call MetTitre
    'Initialise verbes
    On Error Resume Next
    InitMnuEdition
End Sub
