Attribute VB_Name = "modMain"
Option Explicit

' Enumration des fentres du thread
Declare Function EnumThreadWindows Lib "user32" (ByVal dwThreadId As Long, ByVal lpfn As Long, ByVal lParam As Long) As Long
' Code de retour
Public Const ENUM_STOP = 0
Public Const ENUM_CONTINUE = 1
' Recherche d'une fentre
Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
' Recherche du ProcessID d'une fentre
Declare Function GetWindowThreadProcessId Lib "user32" (ByVal hwnd As Long, lpdwProcessId As Long) As Long

' Fentre cache pour l'identification du thread courant
Private mfrmProcess As New frmProcess
' Handle de fentre obtenu par EnumThreadWindows.
Private mhwndVB As Long

' Numros d'erreur
Public Const Err_InternalStartup = &H600
Public Const Err_NoAutomation = &H601

'---- Point d'entre
Sub Main()
    ' Recherche le handle de la fentre frmProcess
    ' La fonction EnumThreadWindowsProc est appele pendant l'excution
    ' de la ligne suivante
    EnumThreadWindows App.ThreadID, AddressOf EnumThreadWindowsProc, 0&
    
    ' Pas de fentre trouve, erreur
    If mhwndVB = 0 Then
        Err.Raise Err_InternalStartup + vbObjectError, , "Erreur interne au dmarrage du thread"
    
    ' Fentre trouve
    Else
        ' Recherche le ProcessId
        Dim mProcessID As Long
        GetWindowThreadProcessId mhwndVB, mProcessID
        ' Construit un titre unique
        Dim txtCaption As String
        txtCaption = "MultiThread" & CStr(mProcessID)
        ' Recherche la fentre
        If FindWindow(vbNullString, txtCaption) = 0 Then
            ' Fentre non trouve, on est dans le premier thread
            If App.StartMode = vbSModeStandalone Then
                ' L'application a t dmarre en autonome
                ' Met le titre
                mfrmProcess.Caption = txtCaption
                ' Cre un objet de classe MainApp, qui cre la fentre principale
                Dim ma As CMainApp
                Set ma = New CMainApp
            Else
                ' Application dmarre par automation
                Err.Raise Err_NoAutomation + vbObjectError, , "L'application ne peut dmarrer avec Automation"
            End If
        End If
    End If
End Sub

'---- Fonction Callback appele par EnumThreadWindows
Public Function EnumThreadWindowsProc(ByVal hwnd As Long, ByVal lParam As Long) As Long
   ' Stocke le handle de fentre
   mhwndVB = hwnd
   ' On arrte (la premire fentre est la bonne)
   EnumThreadWindowsProc = ENUM_STOP
End Function

'---- Fonction appele par MainApp dans l'vnement Terminate
Public Sub FreeProcessWindow()
   Unload mfrmProcess
   Set mfrmProcess = Nothing
End Sub
