Attribute VB_Name = "modHook"
Option Explicit

' Handle du hook
Private hHook As Long
' Collection des vnements
Private colMsg As Collection
' Index courant du message en playback
Private iMsg As Integer
' Heure de dmarrage de l'enregistrement et du playback
Private hDebRec As Long, hDebPlay As Long
' Heure de l'vnement prcdent en Playback
Private hPrev As Long

' Etat
Public Enum ETAT
    Stopped
    record
    playback
End Enum

Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Declare Function GetCurrentThreadId Lib "kernel32" () As Long
Declare Function GetLastError Lib "kernel32" () As Long
Declare Function GetModuleHandle Lib "kernel32" Alias "GetModuleHandleA" (ByVal lpModuleName As String) As Long
Declare Function GetTickCount Lib "kernel32" () As Long

' Message Structure used in Journaling
Type EVENTMSG
        Message As Long
        paramL As Long
        paramH As Long
        time As Long
        hwnd As Long
End Type
' SetWindowsHook() codes
Public Const WH_MIN = (-1)
Public Const WH_MSGFILTER = (-1)
Public Const WH_JOURNALRECORD = 0
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_KEYBOARD = 2
Public Const WH_GETMESSAGE = 3
Public Const WH_CALLWNDPROC = 4
Public Const WH_CBT = 5
Public Const WH_SYSMSGFILTER = 6
Public Const WH_MOUSE = 7
Public Const WH_HARDWARE = 8
Public Const WH_DEBUG = 9
Public Const WH_SHELL = 10
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_MAX = 11
' Hook Codes
Public Const HC_ACTION = 0
Public Const HC_GETNEXT = 1
Public Const HC_SKIP = 2
Public Const HC_NOREMOVE = 3
Public Const HC_NOREM = HC_NOREMOVE
Public Const HC_SYSMODALON = 4
Public Const HC_SYSMODALOFF = 5

' Clavier
Public Const VK_CANCEL = &H3
Public Const WM_KEYDOWN = &H100
Public Const WM_KEYUP = &H101

'---- Met le hook Record
Public Sub SetRecordHook()
    frmMain.AfficheEtat record
    ' Supprime ventuellement la collection
    VideCol
    ' Nouvelle collection
    Set colMsg = New Collection
    ' Heure de dmarrage
    hDebRec = GetTickCount()
    ' Met le hook
    hHook = SetWindowsHookEx(WH_JOURNALRECORD, AddressOf JournalRecordProc, 0&, 0&) 'GetModuleHandle(vbNullString), GetCurrentThreadId())
End Sub

'---- Met le hook Playback
Public Sub SetPlaybackHook()
    frmMain.AfficheEtat playback
    iMsg = 1
    ' Diffrence de temps
    hDebPlay = GetTickCount()
    hPrev = 0
    ' Met le hook
    hHook = SetWindowsHookEx(WH_JOURNALPLAYBACK, AddressOf JournalPlaybackProc, 0&, 0&) 'GetModuleHandle(vbNullString), GetCurrentThreadId())
End Sub

'---- Retire le hook
Public Sub RemoveHook()
    frmMain.AfficheEtat Stopped
    UnhookWindowsHookEx hHook
End Sub

'---- Finalisation
Private Sub Class_Terminate()
    VideCol
End Sub

'---- Vide la collection de messages
Public Sub VideCol()
    If Not colMsg Is Nothing Then
        Do While colMsg.Count > 0
            colMsg.Remove 1
        Loop
        Set colMsg = Nothing
    End If
End Sub

'---- JournalRecordProc
Public Function JournalRecordProc(ByVal code As Long, ByVal wParam As Long, msg As EVENTMSG) As Long
    Select Case code
        ' Evnement
        Case HC_ACTION
            If msg.Message = WM_KEYDOWN And (msg.paramL And &HFF&) = VK_CANCEL Then
                ' Supprime le hook
                RemoveHook
            Else
                ' Cre le message
                Dim m As Message
                Set m = New Message
                ' Copie les donnes
                m.hwnd = msg.hwnd
                m.Message = msg.Message
                m.paramH = msg.paramH
                m.paramL = msg.paramL
                ' Heure coule depuis dbut d'enregistrement
                m.time = msg.time - hDebRec
                ' Ajoute  la collection
                colMsg.Add m
            End If
    End Select
    
    ' Passe le hook au suivant
    JournalRecordProc = CallNextHookEx(hHook, code, wParam, msg)
End Function

'---- JournalPlaybackProc
Public Function JournalPlaybackProc(ByVal code As Long, ByVal wParam As Long, msg As EVENTMSG) As Long
    Select Case code
        ' Prochain message
        Case HC_GETNEXT
            ' Met le prochain message dans la structure
            ' Rcupre le message
            Dim m As Message
            Set m = colMsg(iMsg)
            ' Copie les donnes
            msg.hwnd = m.hwnd
            msg.Message = m.Message
            msg.paramH = m.paramH
            msg.paramL = m.paramL
            ' Intervale  attendre
            Dim hInt As Long
            hInt = m.time - hPrev
            ' Heure du message prcdent (pour le prochain)
            hPrev = m.time
            ' Heure de ce message
            msg.time = GetTickCount() + hInt
             ' Prpare le suivant
            If iMsg = colMsg.Count Then
                ' Arrte le hook
                RemoveHook
            Else
                iMsg = iMsg + 1
            End If
            ' Valeur de retour
            JournalPlaybackProc = hInt
            Exit Function
        
        ' Skip
        Case HC_SKIP
            If iMsg = colMsg.Count Then
                ' Arrte le hook
                RemoveHook
            End If
    End Select
    
    ' Passe le hook au suivant
    JournalPlaybackProc = CallNextHookEx(hHook, code, wParam, msg)
End Function
