VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Connect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Description = "Copie du format"
Option Explicit

' Implmente le modle d'extensibilit
Implements IDTExtensibility

' Instance courante
Public VBInstance As VBIDE.VBE
' Traitement des vnements des boutons
Public WithEvents CopyFormat As CommandBarEvents
Attribute CopyFormat.VB_VarHelpID = -1
' Evnements des contrles slectionns
Public WithEvents SelCtlHandler As SelectedVBControlsEvents
Attribute SelCtlHandler.VB_VarHelpID = -1

' Boutons pour le complment dans la barre d'outils
Private mcbCtrlCopyFormat As Office.CommandBarControl
' Contrle dont on copie le format
Private ctlSource As VBControl

'---- Ajoute le complment
Private Sub IDTExtensibility_OnConnection(ByVal VBInst As Object, ByVal ConnectMode As vbext_ConnectMode, ByVal AddInInst As VBIDE.AddIn, custom() As Variant)
    
    On Error GoTo OnConnectionErr
    
    ' Sauve l'instance courante
    Set VBInstance = VBInst

    ' Ajoute "Copier" dans la barre d'outils
    Set mcbCtrlCopyFormat = AjouteBarreOutils("Standard", 100, 1000)
    If mcbCtrlCopyFormat Is Nothing Then GoTo OnConnectionErrButton
    ' Indique le gestionnaire d'vnements
    Set Me.CopyFormat = VBInst.Events.CommandBarEvents(mcbCtrlCopyFormat)

    ' Traitement des vnements des contrles
    Set Me.SelCtlHandler = VBInst.Events.SelectedVBControlsEvents(Nothing, Nothing)

    Exit Sub

' Erreur
OnConnectionErr:
    MsgBox Err.Description
    Exit Sub

' Ne peut ajouter un bouton
OnConnectionErrButton:
    MsgBox "Ne peut crer un bouton dans la barre d'outils"
    Exit Sub
End Sub

'---- Retire le complment
Private Sub IDTExtensibility_OnDisconnection(ByVal RemoveMode As vbext_DisconnectMode, custom() As Variant)
    On Error Resume Next
    
    ' Supprime les boutons de la barre d'outils
    mcbCtrlCopyFormat.Delete
End Sub

Private Sub IDTExtensibility_OnStartupComplete(custom() As Variant)
'
End Sub

Private Sub IDTExtensibility_OnAddInsUpdate(custom() As Variant)
'
End Sub

'---- Ajoute un bouton dans une barre
Function AjouteBarreOutils(sBar As String, idCaption As Integer, idBitmap As Integer) As Office.CommandBarControl
    On Error GoTo AjouteBarreOutilsErr
    
    ' Cherche la barre standard
    Dim cb As CommandBar
    Set cb = VBInstance.CommandBars(sBar)
    If cb Is Nothing Then
        ' Pas trouv
        Set AjouteBarreOutils = Nothing
        Exit Function
    End If
    ' Rend visible
    cb.Visible = True
    
    ' Ajoute le bouton
    Dim ctrl As Office.CommandBarButton
    Set ctrl = cb.Controls.Add(msoControlButton, , , cb.Controls.Count)
    ' Modifie le texte
    ctrl.Caption = LoadResString(idCaption)
    ' et l'icne
    Clipboard.SetData LoadResPicture(idBitmap, vbResBitmap)
    ctrl.PasteFace
    
    ' Termine
    Set AjouteBarreOutils = ctrl
    Exit Function

' Erreur
AjouteBarreOutilsErr:
    Set AjouteBarreOutils = Nothing
End Function

'---- Clic sur CopyFormat
Private Sub CopyFormat_Click(ByVal CommandBarControl As Object, handled As Boolean, CancelDefault As Boolean)
    ' Si bouton enfonc, termine le mode copie
    If CommandBarControl.State = msoButtonDown Then
        ' Termine le mode copie format
        CommandBarControl.State = msoButtonUp
        Set ctlSource = Nothing
    
    ' Si bouton sorti, initialise le mode copie, si slection
    Else
        With VBInstance.SelectedVBComponent
            ' Regarde si la slection est un contrle
            If .Type = vbext_ct_VBForm Or _
                    .Type = vbext_ct_DocObject Or _
                    .Type = vbext_ct_MSForm Or _
                    .Type = vbext_ct_PropPage Then
                ' N'admet qu'un contrle slectionn
                If .Designer.SelectedVBControls.Count = 1 Then
                    ' Mmorise le contrle source
                    Set ctlSource = .Designer.SelectedVBControls(0)
                    ' Enfonce le bouton
                    CommandBarControl.State = msoButtonDown
                End If
            End If
            
            ' Beep si erreur
            If ctlSource Is Nothing Then Beep
        End With
    End If
End Sub

'---- Ajout d'un contrle dans la slection
Private Sub SelCtlHandler_ItemAdded(ByVal VBControl As VBIDE.VBControl)
    ' Si en cours de copie, copie les proprits
    If Not ctlSource Is Nothing Then
        ' Une erreur peut arriver si la proprit n'est pas supporte
        On Error Resume Next
        VBControl.Properties("Appearance") = ctlSource.Properties("Appearance")
        VBControl.Properties("BackColor") = ctlSource.Properties("BackColor")
        VBControl.Properties("ForeColor") = ctlSource.Properties("ForeColor")
        VBControl.Properties("BorderStyle") = ctlSource.Properties("BorderStyle")
        VBControl.ControlObject.Font.Name = ctlSource.ControlObject.Font.Name
        VBControl.ControlObject.Font.Bold = ctlSource.ControlObject.Font.Bold
        VBControl.ControlObject.Font.Italic = ctlSource.ControlObject.Font.Italic
        VBControl.ControlObject.Font.Size = ctlSource.ControlObject.Font.Size
        VBControl.ControlObject.Font.Strikethrough = ctlSource.ControlObject.Font.Strikethrough
        VBControl.ControlObject.Font.Underline = ctlSource.ControlObject.Font.Underline
        VBControl.ControlObject.Font.Weight = ctlSource.ControlObject.Font.Weight
        VBControl.ControlObject.Font.Charset = ctlSource.ControlObject.Font.Charset
    End If
End Sub
