VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmMain 
   Caption         =   "Minitel"
   ClientHeight    =   5250
   ClientLeft      =   8100
   ClientTop       =   3195
   ClientWidth     =   6780
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   5250
   ScaleWidth      =   6780
   StartUpPosition =   2  'CenterScreen
   Begin VB.PictureBox pctStatus 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      ScaleHeight     =   315
      ScaleWidth      =   6720
      TabIndex        =   11
      Top             =   4875
      Width           =   6780
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "RTS"
         ForeColor       =   &H00FF0000&
         Height          =   195
         Index           =   4
         Left            =   2880
         TabIndex        =   16
         Top             =   60
         Width           =   330
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "DTR"
         ForeColor       =   &H00FF0000&
         Height          =   195
         Index           =   3
         Left            =   2160
         TabIndex        =   15
         Top             =   60
         Width           =   345
      End
      Begin VB.Shape shpLed 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00FFFFFF&
         FillStyle       =   0  'Solid
         Height          =   195
         Index           =   4
         Left            =   3240
         Shape           =   3  'Circle
         Top             =   60
         Width           =   255
      End
      Begin VB.Shape shpLed 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00FFFFFF&
         FillStyle       =   0  'Solid
         Height          =   195
         Index           =   3
         Left            =   2520
         Shape           =   3  'Circle
         Top             =   60
         Width           =   255
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "DSR"
         ForeColor       =   &H00FF0000&
         Height          =   195
         Index           =   2
         Left            =   1440
         TabIndex        =   14
         Top             =   60
         Width           =   345
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "CTS"
         ForeColor       =   &H00FF0000&
         Height          =   195
         Index           =   1
         Left            =   720
         TabIndex        =   13
         Top             =   60
         Width           =   315
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "CD"
         ForeColor       =   &H00FF0000&
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   12
         Top             =   60
         Width           =   225
      End
      Begin VB.Shape shpLed 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00FFFFFF&
         FillStyle       =   0  'Solid
         Height          =   195
         Index           =   2
         Left            =   1800
         Shape           =   3  'Circle
         Top             =   60
         Width           =   255
      End
      Begin VB.Shape shpLed 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00FFFFFF&
         FillStyle       =   0  'Solid
         Height          =   195
         Index           =   1
         Left            =   1080
         Shape           =   3  'Circle
         Top             =   60
         Width           =   255
      End
      Begin VB.Shape shpLed 
         BorderStyle     =   0  'Transparent
         FillColor       =   &H00FFFFFF&
         FillStyle       =   0  'Solid
         Height          =   195
         Index           =   0
         Left            =   360
         Shape           =   3  'Circle
         Top             =   60
         Width           =   255
      End
   End
   Begin VB.PictureBox pctCommandes 
      Enabled         =   0   'False
      Height          =   4095
      Left            =   240
      ScaleHeight     =   4035
      ScaleWidth      =   1395
      TabIndex        =   1
      Top             =   120
      Width           =   1455
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Envoi"
         Default         =   -1  'True
         Height          =   375
         Index           =   8
         Left            =   120
         TabIndex        =   10
         Top             =   3420
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Suite"
         Height          =   375
         Index           =   7
         Left            =   120
         TabIndex        =   9
         Top             =   3000
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Retour"
         Height          =   375
         Index           =   6
         Left            =   120
         TabIndex        =   8
         Top             =   2580
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Correction"
         Height          =   375
         Index           =   5
         Left            =   120
         TabIndex        =   7
         Top             =   2160
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Annulation"
         Height          =   375
         Index           =   4
         Left            =   120
         TabIndex        =   6
         Top             =   1740
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Sommaire"
         Height          =   375
         Index           =   3
         Left            =   120
         TabIndex        =   5
         Top             =   1320
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Guide"
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   4
         Top             =   900
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Rptition"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   3
         Top             =   480
         Width           =   1215
      End
      Begin VB.CommandButton cmdCommandes 
         Caption         =   "Connexion"
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   2
         Top             =   60
         Width           =   1215
      End
   End
   Begin VB.Timer tim 
      Interval        =   1
      Left            =   960
      Top             =   4380
   End
   Begin VB.PictureBox pctScreen 
      BackColor       =   &H00000000&
      BeginProperty Font 
         Name            =   "Arial Alternative"
         Size            =   8.25
         Charset         =   2
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   3855
      Left            =   2040
      ScaleHeight     =   3795
      ScaleWidth      =   4635
      TabIndex        =   0
      Top             =   120
      Width           =   4695
   End
   Begin MSCommLib.MSComm com 
      Left            =   120
      Top             =   4380
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
   End
   Begin VB.Menu mnuConnect 
      Caption         =   "&Connexion"
      Begin VB.Menu mnuCall 
         Caption         =   "&Appeler..."
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuDisconnect 
         Caption         =   "&Dconnecter"
         Shortcut        =   ^D
      End
      Begin VB.Menu mnuSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuPort 
         Caption         =   "&Port de communications..."
      End
   End
   Begin VB.Menu mnuScreen 
      Caption         =   "&Ecrans"
      Begin VB.Menu mnuRecord 
         Caption         =   "&Enregistrer"
         Shortcut        =   ^E
      End
      Begin VB.Menu mnuPlay 
         Caption         =   "&Jouer"
         Shortcut        =   ^J
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' L'cran
Private Scr As clsScreen

' Port de communications
Private ComPort As Integer

' Indicateur d'enregistrement
Private fEnr As Boolean
' Indicateur de jeu
Private fPlay As Boolean

' Indique tat porteuse
Private CDHolding As Boolean

' Les touches de fonction
Private Enum FunctionKeyConstants
    FKConnexion = 0
    FKRepetition
    FKGuide
    FKSommaire
    FKAnnulation
    FKCorrection
    FKRetour
    FKSuite
    FKEnvoi
End Enum

'---- Bouton de commande - envoi d'une touche de fonction
Private Sub cmdCommandes_Click(Index As Integer)
    Dim Commandes As Variant
    
    ' Cas particulier de Connexion
    If Index = FKConnexion Then
        ReDim Commandes(0 To 3) As Byte
        Commandes(0) = &H1B
        Commandes(1) = &H29
        Commandes(2) = &H34
        Commandes(3) = &HD
        
    ' Autres touches
    Else
        ReDim Commandes(0 To 2) As Byte
        Commandes(0) = &H13
        Commandes(2) = &HD
        
        Select Case Index
            Case FKRepetition
                Commandes(1) = &H43
            
            Case FKGuide
                Commandes(1) = &H44
            
            Case FKSommaire
                Commandes(1) = &H46
            
            Case FKAnnulation
                Commandes(1) = &H45
            
            Case FKCorrection
                Commandes(1) = &H47
            
            Case FKRetour
                Commandes(1) = &H42
            
            Case FKSuite
                Commandes(1) = &H48
            
            Case FKEnvoi
                Commandes(1) = &H41
        End Select
    End If

    ' Envoi
    com.Output = Commandes
End Sub

'---- Touche de fonction
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    ' Si connect
    If com.PortOpen Then
        Select Case KeyCode
            Case vbKeyReturn
                If Shift And vbCtrlMask Then
                    ' Retour normal
                    com.Output = vbCrLf
                Else
                    ' Envoi minitel
                    cmdCommandes_Click FKEnvoi
                End If
            
            Case vbKeyDown
                cmdCommandes_Click FKSuite
            
            Case vbKeyUp
                cmdCommandes_Click FKRetour
            
            Case vbKeyPageUp
                cmdCommandes_Click FKRepetition
            
            Case vbKeyPageDown
                cmdCommandes_Click FKGuide
            
            Case vbKeyHome
                cmdCommandes_Click FKSommaire
            
            Case vbKeyBack
                cmdCommandes_Click FKCorrection
            
            Case vbKeyDelete
                cmdCommandes_Click FKAnnulation
            
            Case vbKeyEnd
                cmdCommandes_Click FKConnexion
        End Select
    End If
End Sub

'---- Touche ANSI du clavier
Private Sub pctScreen_KeyPress(KeyAscii As Integer)
    ' Si connect
    If com.PortOpen Then
        com.Output = Chr(KeyAscii)
    End If
End Sub

'---- Resize
Private Sub Form_Resize()
    ' Panneau de commandes
    pctCommandes.Move 0, 0, cmdCommandes(0).Width + 200, ScaleHeight - pctStatus.Height
    ' Ecran Minitel
    pctScreen.Move pctCommandes.Width, 0, ScaleWidth - pctCommandes.Width, ScaleHeight - pctStatus.Height
    ' Boutons
    Dim cmd As CommandButton
    For Each cmd In cmdCommandes
        cmd.Move (pctCommandes.ScaleWidth - cmdCommandes(0).Width) / 2, cmd.Top
    Next
End Sub

'---- Initialisations
Private Sub Form_Load()
    ' Lit le port de communications
    ComPort = Val(GetSetting("Minitel", "Communications", "Port", 1))
End Sub

'---- Finalisations
Private Sub Form_Unload(Cancel As Integer)
    ' Arrte ventuellement l'enregistrement
    If fEnr Then mnuPlay_Click
    ' Dconnecte ventuellement
    If com.PortOpen Then mnuDisconnect_Click
    ' Enregistre le port de communications
    SaveSetting "Minitel", "Communications", "Port", ComPort
End Sub

'---- ProcessNewSequence
Private Sub ProcessNewSequence()
    ' Traite le caractre
    Dim c As Byte
    c = GetNextChar()
    
    Select Case c
        Case &H20 To &H7F   ' Affichage d'un caractre
            Scr.AddChar c

        Case NUL    ' NULL remplac par blanc
            Scr.AddChar &H20
        
        Case &H2, &H3, &H6, &H17, &H1C  ' Caractres ignors
        
        Case SOH    ' &h01
        
        Case EOT    ' &h04
        
        Case ENQ    ' &h05 - Demande identification Ram1

        Case BEL    ' &h07 - Sonnette
            Beep
        
        Case DLE    ' &h10
        
        Case NACK   ' &h15
        
        Case SYN    ' &h16
            ProcessSS2
        
        Case SS2    ' &h19 - Passage en jeu G2, codage des caractres accentus
            ProcessSS2
        
        Case SS3    ' &h1D
            ' Ignore caractre suivant
            GetNextChar

        Case BS     ' &h08 - Backspace
            Scr.BS
        
        Case HT     ' &h09 - Avance 1 caractre
            Scr.HT
        
        Case LF     ' &h0A - Line Feed
            Scr.LF
        
        Case VT     ' &h0B - Dplacement vers le haut
            Scr.VT
        
        Case FF     ' &h0C - Effacement cran
            Scr.FF
        
        Case CR     ' &h0D - Carriage return
            Scr.CR
        
        Case SO     ' &h0E - Passage en jeu G1
            Scr.CharSet = G1
        
        Case SI     ' &h0F - Passage en jeu G0
            Scr.CharSet = G0

        Case Con    ' Curseur clignotant
            Scr.Cursor = True
            
        Case REP    ' Rptition d'un caractre
            ProcessREP
        
        Case SEP    ' Transparence de caractre
            ' Caractre suivant ignor
            GetNextChar
        
        Case Coff   ' Arrt du curseur
            Scr.Cursor = False
        
        Case CAN    ' Effacement de la range courante
            ' Ignor
        
        Case SUUB   ' Signalisation erreur de transmission
            ' Ignor
        
        Case ESC    ' Introduction squence de contrle
            ProcessESC
        
        Case RS     ' Retour curseur  l'origine
            Scr.RS
        
        Case US     ' &h1F - Squence de positionnement du curseur
            ProcessUS
        
    End Select
End Sub

'---- ProcessSS2 - Jeu de caractres G2
Private Sub ProcessSS2()
    ' Indicateur d'criture
    Dim fEcrire As Boolean: fEcrire = False
    ' Traite le caractre
    Dim c As Byte
    c = GetNextChar()
    
    Select Case c
        Case &H7A   ' oe
            c = Asc("")
            fEcrire = True
        
        Case &H6A:  ' OE
            c = Asc("")
            fEcrire = True
        
        Case &H7B:  ' 
            c = Asc("")
            fEcrire = True
        
        Case &H23:  ' 
            c = Asc("")
            fEcrire = True
        
        Case &H27:  ' 
            c = Asc("")
            fEcrire = True
        
        Case &H2C:
        
        Case &H2D:
        
        Case &H2E:
        
        Case &H2F:
        
        Case &H30:  ' 
            c = Asc("")
            fEcrire = True
        
        Case &H31:  ' 
            c = Asc("")
            fEcrire = True
        
        Case &H38:  ' 
            c = Asc("")
            fEcrire = True
        
        Case &H41:
            ' Accent grave
            ProcessGrave
        
        Case &H42:
            ' Accent aig
            ProcessAcute
        
        Case &H43:
            ' Accent circonflex
            ProcessCircumflex
        
        Case &H48:
            ' Accent trma
            ProcessDieresis
        
        Case Else
            GetNextChar
    End Select
    
    ' Ecrit
    If fEcrire Then Scr.AddChar c
End Sub

'---- ProcessAcute
Private Sub ProcessAcute()
    ' Indicateur d'criture
    Dim fEcrire As Boolean: fEcrire = False
    ' Traite le caractre
    Dim c As Byte
    c = GetNextChar()
    
    Select Case c
        Case &H65
            c = Asc("")
            fEcrire = True
    End Select
    
    ' Ecrit
    If fEcrire Then Scr.AddChar c
End Sub

'---- ProcessGrave
Private Sub ProcessGrave()
    ' Indicateur d'criture
    Dim fEcrire As Boolean: fEcrire = False
    ' Traite le caractre
    Dim c As Byte
    c = GetNextChar()
    
    Select Case c
        Case &H61
            c = Asc("")
            fEcrire = True
            
        Case &H65
            c = Asc("")
            fEcrire = True
    End Select
    
    ' Ecrit
    If fEcrire Then Scr.AddChar c
End Sub

'---- ProcessCircumflex
Private Sub ProcessCircumflex()
    ' Indicateur d'criture
    Dim fEcrire As Boolean: fEcrire = False
    ' Traite le caractre
    Dim c As Byte
    c = GetNextChar()
    
    Select Case c
        Case &H61:
            c = Asc("")
            fEcrire = True
        
        Case &H65:
            c = Asc("")
            fEcrire = True
        
        Case &H69:
            c = Asc("")
            fEcrire = True
        
        Case &H6F:
            c = Asc("")
            fEcrire = True
    End Select
    
    ' Ecrit
    If fEcrire Then Scr.AddChar c
End Sub

'---- ProcessDieresis
Private Sub ProcessDieresis()
    ' Indicateur d'criture
    Dim fEcrire As Boolean: fEcrire = False
    ' Traite le caractre
    Dim c As Byte
    c = GetNextChar()
    
    Select Case c
        Case &H61:
            c = Asc("")
            fEcrire = True
        
        Case &H65:
            c = Asc("")
            fEcrire = True
        
        Case &H69:
            c = Asc("")
            fEcrire = True
        
        Case &H6F:
            c = Asc("")
            fEcrire = True
        
        Case &H4F:
            c = Asc("")
            fEcrire = True
    End Select

    ' Ecrit
    If fEcrire Then Scr.AddChar c
End Sub

'---- ProcessREP
Private Sub ProcessREP()
    ' Format : Char - REP - Nombre
    ' Nombre de rptitions, sur 6 bits
    Dim c As Byte
    c = GetNextChar()
    
    ' Boucle
    Dim i As Integer
    For i = CInt(c And &H3F) To 1 Step -1
        Scr.AddChar Scr.LastChar
    Next
End Sub

'---- ProcessESC
Private Sub ProcessESC()
    Dim c As Byte
    c = GetNextChar()
    Select Case c
        Case &H20   ' 1B 20 2X 3Y - Invitation  numroter
            ' Ignore les deux caractres suivants
            GetNextChar
            GetNextChar
        
        Case &H23   ' Masquage
            c = GetNextChar()
            If c = &H20 Then
                c = GetNextChar()
                If c = &H58 Then
                    ' Masquage plein cran
                ElseIf c = &H5F Then
                    ' dmasquage plein cran
                End If
            End If
    
        
        '
        Case &H25   ' Mode transparence
    
    
        Case &H30, &H31, &H32, &H33, &H34, &H35, &H36, &H37, &H38   ' Codes ignors
            ' Caractre suivant ignor
            GetNextChar
    
        Case &H39   ' PRO1
            ' Caractre suivant ignor
            GetNextChar
    
        Case &H3A   ' PRO2
            ' 2 caractres suivants ignors
            GetNextChar
            GetNextChar

        Case &H3B   ' PRO3
            ' 3 caractres suivants ignors
            GetNextChar
            GetNextChar
            GetNextChar
    
        Case &H3C, &H3D, &H3E, &H3F ' Codes ignors
            ' Caractre suivant ignor
            GetNextChar

        '---- Couleur du texte
        Case &H40   ' Texte noir
            Scr.TextColor = vbBlack
        
        Case &H41   ' Texte rouge
            Scr.TextColor = vbRed
        
        Case &H42   ' Texte vert
            Scr.TextColor = vbGreen
        
        Case &H43   ' Texte jaune
            Scr.TextColor = vbYellow
        
        Case &H44   ' Texte bleu
            Scr.TextColor = vbBlue
        
        Case &H45   ' Texte magenta
            Scr.TextColor = vbMagenta
        
        Case &H46   ' Texte cyan
            Scr.TextColor = vbCyan
        
        Case &H47   ' Texte blanc
            Scr.TextColor = vbWhite
    
        Case &H4C   ' Grandeur normale
            Scr.DoubleHeight = False
            Scr.DoubleWidth = False
        
        Case &H4D   ' Double hauteur
            Scr.DoubleHeight = True
        
        Case &H4E   ' Double largeur
            Scr.DoubleWidth = True
        
        Case &H4F   ' Double grandeur
            Scr.DoubleHeight = True
            Scr.DoubleWidth = True
    
        '---- Couleurs du fond
        Case &H50   ' Fond noir
            Scr.BackColor = vbBlack
        
        Case &H51   ' Fond rouge
            Scr.BackColor = vbRed
        
        Case &H52   ' Fond vert
            Scr.BackColor = vbGreen
        
        Case &H53   ' Fond jaune
            Scr.BackColor = vbYellow
        
        Case &H54   ' Fond bleu
            Scr.BackColor = vbBlue
        
        Case &H55   ' Fond magenta
            Scr.BackColor = vbMagenta
        
        Case &H56   ' Fond cyan
            Scr.BackColor = vbCyan
        
        Case &H57   ' Fond blanc
            Scr.BackColor = vbWhite
    
        Case &H59   ' Fin de soulign
            Scr.Underline = False
    
        Case &H5A   ' Dbut de soulign
            Scr.Underline = True
    
        Case &H5B   ' CSI
            ProcessCSI
    
        Case &H5C   ' Fin d'inversion
            Scr.Invert = False
        
        Case &H5D   ' Inversion vido
            Scr.Invert = True
        
        Case &H5F   ' Dmasquage
    
        Case &H61   ' Demande de position du curseur
    
    End Select
End Sub

'---- ProcessCSI
Private Sub ProcessCSI()
    Dim c As Byte
    c = GetNextChar()
    Select Case c
        Case &H4A   ' Effacement du curseur  la fin de l'cran
            Scr.EraseCharacters ToEndOfScreen

        Case &H4B   ' Effacement du curseur  la fin de la ligne
            Scr.EraseCharacters ToEndOfLine

      
        Case &H30   ' Effacement depuis le curseur inclus
            c = GetNextChar()
            If c = &H4A Then
                ' Effacement du curseur  la fin de l'cran
                Scr.EraseCharacters ToEndOfScreen
            ElseIf c = &H4B Then
                ' Effacement du curseur  la fin de la ligne
                Scr.EraseCharacters ToEndOfLine
            End If

        Case &H31   ' Effacement jusqu'au curseur inclus
            c = GetNextChar()
            If c = &H4A Then
                ' Effacement depuis le dbut de l'cran
                Scr.EraseCharacters FromBeginOfScreen
            ElseIf c = &H4B Then
                ' Effacement depuis le dbut de la ligne
                Scr.EraseCharacters FromBeginOfLine
            End If

      ' effacement
        Case &H32   ' Effacements
            c = GetNextChar()
            If c = &H4A Then
                ' Effacement de tout l'cran
                Scr.EraseCharacters AllScreen
            ElseIf c = &H4B Then
                ' Effacement de la ligne du curseur
                Scr.EraseCharacters CurrentLine
            End If

        Case &H34   ' Mode insertion de caractres
            c = GetNextChar()
            If c = &H68 Then
                ' Dbut d'insertion
            ElseIf c = &H6C Then
                ' Fin d'insertion
            End If

        Case Else
            c = GetNextChar()
            Select Case c
                Case &H3B   ' Adressage direct curseur
                    GetNextChar
                    GetNextChar

                Case &H40   ' Insertion de n caractres  partir du curseur inclus

                Case &H41   ' Curseur vers le haut de n ranges. Arrt en haut de l'cran

                Case &H42   ' Curseur vers le bas de n ranges. Arrt en bas de l'cran

                Case &H43   ' Curseur vers la droite de n colonnes. Arrt au bord droit de l'cran

                Case &H44   ' Curseur vers la gauche de n colonnes. Arrt au bord gauche de l'cran

                Case &H4C   ' Insertion de n lignes  partir de celle o est le curseur

                Case &H4D   ' Suppression de n lignes  partir de celle o est le curseur
        
                Case &H50   ' Suppression de n caractres  partir du curseur inclus
            End Select
    End Select
End Sub

'---- ProcessUS - Positionnement ligne - colonne
Private Sub ProcessUS()
    ' Format : Ligne - Colonne
    ' Ligne et colonne sont sur 6 bits
    Dim Line  As Integer, Column As Integer
    Line = (GetNextChar() And &H3F) + 1
    Column = (GetNextChar() And &H3F) + 1
    
    ' Valorise
    Scr.SetPosition Line, Column
End Sub

'---- GetNextChar
Private Function GetNextChar() As Byte
    ' Pas en Jouer
    If Not fPlay Then
        ' Boucle d'attente
        Do While Not IsCharWaiting
            DoEvents
        Loop
        
        ' Prend le prochain caractre
        GetNextChar = com.Input(0)
    
        ' Enregistrement
        If fEnr Then
            Put 1, , GetNextChar
        End If
    
    ' En mode jouer
    Else
        Dim c As Byte
        Get 1, , c
        GetNextChar = c
    End If
End Function

'---- IsCharWaiting
'     Indique s'il y a des caractres dans la file de rception
Private Function IsCharWaiting() As Boolean
    IsCharWaiting = (com.InBufferCount > 0)
End Function

'---- CheckComm
'     Appele par Sub Main
Public Sub CheckComm()
    If com.PortOpen Then
        ' Tant qu'il y a des caractres en rception
        ' les traite
        Do While IsCharWaiting()
            ProcessNewSequence
        Loop
    End If
End Sub

'---- Evnement de communications
Private Sub com_OnComm()
    Select Case com.CommEvent
        ' Erreurs
        Case comEventBreak      ' Un signal d'arrt a t reu.
            Debug.Print "Break"
        Case comEventCDTO       ' Erreur de dlai d'attente dtection de porteuse.
            Debug.Print "CDTO"
        Case comEventCTSTO      ' Erreur de dlai d'attente prt  mettre.
            Debug.Print "CTSTO"
        Case comEventDSRTO      ' Erreur de dlai d'attente modem prt.
            Debug.Print "DSRTO"
        Case comEventFrame      ' Erreur de dpassement du dlai imparti
            Debug.Print "Frame"
        Case comEventOverrun    ' Donnes perdues.
            Debug.Print "Overrun"
        Case comEventRxOver     ' Dpassement de la capacit du tampon de rception.
            Debug.Print "RxOver"
        Case comEventRxParity   ' Erreur de parit.
            Debug.Print "RxParity"
        Case comEventTxFull     ' Tampon de transmission plein.
            Debug.Print "TxFull"
        Case comEventDCB        ' Erreur inattendue lors de l'extraction du bloc de contrle de priphrique]
            Debug.Print "DCB"

        ' vnements
        Case comEvCD            ' Modification dans la ligne dtection de porteuse.
        Case comEvCTS           ' Modification dans la ligne prt  mettre.
        Case comEvDSR           ' Modification dans la ligne modem prt.
        Case comEvRing          ' Modification dans l'indicateur d'appel.
        Case comEvReceive       ' Rception de caractres
        Case comEvSend          ' Envoi de caractres
        Case comEvEOF           ' Caractre de fin de fichier trouv dans le flux en entre
    End Select
End Sub

'---- InitScreen
Private Sub InitScreen()
    ' Cre l'cran
    Set Scr = New clsScreen
    ' Mode 25x40
    Scr.Init pctScreen, 25, 40
End Sub

'---- Saisie du port de communications
Private Sub mnuPort_Click()
    ' Charge et initialise la bote de dialogue
    Load frmPort
    frmPort.ComPort = ComPort
    frmPort.Init
    frmPort.Show vbModal
    
    ' Traite le rsultat
    ComPort = frmPort.ComPort
    Unload frmPort
End Sub

'---- Connexion - dconnexion
Private Sub mnuConnect_Click()
    ' Etat du sous-menu
    mnuCall.Enabled = Not com.PortOpen
    mnuDisconnect.Enabled = com.PortOpen
End Sub

'---- Menu Appel
Private Sub mnuCall_Click()
    Static Num As String
    If Num = "" Then Num = "3611"
    Num = InputBox("Numro  appeler", "Appeler", Num)
    If Num <> "" Then
        On Error GoTo Err_mnuCall
        
        ' Initialise
        InitScreen
        
        ' Settings
        com.CommPort = ComPort
        com.Settings = "38400,E,7,1"
        ' Mode de rception binaire
        com.InputMode = comInputModeBinary
        ' Demande 1 caractre  la fois
        com.InputLen = 1
        ' Pas d'vnements de rception
        com.RThreshold = 0
        com.SThreshold = 1
        com.DTREnable = True
        com.RTSEnable = True
        ' Pas de caractres Nul
        com.NullDiscard = True
        ' Ouvre
        com.PortOpen = True
        ' Numrote
        com.Output = "ATDT" & Num & vbCr
        
        ' Valide les touches de fonction
        pctCommandes.Enabled = True
    End If
    Exit Sub

Err_mnuCall:
    ' Erreur
    If com.PortOpen Then com.PortOpen = False
    MsgBox Err.Description, vbCritical
End Sub

'---- Menu Dconnecter
Private Sub mnuDisconnect_Click()
    com.PortOpen = False
    Set Scr = Nothing
    
    ' Invalide les touches de fonction
    pctCommandes.Enabled = False
End Sub

'---- Menu Joue
Private Sub mnuPlay_Click()
    ' Initialise
    InitScreen
    
    ' Ouvre fichier
    Open App.Path & "\Minitel.trc" For Binary Access Read As 1

    ' Indicateur
    fPlay = True
    
    ' Lit fichier
    Dim c As Byte
    Do While Not EOF(1)
        ProcessNewSequence
    Loop
    
    ' Ferme et termine
    Close 1
    fPlay = False
End Sub

'---- Menu Enregistre
Private Sub mnuRecord_Click()
    If fEnr Then
        ' Arrte
        Close 1
        fEnr = False
        
    Else
        ' Dmarre
        Open App.Path & "\Minitel.trc" For Binary Access Write As 1
        fEnr = True
    End If
End Sub

'---- Menu cran
Private Sub mnuScreen_Click()
    mnuRecord.Checked = fEnr
    mnuPlay.Enabled = Not com.PortOpen
End Sub

'---- Timer
Private Sub tim_Timer()
    ' Affiche les LED
    shpLed(0).FillColor = IIf(com.CDHolding, vbRed, vbGreen)
    shpLed(1).FillColor = IIf(com.CTSHolding, vbRed, vbGreen)
    shpLed(2).FillColor = IIf(com.DSRHolding, vbRed, vbGreen)
    shpLed(3).FillColor = IIf(com.DTREnable, vbRed, vbGreen)
    shpLed(4).FillColor = IIf(com.RTSEnable, vbRed, vbGreen)
    
    ' Si on a perdu la porteuse, se dconnecte
    If com.PortOpen And CDHolding And Not com.CDHolding Then mnuDisconnect_Click
    CDHolding = com.CDHolding
End Sub
