-- ============================================================
--   Nom de la base   :  T-SOFT SQL PL-SQL                            
--   Nom de SGBD      :  ORACLE Version 8                      
--   Date de creation :  10/05/2002  22:30                     
-- ============================================================

CONNECT &utilisateur/&password;


DROP USER STAGIAIRE CASCADE;


-- ============================================================
--   CREATE : STAGIAIRE
-- ============================================================
CREATE USER STAGIAIRE  PROFILE DEFAULT IDENTIFIED BY PWD 
    DEFAULT     TABLESPACE USERS 
    TEMPORARY   TABLESPACE TEMP ACCOUNT UNLOCK;
GRANT CONNECT TO STAGIAIRE;
GRANT RESOURCE TO STAGIAIRE;

CONNECT STAGIAIRE/PWD;

-- ============================================================
--   Table : CATEGORIES                                        
-- ============================================================
CREATE TABLE CATEGORIES
(
    CODE_CATEGORIE     NUMBER(6)              NOT NULL,
    NOM_CATEGORIE      VARCHAR2(25)           NOT NULL,
    DESCRIPTION        VARCHAR2(100)          NOT NULL,
    CONSTRAINT PK_CATEGORIES PRIMARY KEY (CODE_CATEGORIE)
)
/

-- ============================================================
--   Table : CLIENTS                                           
-- ============================================================
CREATE TABLE CLIENTS
(
    CODE_CLIENT        CHAR(5)                NOT NULL,
    SOCIETE            VARCHAR2(40)           NOT NULL,
    ADRESSE            VARCHAR2(60)           NOT NULL,
    VILLE              VARCHAR2(15)           NOT NULL,
    CODE_POSTAL        VARCHAR2(10)           NOT NULL,
    PAYS               VARCHAR2(15)           NOT NULL,
    TELEPHONE          VARCHAR2(24)           NOT NULL,
    FAX                VARCHAR2(24)           NULL    ,
    CONSTRAINT PK_CLIENTS PRIMARY KEY (CODE_CLIENT)
)
/

-- ============================================================
--   Table : EMPLOYES                                          
-- ============================================================
CREATE TABLE EMPLOYES
(
    NO_EMPLOYE         NUMBER(6)              NOT NULL,
    REND_COMPTE        NUMBER(6)              NULL    ,
    NOM                VARCHAR2(20)           NOT NULL,
    PRENOM             VARCHAR2(10)           NOT NULL,
    FONCTION           VARCHAR2(30)           NOT NULL,
    TITRE              VARCHAR2(5)            NOT NULL,
    DATE_NAISSANCE     DATE                   NOT NULL,
    DATE_EMBAUCHE      DATE                   NOT NULL,
    SALAIRE            NUMBER(8, 2)           NOT NULL,
    COMMISSION         NUMBER(8, 2)           NULL,
    CONSTRAINT PK_EMPLOYES PRIMARY KEY (NO_EMPLOYE)
)
/

-- ============================================================
--   Index : EMPLOYES_REND_COMPTE_FK                           
-- ============================================================
CREATE INDEX EMPLOYES_REND_COMPTE_FK ON EMPLOYES (REND_COMPTE ASC)
/

-- ============================================================
--   Table : FOURNISSEURS                                      
-- ============================================================
CREATE TABLE FOURNISSEURS
(
    NO_FOURNISSEUR     NUMBER(6)              NOT NULL,
    SOCIETE            VARCHAR2(40)           NOT NULL,
    ADRESSE            VARCHAR2(60)           NOT NULL,
    VILLE              VARCHAR2(20)           NOT NULL,
    CODE_POSTAL        VARCHAR2(10)           NOT NULL,
    PAYS               VARCHAR2(15)           NOT NULL,
    TELEPHONE          VARCHAR2(24)           NOT NULL,
    FAX                VARCHAR2(24)           NULL    ,
    CONSTRAINT PK_FOURNISSEURS PRIMARY KEY (NO_FOURNISSEUR)
)
/

-- ============================================================
--   Table : COMMANDES                                         
-- ============================================================
CREATE TABLE COMMANDES
(
    NO_COMMANDE        NUMBER(6)              NOT NULL,
    CODE_CLIENT        CHAR(5)                NOT NULL,
    NO_EMPLOYE         NUMBER(6)              NOT NULL,
    DATE_COMMANDE      DATE                   NOT NULL,
    DATE_ENVOI         DATE                       NULL,
    PORT               NUMBER(8,2)                NULL,
    CONSTRAINT PK_COMMANDES PRIMARY KEY (NO_COMMANDE)
)
/

-- ============================================================
--   Index : CLIENTS_COMMANDES_FK                              
-- ============================================================
CREATE INDEX CLIENTS_COMMANDES_FK ON COMMANDES (CODE_CLIENT ASC)
/

-- ============================================================
--   Index : EMPLOYES_COMMANDES_FK                             
-- ============================================================
CREATE INDEX EMPLOYES_COMMANDES_FK ON COMMANDES (NO_EMPLOYE ASC)
/

-- ============================================================
--   Table : PRODUITS                                          
-- ============================================================
CREATE TABLE PRODUITS
(
    REF_PRODUIT        NUMBER(6)              NOT NULL,
    NOM_PRODUIT        VARCHAR2(40)           NOT NULL,
    NO_FOURNISSEUR     NUMBER(6)              NOT NULL,
    CODE_CATEGORIE     NUMBER(6)              NOT NULL,
    QUANTITE           VARCHAR2(30)               NULL,
    PRIX_UNITAIRE      NUMBER(8,2)            NOT NULL,
    UNITES_STOCK       NUMBER(5)                  NULL,
    UNITES_COMMANDEES  NUMBER(5)                  NULL,
    INDISPONIBLE       NUMBER(1)                  NULL,
    CONSTRAINT PK_PRODUITS PRIMARY KEY (REF_PRODUIT)
)
/

-- ============================================================
--   Index : FOURNISEURS_PRODUITS_FK                           
-- ============================================================
CREATE INDEX FOURNISEURS_PRODUITS_FK ON PRODUITS (NO_FOURNISSEUR ASC)
/

-- ============================================================
--   Index : CATEGORIES_PRODUITS_FK                            
-- ============================================================
CREATE INDEX CATEGORIES_PRODUITS_FK ON PRODUITS (CODE_CATEGORIE ASC)
/

-- ============================================================
--   Table : DETAILS_COMMANDES                                 
-- ============================================================
CREATE TABLE DETAILS_COMMANDES
(
    NO_COMMANDE        NUMBER(6)              NOT NULL,
    REF_PRODUIT        NUMBER(6)              NOT NULL,
    PRIX_UNITAIRE      NUMBER(8,2)            NOT NULL,
    QUANTITE           NUMBER(5)              NOT NULL,
    REMISE             FLOAT                  NOT NULL,
    CONSTRAINT PK_DETAILS_COMMANDES PRIMARY KEY (NO_COMMANDE, REF_PRODUIT)
)
/

-- ============================================================
--   Index : COMMANDES_DETAILS_COMMANDES_FK                    
-- ============================================================
CREATE INDEX COMMANDES_DETAILS_COMMANDES_FK ON DETAILS_COMMANDES (NO_COMMANDE ASC)
/

-- ============================================================
--   Index : PRODUITS_DETAILS_COMMANDES_FK                     
-- ============================================================
CREATE INDEX PRODUITS_DETAILS_COMMANDES_FK ON DETAILS_COMMANDES (REF_PRODUIT ASC)
/


@&&disque_repertoire\categories.sql
@&&disque_repertoire\clients.sql
@&&disque_repertoire\commande.sql
@&&disque_repertoire\details_produits.sql
@&&disque_repertoire\employe.sql
@&&disque_repertoire\founisseurs.sql
@&&disque_repertoire\produits.sql
@&&disque_repertoire\null.sql


ALTER TABLE EMPLOYES
    ADD CONSTRAINT FK_EMPLOYES_EMPLOYES FOREIGN KEY  (REND_COMPTE)
       REFERENCES EMPLOYES (NO_EMPLOYE)
/

ALTER TABLE COMMANDES
    ADD CONSTRAINT FK_COMMANDE_CLIENTS FOREIGN KEY  (CODE_CLIENT)
       REFERENCES CLIENTS (CODE_CLIENT)
/

ALTER TABLE COMMANDES
    ADD CONSTRAINT FK_COMMANDE_EMPLOYES FOREIGN KEY  (NO_EMPLOYE)
       REFERENCES EMPLOYES (NO_EMPLOYE)
/

ALTER TABLE PRODUITS
    ADD CONSTRAINT FK_PRODUITS_FOURNISEUR FOREIGN KEY  (NO_FOURNISSEUR)
       REFERENCES FOURNISSEURS (NO_FOURNISSEUR)
/

ALTER TABLE PRODUITS
    ADD CONSTRAINT FK_PRODUITS_CATEGORIE FOREIGN KEY  (CODE_CATEGORIE)
       REFERENCES CATEGORIES (CODE_CATEGORIE)
/

ALTER TABLE DETAILS_COMMANDES
    ADD CONSTRAINT FK_DETAILS_COMMANDES_COMMANDES FOREIGN KEY  (NO_COMMANDE)
       REFERENCES COMMANDES (NO_COMMANDE)
/

ALTER TABLE DETAILS_COMMANDES
    ADD CONSTRAINT FK_DETAILS_PRODUITS_PRODUITS FOREIGN KEY  (REF_PRODUIT)
       REFERENCES PRODUITS (REF_PRODUIT)
/

@&&disque_repertoire\select.sql

exit;