package client;

import beans.Calculator;
import beans.CalculatorHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class CalculatorClient extends JFrame
  implements ActionListener { 
    
  private JButton _clear = new JButton("Effacer");
  private JButton _equals = new JButton("=");
  private JTextField _topNumber = new JTextField("0");
  private JTextField _bottomNumber = new JTextField("0");
  private JComboBox _operator = new JComboBox();
  private Calculator _calculator;
  
  public CalculatorClient() {
    // Obtenir la calculatrice
    _calculator = getCalculator();
    
    // Ajouter le titre
    JLabel title = new JLabel("Calculatrice minimale");
    title.setHorizontalAlignment(JLabel.CENTER);
    getContentPane().add(title, BorderLayout.NORTH);
    
    // Ajouter le panneau de calcul
    JPanel calcPanel = new JPanel(new GridLayout(2, 2));
    calcPanel.add(new JLabel("Rsultat"));
    _topNumber.setEditable(false);
    calcPanel.add(_topNumber);
    _operator.addItem("+");
    _operator.addItem("-");
    calcPanel.add(_operator);
    calcPanel.add(_bottomNumber);
    getContentPane().add(calcPanel, BorderLayout.CENTER);
    
    // Ajouter les boutons
    JPanel buttonPanel = new JPanel(new GridLayout(2, 1));
    _equals.addActionListener(this);
    buttonPanel.add(_equals);
    _clear.addActionListener(this);
    buttonPanel.add(_clear);
    getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });

    setSize(300, 150);
    setVisible(true);
  }
  
  private Calculator getCalculator() {
    Calculator calculator = null;
    try {
      // Obtenir un contexte
      InitialContext jndiContext = new InitialContext();

      // Obtenir une rfrence  l'entre JNDI
      Object ref  = jndiContext.lookup("ejb/beans.SimpleCalculator");

      // Obtenir une rfrence  l'interface home du bean
      CalculatorHome home = (CalculatorHome)
        PortableRemoteObject.narrow(ref, CalculatorHome.class);

      // Crer un objet Calculator  partir de l'interface home
      calculator = home.create();
    } catch(Exception e) {
      e.printStackTrace();
    }
    
    return calculator;
  }
  
  public void actionPerformed(ActionEvent ae) {
    // Si l'utilisateur a cliqu sur =, effectuer le calcul
    if (ae.getSource() == _equals) {
      runCalculator();
    }
    
    // Si l'utilisateur a cliqu sur Effacer, effacer le rsultat
    if (ae.getSource() == _clear) {
      clearCalculator();
    }
  }
  
  private void runCalculator() {
    try {
      // Obtenir la valeur courante
      int operVal = 0;
      String textVal = _bottomNumber.getText();
      if (textVal != null) {
        try {
          operVal = Integer.parseInt(textVal);
        }
        catch (NumberFormatException nfe) { }
      }
      
      // Obtenir l'oprateur
      String oper = (String) _operator.getSelectedItem();
      
      // Calculer la nouvelle valeur
      _calculator.calculate(oper, operVal);
      
      // Afficher la nouvelle valeur
      _topNumber.setText("" + _calculator.getValue());
    }
    catch (Exception e) {
      e.printStackTrace(); 
    }
    
  }
  
  private void clearCalculator() {
    try {
      // Effacer tout
      _calculator.clearIt();
      _topNumber.setText("0");
      _bottomNumber.setText("0");
      _operator.setSelectedIndex(0);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  public static void main(String[] args) {
    CalculatorClient calcClient = new CalculatorClient();
  }
}