package client;

import beans.StockList;
import beans.StockListHome;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class StockClient extends JFrame 
  implements ActionListener { 
  private StockList _stockList;
  private JTextField _ticker = new JTextField();
  private JTextField _name = new JTextField();
  private JButton _get = new JButton("Lire");
  private JButton _add = new JButton("Ajouter");
  private JButton _update = new JButton("Modifier");
  private JButton _delete = new JButton("Supprimer");
      
  public StockClient() {
    // Obtenir le bean session
    _stockList = getStockList();
    
    // Ajouter le titre
    JLabel title = new JLabel("Liste des actions");
    title.setHorizontalAlignment(JLabel.CENTER);
    getContentPane().add(title, BorderLayout.NORTH);
    
    // Ajouter le panneau des tiquettes
    JPanel stockLabelPanel = new JPanel(new GridLayout(2, 1));
    stockLabelPanel.add(new JLabel("Symbole"));
    stockLabelPanel.add(new JLabel("Nom"));
    getContentPane().add(stockLabelPanel, BorderLayout.WEST);
    
    // Ajouter le panneau des actions
    JPanel stockFieldPanel = new JPanel(new GridLayout(2, 1));
    stockFieldPanel.add(_ticker);
    stockFieldPanel.add(_name);
    getContentPane().add(stockFieldPanel, BorderLayout.CENTER);
    
    // Ajouter les boutons
    JPanel buttonPanel = new JPanel(new GridLayout(1, 4));
    _get.addActionListener(this);
    buttonPanel.add(_get);
    _add.addActionListener(this);
    buttonPanel.add(_add);
    _update.addActionListener(this);
    buttonPanel.add(_update);
    _delete.addActionListener(this);
    buttonPanel.add(_delete);
    getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });

    setSize(330, 130);
    setVisible(true);
  }
  
  private StockList getStockList() {
    StockList stockList = null;
    try {
      // Obtenir un contexte JNDI
      InitialContext jndiContext = new InitialContext();

      // Obtenir une rfrence  l'entre JNDI StockList
      Object ref  = jndiContext.lookup("ejb/beans.StockList");

      // Obtenir une rfrence  l'interface home du bean
      StockListHome home = (StockListHome)
        PortableRemoteObject.narrow(ref, StockListHome.class);

      // Crer un objet StockList
      stockList = home.create();
    } catch(Exception e) {
      e.printStackTrace();
    }
    
    return stockList;
  }
  
  public void actionPerformed(ActionEvent ae) {
    // Le bouton Lire a t cliqu. Lire les actions
    if (ae.getSource() == _get) {
      getStock();
    }
    
    // Le bouton Ajouter a t cliqu. Ajouter une action
    if (ae.getSource() == _add) {
      addStock();
    }
    
    // Le bouton Modifier a t cliqu. Modifier l'action
    if (ae.getSource() == _update) {
      updateStock();
    }
    
    // Le bouton Supprimer a t cliqu. Supprimer l'action
    if (ae.getSource() == _delete) {
      deleteStock();
    }
  }
  
  private void getStock() {
    // Lire de symbole
    String ticker = _ticker.getText();
    if (ticker == null || ticker.length() == 0) {
      JOptionPane.showMessageDialog(this, "Le symbole doit tre indiqu.");
      return;
    }
    
    // Obtenir l'action
    try {
      String name = _stockList.getStock(ticker);
      _name.setText(name);
    }
    catch (FinderException fe) {
      JOptionPane.showMessageDialog(this, "Non trouv !");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  private void addStock() {
    // Lire le symbole
    String ticker = _ticker.getText();
    if (ticker == null || ticker.length() == 0) {
      JOptionPane.showMessageDialog(this, "Le symbole doit tre indiqu.");
      return;
    }
    
    // Lire le nom
    String name = _name.getText();
    if (name == null || name.length() == 0) {
      JOptionPane.showMessageDialog(this, "Le nom doit tre indiqu.");
      return;
    }
    
    // Ajouter l'action
    try {
      _stockList.addStock(ticker, name);
      JOptionPane.showMessageDialog(this, "Action ajoute !");
    }
    catch (CreateException fe) {
      JOptionPane.showMessageDialog(this, "Cette action xiste dj !");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  private void updateStock() {
    // Lire le symbole
    String ticker = _ticker.getText();
    if (ticker == null || ticker.length() == 0) {
      JOptionPane.showMessageDialog(this, "Le symbole doit tre indiqu.");
      return;
    }
    
    // Lire le nom
    String name = _name.getText();
    if (name == null || name.length() == 0) {
      JOptionPane.showMessageDialog(this, "Le nom doit tre indiqu.");
      return;
    }
    
    // Modifier l'action
    try {
      _stockList.updateStock(ticker, name);
      JOptionPane.showMessageDialog(this, "Action modifie !");
    }
    catch (FinderException fe) {
      JOptionPane.showMessageDialog(this, "Non trouv !");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  private void deleteStock() {
    // Lire le symbole
    String ticker = _ticker.getText();
    if (ticker == null || ticker.length() == 0) {
      JOptionPane.showMessageDialog(this, "Le symbole doit tre indiqu.");
      return;
    }
    
    // Supprimer l'action
    try {
      _stockList.deleteStock(ticker);
      JOptionPane.showMessageDialog(this, "Action supprime !");
    }
    catch (FinderException fe) {
      JOptionPane.showMessageDialog(this, "Non trouv !");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  public static void main(String[] args) {
    StockClient stockClient = new StockClient();
  }
}