package beans;

import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

// general imports
import java.util.*;

public class StockListBean implements SessionBean {
  
  // Mthodes publiques. Ces mthodes doivent galement 
  // tre dclares dans l'interface. 
  
  public String getStock(String ticker) throws FinderException {
    try {
      LocalStockHome stockHome = getStockHome();
      LocalStock stock = stockHome.findByPrimaryKey(ticker);
      return stock.getName();
    }
    catch (FinderException fe) {
      throw fe;
    }
    catch (Exception ex) {
      throw new RuntimeException(ex.getMessage());
    }
  }
  
  public String[] getAllStocks() throws FinderException {
    try {
      LocalStockHome stockHome = getStockHome();
      Collection stockColl = stockHome.findAllStocks();
      String[] stocks = new String[stockColl.size()];
      int j = 0;
      Iterator i = stockColl.iterator();
      while (i.hasNext()) {
        LocalStock stock = (LocalStock) i.next();
        stocks[j++] = stock.getTickerSymbol();
      }
      
      return stocks;
    }
    catch (FinderException fe) {
      throw fe;
    }
    catch (Exception ex) {
      throw new RuntimeException(ex.getMessage());
    }
  }
  
  public String[] getSizeStocks(int siz) throws FinderException {
    try {
      LocalStockHome stockHome = getStockHome();
      Collection stockColl = stockHome.findSizeStocks(siz);
      String[] stocks = new String[stockColl.size()];
      int j = 0;
      Iterator i = stockColl.iterator();
      while (i.hasNext()) {
        LocalStock stock = (LocalStock) i.next();
        stocks[j++] = stock.getTickerSymbol();
      }
      
      return stocks;
    }
    catch (FinderException fe) {
      throw fe;
    }
    catch (Exception ex) {
      throw new RuntimeException(ex.getMessage());
    }
  }
  
  private LocalStockHome getStockHome() throws NamingException {
    // Obtenir un contexte initial
    InitialContext initial = new InitialContext();
    
    // Obtenir une rfrence  l'objet
    Object objref = initial.lookup("java:comp/env/ejb/beans.Stock");
    LocalStockHome home = (LocalStockHome) objref;
    return home;
  }
  

  // Mthodes EJB standards
  public void ejbActivate() { }
  public void ejbPassivate() { }
  public void ejbRemove() { }
  public void ejbCreate() { }
  public void setSessionContext(SessionContext context) { }
}